/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.filter;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.metamx.common.StringUtils;
import io.druid.query.filter.DimFilter;
import io.druid.query.search.search.SearchQuerySpec;
import java.nio.ByteBuffer;

public class SearchQueryDimFilter
implements DimFilter {
    private final String dimension;
    private final SearchQuerySpec query;

    public SearchQueryDimFilter(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="query") SearchQuerySpec query) {
        Preconditions.checkArgument((dimension != null ? 1 : 0) != 0, (Object)"dimension must not be null");
        Preconditions.checkArgument((query != null ? 1 : 0) != 0, (Object)"query must not be null");
        this.dimension = dimension;
        this.query = query;
    }

    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @JsonProperty
    public SearchQuerySpec getQuery() {
        return this.query;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] dimensionBytes = StringUtils.toUtf8((String)this.dimension);
        byte[] queryBytes = this.query.getCacheKey();
        return ByteBuffer.allocate(1 + dimensionBytes.length + queryBytes.length).put((byte)6).put(dimensionBytes).put(queryBytes).array();
    }

    public String toString() {
        return "SearchQueryDimFilter{dimension='" + this.dimension + '\'' + ", query=" + this.query + '}';
    }
}

