/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.metamx.common.StringUtils;
import io.druid.query.filter.DimFilter;
import java.nio.ByteBuffer;

public class RegexDimFilter
implements DimFilter {
    private final String dimension;
    private final String pattern;

    @JsonCreator
    public RegexDimFilter(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="pattern") String pattern) {
        Preconditions.checkArgument((dimension != null ? 1 : 0) != 0, (Object)"dimension must not be null");
        Preconditions.checkArgument((pattern != null ? 1 : 0) != 0, (Object)"pattern must not be null");
        this.dimension = dimension;
        this.pattern = pattern;
    }

    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @JsonProperty
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] dimensionBytes = StringUtils.toUtf8((String)this.dimension);
        byte[] patternBytes = StringUtils.toUtf8((String)this.pattern);
        return ByteBuffer.allocate(1 + dimensionBytes.length + patternBytes.length).put((byte)5).put(dimensionBytes).put(patternBytes).array();
    }

    public String toString() {
        return "RegexDimFilter{dimension='" + this.dimension + '\'' + ", pattern='" + this.pattern + '\'' + '}';
    }
}

