/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.druid.query.filter.DimFilter;
import java.nio.ByteBuffer;

public class NotDimFilter
implements DimFilter {
    private final DimFilter field;

    @JsonCreator
    public NotDimFilter(@JsonProperty(value="field") DimFilter field) {
        Preconditions.checkArgument((field != null ? 1 : 0) != 0, (Object)"NOT operator requires at least one field");
        this.field = field;
    }

    @JsonProperty(value="field")
    public DimFilter getField() {
        return this.field;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] subKey = this.field.getCacheKey();
        return ByteBuffer.allocate(1 + subKey.length).put((byte)3).put(subKey).array();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotDimFilter that = (NotDimFilter)o;
        return !(this.field != null ? !this.field.equals(that.field) : that.field != null);
    }

    public int hashCode() {
        return this.field != null ? this.field.hashCode() : 0;
    }

    public String toString() {
        return "!" + this.field;
    }
}

