/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.extraction;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.druid.query.extraction.DimExtractionFn;
import io.druid.query.search.search.SearchQuerySpec;
import java.nio.ByteBuffer;

public class SearchQuerySpecDimExtractionFn
extends DimExtractionFn {
    private static final byte CACHE_TYPE_ID = 3;
    private final SearchQuerySpec searchQuerySpec;

    @JsonCreator
    public SearchQuerySpecDimExtractionFn(@JsonProperty(value="query") SearchQuerySpec searchQuerySpec) {
        Preconditions.checkNotNull((Object)searchQuerySpec, (Object)"search query must not be null");
        this.searchQuerySpec = searchQuerySpec;
    }

    @JsonProperty(value="query")
    public SearchQuerySpec getSearchQuerySpec() {
        return this.searchQuerySpec;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] specBytes = this.searchQuerySpec.getCacheKey();
        return ByteBuffer.allocate(1 + specBytes.length).put((byte)3).put(specBytes).array();
    }

    @Override
    public String apply(String dimValue) {
        return this.searchQuerySpec.accept(dimValue) ? dimValue : null;
    }

    @Override
    public boolean preservesOrdering() {
        return true;
    }

    public String toString() {
        return "SearchQuerySpecDimExtractionFn{searchQuerySpec=" + this.searchQuerySpec + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchQuerySpecDimExtractionFn that = (SearchQuerySpecDimExtractionFn)o;
        return this.searchQuerySpec.equals(that.searchQuerySpec);
    }

    public int hashCode() {
        return this.searchQuerySpec.hashCode();
    }
}

