/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.extraction;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.metamx.common.StringUtils;
import io.druid.query.extraction.DimExtractionFn;
import java.nio.ByteBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexDimExtractionFn
extends DimExtractionFn {
    private static final byte CACHE_TYPE_ID = 1;
    private final String expr;
    private final Pattern pattern;

    @JsonCreator
    public RegexDimExtractionFn(@JsonProperty(value="expr") String expr) {
        Preconditions.checkNotNull((Object)expr, (Object)"expr must not be null");
        this.expr = expr;
        this.pattern = Pattern.compile(expr);
    }

    @Override
    public byte[] getCacheKey() {
        byte[] exprBytes = StringUtils.toUtf8((String)this.expr);
        return ByteBuffer.allocate(1 + exprBytes.length).put((byte)1).put(exprBytes).array();
    }

    @Override
    public String apply(String dimValue) {
        Matcher matcher = this.pattern.matcher(dimValue);
        return matcher.find() ? matcher.group(1) : dimValue;
    }

    @JsonProperty(value="expr")
    public String getExpr() {
        return this.expr;
    }

    @Override
    public boolean preservesOrdering() {
        return false;
    }

    public String toString() {
        return String.format("regex(%s)", this.expr);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegexDimExtractionFn that = (RegexDimExtractionFn)o;
        return this.expr.equals(that.expr);
    }

    public int hashCode() {
        return this.expr.hashCode();
    }
}

