/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.extraction;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.metamx.common.StringUtils;
import io.druid.query.extraction.ExtractionFn;
import java.nio.ByteBuffer;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JavascriptExtractionFn
implements ExtractionFn {
    private static final byte CACHE_TYPE_ID = 4;
    private final String function;
    private final Function<Object, String> fn;

    private static Function<Object, String> compile(String function) {
        final ContextFactory contextFactory = ContextFactory.getGlobal();
        Context context = contextFactory.enterContext();
        context.setOptimizationLevel(9);
        final ScriptableObject scope = context.initStandardObjects();
        final org.mozilla.javascript.Function fn = context.compileFunction((Scriptable)scope, function, "fn", 1, null);
        Context.exit();
        return new Function<Object, String>(){

            public String apply(Object input) {
                Object res;
                Context cx = Context.getCurrentContext();
                if (cx == null) {
                    cx = contextFactory.enterContext();
                }
                return (res = fn.call(cx, (Scriptable)scope, (Scriptable)scope, new Object[]{input})) != null ? Context.toString((Object)res) : null;
            }
        };
    }

    @JsonCreator
    public JavascriptExtractionFn(@JsonProperty(value="function") String function) {
        Preconditions.checkNotNull((Object)function, (Object)"function must not be null");
        this.function = function;
        this.fn = JavascriptExtractionFn.compile(function);
    }

    @JsonProperty
    public String getFunction() {
        return this.function;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] bytes = StringUtils.toUtf8((String)this.function);
        return ByteBuffer.allocate(1 + bytes.length).put((byte)4).put(bytes).array();
    }

    @Override
    public String apply(Object value) {
        return Strings.emptyToNull((String)((String)this.fn.apply(value)));
    }

    @Override
    public String apply(String value) {
        return this.apply((Object)value);
    }

    @Override
    public String apply(long value) {
        return this.apply((Object)value);
    }

    @Override
    public boolean preservesOrdering() {
        return false;
    }

    public String toString() {
        return "JavascriptDimExtractionFn{function='" + this.function + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavascriptExtractionFn that = (JavascriptExtractionFn)o;
        return this.function.equals(that.function);
    }

    public int hashCode() {
        return this.function.hashCode();
    }
}

