/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.dimension;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.metamx.common.StringUtils;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.extraction.ExtractionFn;
import java.nio.ByteBuffer;

public class DefaultDimensionSpec
implements DimensionSpec {
    private static final byte CACHE_TYPE_ID = 0;
    private final String dimension;
    private final String outputName;

    @JsonCreator
    public DefaultDimensionSpec(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="outputName") String outputName) {
        this.dimension = dimension;
        this.outputName = outputName == null ? dimension : outputName;
    }

    @Override
    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @Override
    @JsonProperty
    public String getOutputName() {
        return this.outputName;
    }

    @Override
    public ExtractionFn getExtractionFn() {
        return null;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] dimensionBytes = StringUtils.toUtf8((String)this.dimension);
        return ByteBuffer.allocate(1 + dimensionBytes.length).put((byte)0).put(dimensionBytes).array();
    }

    @Override
    public boolean preservesOrdering() {
        return true;
    }

    public String toString() {
        return "DefaultDimensionSpec{dimension='" + this.dimension + '\'' + ", outputName='" + this.outputName + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultDimensionSpec that = (DefaultDimensionSpec)o;
        if (this.dimension != null ? !this.dimension.equals(that.dimension) : that.dimension != null) {
            return false;
        }
        return !(this.outputName != null ? !this.outputName.equals(that.outputName) : that.outputName != null);
    }

    public int hashCode() {
        int result = this.dimension != null ? this.dimension.hashCode() : 0;
        result = 31 * result + (this.outputName != null ? this.outputName.hashCode() : 0);
        return result;
    }
}

