/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.datasourcemetadata;

import com.google.inject.Inject;
import com.metamx.common.ISE;
import com.metamx.common.guava.BaseSequence;
import com.metamx.common.guava.Sequence;
import io.druid.query.ChainedExecutionQueryRunner;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerFactory;
import io.druid.query.QueryToolChest;
import io.druid.query.QueryWatcher;
import io.druid.query.Result;
import io.druid.query.datasourcemetadata.DataSourceMetadataQuery;
import io.druid.query.datasourcemetadata.DataSourceMetadataResultValue;
import io.druid.query.datasourcemetadata.DataSourceQueryQueryToolChest;
import io.druid.segment.Segment;
import io.druid.segment.StorageAdapter;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class DataSourceMetadataQueryRunnerFactory
implements QueryRunnerFactory<Result<DataSourceMetadataResultValue>, DataSourceMetadataQuery> {
    private static final DataSourceQueryQueryToolChest toolChest = new DataSourceQueryQueryToolChest();
    private final QueryWatcher queryWatcher;

    @Inject
    public DataSourceMetadataQueryRunnerFactory(QueryWatcher queryWatcher) {
        this.queryWatcher = queryWatcher;
    }

    @Override
    public QueryRunner<Result<DataSourceMetadataResultValue>> createRunner(Segment segment) {
        return new DataSourceMetadataQueryRunner(segment);
    }

    @Override
    public QueryRunner<Result<DataSourceMetadataResultValue>> mergeRunners(ExecutorService queryExecutor, Iterable<QueryRunner<Result<DataSourceMetadataResultValue>>> queryRunners) {
        return new ChainedExecutionQueryRunner<Result<DataSourceMetadataResultValue>>(queryExecutor, toolChest.getOrdering(), this.queryWatcher, queryRunners);
    }

    @Override
    public QueryToolChest<Result<DataSourceMetadataResultValue>, DataSourceMetadataQuery> getToolchest() {
        return toolChest;
    }

    private static class DataSourceMetadataQueryRunner
    implements QueryRunner<Result<DataSourceMetadataResultValue>> {
        private final StorageAdapter adapter;

        public DataSourceMetadataQueryRunner(Segment segment) {
            this.adapter = segment.asStorageAdapter();
        }

        @Override
        public Sequence<Result<DataSourceMetadataResultValue>> run(Query<Result<DataSourceMetadataResultValue>> input, Map<String, Object> responseContext) {
            if (!(input instanceof DataSourceMetadataQuery)) {
                throw new ISE("Got a [%s] which isn't a %s", new Object[]{input.getClass().getCanonicalName(), DataSourceMetadataQuery.class});
            }
            final DataSourceMetadataQuery legacyQuery = (DataSourceMetadataQuery)input;
            return new BaseSequence((BaseSequence.IteratorMaker)new BaseSequence.IteratorMaker<Result<DataSourceMetadataResultValue>, Iterator<Result<DataSourceMetadataResultValue>>>(){

                public Iterator<Result<DataSourceMetadataResultValue>> make() {
                    if (DataSourceMetadataQueryRunner.this.adapter == null) {
                        throw new ISE("Null storage adapter found. Probably trying to issue a query against a segment being memory unmapped.", new Object[0]);
                    }
                    return legacyQuery.buildResult(DataSourceMetadataQueryRunner.this.adapter.getInterval().getStart(), DataSourceMetadataQueryRunner.this.adapter.getMaxIngestedEventTime()).iterator();
                }

                public void cleanup(Iterator<Result<DataSourceMetadataResultValue>> toClean) {
                }
            });
        }
    }
}

