/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.hyperloglog;

import com.google.common.collect.Ordering;
import com.google.common.hash.HashFunction;
import com.metamx.common.StringUtils;
import io.druid.data.input.InputRow;
import io.druid.query.aggregation.hyperloglog.HyperLogLogCollector;
import io.druid.segment.column.ColumnBuilder;
import io.druid.segment.data.GenericIndexed;
import io.druid.segment.data.ObjectStrategy;
import io.druid.segment.serde.ColumnPartSerde;
import io.druid.segment.serde.ComplexColumnPartSerde;
import io.druid.segment.serde.ComplexColumnPartSupplier;
import io.druid.segment.serde.ComplexMetricExtractor;
import io.druid.segment.serde.ComplexMetricSerde;
import java.nio.ByteBuffer;
import java.util.List;

public class HyperUniquesSerde
extends ComplexMetricSerde {
    private static Ordering<HyperLogLogCollector> comparator = new Ordering<HyperLogLogCollector>(){

        public int compare(HyperLogLogCollector arg1, HyperLogLogCollector arg2) {
            return arg1.toByteBuffer().compareTo(arg2.toByteBuffer());
        }
    }.nullsFirst();
    private final HashFunction hashFn;

    public HyperUniquesSerde(HashFunction hashFn) {
        this.hashFn = hashFn;
    }

    @Override
    public String getTypeName() {
        return "hyperUnique";
    }

    @Override
    public ComplexMetricExtractor getExtractor() {
        return new ComplexMetricExtractor(){

            public Class<HyperLogLogCollector> extractedClass() {
                return HyperLogLogCollector.class;
            }

            @Override
            public HyperLogLogCollector extractValue(InputRow inputRow, String metricName) {
                Object rawValue = inputRow.getRaw(metricName);
                if (rawValue instanceof HyperLogLogCollector) {
                    return (HyperLogLogCollector)rawValue;
                }
                HyperLogLogCollector collector = HyperLogLogCollector.makeLatestCollector();
                List dimValues = inputRow.getDimension(metricName);
                if (dimValues == null) {
                    return collector;
                }
                for (String dimensionValue : dimValues) {
                    collector.add(HyperUniquesSerde.this.hashFn.hashBytes(StringUtils.toUtf8((String)dimensionValue)).asBytes());
                }
                return collector;
            }
        };
    }

    @Override
    public ColumnPartSerde deserializeColumn(ByteBuffer byteBuffer, ColumnBuilder columnBuilder) {
        GenericIndexed column = GenericIndexed.read(byteBuffer, this.getObjectStrategy());
        columnBuilder.setComplexColumn(new ComplexColumnPartSupplier(this.getTypeName(), column));
        return new ComplexColumnPartSerde(column, this.getTypeName());
    }

    @Override
    public ObjectStrategy getObjectStrategy() {
        return new ObjectStrategy<HyperLogLogCollector>(){

            @Override
            public Class<? extends HyperLogLogCollector> getClazz() {
                return HyperLogLogCollector.class;
            }

            @Override
            public HyperLogLogCollector fromByteBuffer(ByteBuffer buffer, int numBytes) {
                ByteBuffer readOnlyBuffer = buffer.asReadOnlyBuffer();
                readOnlyBuffer.limit(readOnlyBuffer.position() + numBytes);
                return HyperLogLogCollector.makeCollector(readOnlyBuffer);
            }

            @Override
            public byte[] toBytes(HyperLogLogCollector collector) {
                if (collector == null) {
                    return new byte[0];
                }
                ByteBuffer val = collector.toByteBuffer();
                byte[] retVal = new byte[val.remaining()];
                val.asReadOnlyBuffer().get(retVal);
                return retVal;
            }

            @Override
            public int compare(HyperLogLogCollector o1, HyperLogLogCollector o2) {
                return comparator.compare((Object)o1, (Object)o2);
            }
        };
    }
}

