/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation;

import io.druid.query.aggregation.Aggregator;
import io.druid.query.aggregation.DoubleSumAggregator;
import io.druid.segment.FloatColumnSelector;
import java.util.Comparator;

public class MinAggregator
implements Aggregator {
    static final Comparator COMPARATOR = DoubleSumAggregator.COMPARATOR;
    private final FloatColumnSelector selector;
    private final String name;
    private double min;

    static double combineValues(Object lhs, Object rhs) {
        return Math.min(((Number)lhs).doubleValue(), ((Number)rhs).doubleValue());
    }

    public MinAggregator(String name, FloatColumnSelector selector) {
        this.name = name;
        this.selector = selector;
        this.reset();
    }

    @Override
    public void aggregate() {
        this.min = Math.min(this.min, (double)this.selector.get());
    }

    @Override
    public void reset() {
        this.min = Double.POSITIVE_INFINITY;
    }

    @Override
    public Object get() {
        return this.min;
    }

    @Override
    public float getFloat() {
        return (float)this.min;
    }

    @Override
    public long getLong() {
        return (long)this.min;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Aggregator clone() {
        return new MinAggregator(this.name, this.selector);
    }

    @Override
    public void close() {
    }
}

