/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.metamx.emitter.service.ServiceMetricEvent;
import io.druid.query.DataSourceUtil;
import io.druid.query.Query;
import org.joda.time.Interval;

public class QueryMetricUtil {
    public static <T> ServiceMetricEvent.Builder makeQueryTimeMetric(Query<T> query) {
        return new ServiceMetricEvent.Builder().setUser2(DataSourceUtil.getMetricName(query.getDataSource())).setUser4(query.getType()).setUser5(Lists.transform(query.getIntervals(), (Function)new Function<Interval, String>(){

            public String apply(Interval input) {
                return input.toString();
            }
        }).toArray(new String[query.getIntervals().size()])).setUser6(String.valueOf(query.hasFilters())).setUser9(query.getDuration().toPeriod().toStandardMinutes().toString());
    }

    public static <T> ServiceMetricEvent.Builder makeRequestTimeMetric(ObjectMapper jsonMapper, Query<T> query, String remoteAddr) throws JsonProcessingException {
        return QueryMetricUtil.makeQueryTimeMetric(query).setUser3(jsonMapper.writeValueAsString(query.getContext() == null ? ImmutableMap.of() : query.getContext())).setUser7(remoteAddr).setUser8(query.getId());
    }
}

