/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.metamx.common.guava.FunctionalIterable;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.emitter.service.ServiceMetricEvent;
import io.druid.granularity.PeriodGranularity;
import io.druid.query.AsyncQueryRunner;
import io.druid.query.MetricsEmittingQueryRunner;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QueryToolChest;
import io.druid.query.QueryWatcher;
import io.druid.query.spec.MultipleIntervalSegmentSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.joda.time.Interval;
import org.joda.time.Period;

public class IntervalChunkingQueryRunner<T>
implements QueryRunner<T> {
    private final QueryRunner<T> baseRunner;
    private final QueryToolChest<T, Query<T>> toolChest;
    private final ExecutorService executor;
    private final QueryWatcher queryWatcher;
    private final ServiceEmitter emitter;

    public IntervalChunkingQueryRunner(QueryRunner<T> baseRunner, QueryToolChest<T, Query<T>> toolChest, ExecutorService executor, QueryWatcher queryWatcher, ServiceEmitter emitter) {
        this.baseRunner = baseRunner;
        this.toolChest = toolChest;
        this.executor = executor;
        this.queryWatcher = queryWatcher;
        this.emitter = emitter;
    }

    @Override
    public Sequence<T> run(final Query<T> query, final Map<String, Object> responseContext) {
        final Period chunkPeriod = this.getChunkPeriod(query);
        if (chunkPeriod.toStandardDuration().getMillis() == 0L) {
            return this.baseRunner.run(query, responseContext);
        }
        ArrayList chunkIntervals = Lists.newArrayList((Iterable)FunctionalIterable.create(query.getIntervals()).transformCat((Function)new Function<Interval, Iterable<Interval>>(){

            public Iterable<Interval> apply(Interval input) {
                return IntervalChunkingQueryRunner.this.splitInterval(input, chunkPeriod);
            }
        }));
        if (chunkIntervals.size() <= 1) {
            return this.baseRunner.run(query, responseContext);
        }
        final AsyncQueryRunner<T> finalQueryRunner = new AsyncQueryRunner<T>(this.toolChest.mergeResults(new MetricsEmittingQueryRunner<T>(this.emitter, new Function<Query<T>, ServiceMetricEvent.Builder>(){

            public ServiceMetricEvent.Builder apply(Query<T> input) {
                return IntervalChunkingQueryRunner.this.toolChest.makeMetricBuilder(input);
            }
        }, this.baseRunner).withWaitMeasuredFromNow()), this.executor, this.queryWatcher);
        return Sequences.concat((Iterable)Lists.newArrayList((Iterable)FunctionalIterable.create((Iterable)chunkIntervals).transform(new Function<Interval, Sequence<T>>(){

            public Sequence<T> apply(Interval singleInterval) {
                return finalQueryRunner.run(query.withQuerySegmentSpec(new MultipleIntervalSegmentSpec(Arrays.asList(singleInterval))), responseContext);
            }
        })));
    }

    private Iterable<Interval> splitInterval(Interval interval, Period period) {
        if (interval.getEndMillis() == interval.getStartMillis()) {
            return Lists.newArrayList((Object[])new Interval[]{interval});
        }
        ArrayList intervals = Lists.newArrayList();
        Iterator<Long> timestamps = new PeriodGranularity(period, null, null).iterable(interval.getStartMillis(), interval.getEndMillis()).iterator();
        long start = Math.max(timestamps.next(), interval.getStartMillis());
        while (timestamps.hasNext()) {
            long end = timestamps.next();
            intervals.add(new Interval(start, end));
            start = end;
        }
        if (start < interval.getEndMillis()) {
            intervals.add(new Interval(start, interval.getEndMillis()));
        }
        return intervals;
    }

    private Period getChunkPeriod(Query<T> query) {
        String p = query.getContextValue("chunkPeriod", "P0D");
        return Period.parse((String)p);
    }
}

