/*
 * Decompiled with CFR 0.152.
 */
package io.druid.jackson;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.hash.Hashing;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.CountAggregatorFactory;
import io.druid.query.aggregation.DoubleSumAggregatorFactory;
import io.druid.query.aggregation.FilteredAggregatorFactory;
import io.druid.query.aggregation.HistogramAggregatorFactory;
import io.druid.query.aggregation.JavaScriptAggregatorFactory;
import io.druid.query.aggregation.LongSumAggregatorFactory;
import io.druid.query.aggregation.MaxAggregatorFactory;
import io.druid.query.aggregation.MinAggregatorFactory;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.aggregation.cardinality.CardinalityAggregatorFactory;
import io.druid.query.aggregation.hyperloglog.HyperUniqueFinalizingPostAggregator;
import io.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import io.druid.query.aggregation.hyperloglog.HyperUniquesSerde;
import io.druid.query.aggregation.post.ArithmeticPostAggregator;
import io.druid.query.aggregation.post.ConstantPostAggregator;
import io.druid.query.aggregation.post.FieldAccessPostAggregator;
import io.druid.query.aggregation.post.JavaScriptPostAggregator;
import io.druid.segment.serde.ComplexMetrics;

public class AggregatorsModule
extends SimpleModule {
    public AggregatorsModule() {
        super("AggregatorFactories");
        if (ComplexMetrics.getSerdeForType("hyperUnique") == null) {
            ComplexMetrics.registerSerde("hyperUnique", new HyperUniquesSerde(Hashing.murmur3_128()));
        }
        this.setMixInAnnotation(AggregatorFactory.class, AggregatorFactoryMixin.class);
        this.setMixInAnnotation(PostAggregator.class, PostAggregatorMixin.class);
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
    @JsonSubTypes(value={@JsonSubTypes.Type(name="arithmetic", value=ArithmeticPostAggregator.class), @JsonSubTypes.Type(name="fieldAccess", value=FieldAccessPostAggregator.class), @JsonSubTypes.Type(name="constant", value=ConstantPostAggregator.class), @JsonSubTypes.Type(name="javascript", value=JavaScriptPostAggregator.class), @JsonSubTypes.Type(name="hyperUniqueCardinality", value=HyperUniqueFinalizingPostAggregator.class)})
    public static interface PostAggregatorMixin {
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
    @JsonSubTypes(value={@JsonSubTypes.Type(name="count", value=CountAggregatorFactory.class), @JsonSubTypes.Type(name="longSum", value=LongSumAggregatorFactory.class), @JsonSubTypes.Type(name="doubleSum", value=DoubleSumAggregatorFactory.class), @JsonSubTypes.Type(name="max", value=MaxAggregatorFactory.class), @JsonSubTypes.Type(name="min", value=MinAggregatorFactory.class), @JsonSubTypes.Type(name="javascript", value=JavaScriptAggregatorFactory.class), @JsonSubTypes.Type(name="histogram", value=HistogramAggregatorFactory.class), @JsonSubTypes.Type(name="hyperUnique", value=HyperUniquesAggregatorFactory.class), @JsonSubTypes.Type(name="cardinality", value=CardinalityAggregatorFactory.class), @JsonSubTypes.Type(name="filtered", value=FilteredAggregatorFactory.class)})
    public static interface AggregatorFactoryMixin {
    }
}

