/*
 * Decompiled with CFR 0.152.
 */
package io.druid.guice;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.metamx.common.ISE;
import io.druid.guice.annotations.Json;
import io.druid.guice.annotations.Smile;
import io.druid.initialization.DruidModule;
import java.util.Collections;
import java.util.List;

public class ModuleList {
    private final Injector baseInjector;
    private final ObjectMapper jsonMapper;
    private final ObjectMapper smileMapper;
    private final List<Module> modules;

    public ModuleList(Injector baseInjector) {
        this.baseInjector = baseInjector;
        this.jsonMapper = (ObjectMapper)baseInjector.getInstance(Key.get(ObjectMapper.class, Json.class));
        this.smileMapper = (ObjectMapper)baseInjector.getInstance(Key.get(ObjectMapper.class, Smile.class));
        this.modules = Lists.newArrayList();
    }

    public List<Module> getModules() {
        return Collections.unmodifiableList(this.modules);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addModule(Object input) {
        if (input instanceof DruidModule) {
            this.baseInjector.injectMembers(input);
            this.modules.add((Module)this.registerJacksonModules((DruidModule)input));
            return;
        } else if (input instanceof Module) {
            this.baseInjector.injectMembers(input);
            this.modules.add((Module)input);
            return;
        } else {
            if (!(input instanceof Class)) throw new ISE("Unknown module type[%s]", new Object[]{input.getClass()});
            if (DruidModule.class.isAssignableFrom((Class)input)) {
                this.modules.add((Module)this.registerJacksonModules((DruidModule)this.baseInjector.getInstance((Class)input)));
                return;
            } else {
                if (!Module.class.isAssignableFrom((Class)input)) throw new ISE("Class[%s] does not implement %s", new Object[]{input.getClass(), Module.class});
                this.modules.add((Module)this.baseInjector.getInstance((Class)input));
                return;
            }
        }
    }

    public void addModules(Object ... object) {
        for (Object o : object) {
            this.addModule(o);
        }
    }

    private DruidModule registerJacksonModules(DruidModule module) {
        for (com.fasterxml.jackson.databind.Module jacksonModule : module.getJacksonModules()) {
            this.jsonMapper.registerModule(jacksonModule);
            this.smileMapper.registerModule(jacksonModule);
        }
        return module;
    }
}

