/*
 * Decompiled with CFR 0.152.
 */
package io.druid.guice;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.validation.constraints.NotNull;

public class ExtensionsConfig {
    public static final String PACKAGE_VERSION = ExtensionsConfig.class.getPackage().getImplementationVersion();
    @JsonProperty
    @NotNull
    private boolean searchCurrentClassloader = true;
    @JsonProperty
    @NotNull
    private List<String> coordinates = ImmutableList.of();
    @JsonProperty
    private String defaultVersion;
    @JsonProperty
    @NotNull
    private String localRepository = String.format("%s/%s", System.getProperty("user.home"), ".m2/repository");
    @JsonProperty
    @NotNull
    private List<String> remoteRepositories = ImmutableList.of((Object)"https://repo1.maven.org/maven2/", (Object)"https://metamx.artifactoryonline.com/metamx/pub-libs-releases-local");

    public boolean searchCurrentClassloader() {
        return this.searchCurrentClassloader;
    }

    public List<String> getCoordinates() {
        return this.coordinates;
    }

    public String getDefaultVersion() {
        return this.defaultVersion != null ? this.defaultVersion : PACKAGE_VERSION;
    }

    public String getLocalRepository() {
        return this.localRepository;
    }

    public List<String> getRemoteRepositories() {
        return this.remoteRepositories;
    }

    public String toString() {
        return "ExtensionsConfig{searchCurrentClassloader=" + this.searchCurrentClassloader + ", coordinates=" + this.coordinates + ", defaultVersion='" + this.getDefaultVersion() + '\'' + ", localRepository='" + this.localRepository + '\'' + ", remoteRepositories=" + this.remoteRepositories + '}';
    }
}

