/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.incremental;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import io.druid.collections.StupidPool;
import io.druid.data.input.InputRow;
import io.druid.data.input.MapBasedInputRow;
import io.druid.data.input.MapBasedRow;
import io.druid.granularity.QueryGranularity;
import io.druid.query.Result;
import io.druid.query.TestQueryRunners;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.CountAggregatorFactory;
import io.druid.query.aggregation.JavaScriptAggregatorFactory;
import io.druid.query.aggregation.LongSumAggregatorFactory;
import io.druid.query.filter.DimFilter;
import io.druid.query.filter.DimFilters;
import io.druid.query.filter.Filter;
import io.druid.query.groupby.GroupByQuery;
import io.druid.query.groupby.GroupByQueryConfig;
import io.druid.query.groupby.GroupByQueryEngine;
import io.druid.query.topn.TopNQueryBuilder;
import io.druid.query.topn.TopNQueryEngine;
import io.druid.query.topn.TopNResultValue;
import io.druid.segment.Cursor;
import io.druid.segment.DimensionSelector;
import io.druid.segment.StorageAdapter;
import io.druid.segment.filter.SelectorFilter;
import io.druid.segment.incremental.IncrementalIndex;
import io.druid.segment.incremental.IncrementalIndexStorageAdapter;
import io.druid.segment.incremental.OffheapIncrementalIndex;
import io.druid.segment.incremental.OnheapIncrementalIndex;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IncrementalIndexStorageAdapterTest {
    private final IndexCreator indexCreator;

    public IncrementalIndexStorageAdapterTest(IndexCreator IndexCreator2) {
        this.indexCreator = IndexCreator2;
    }

    @Parameterized.Parameters
    public static Collection<?> constructorFeeder() throws IOException {
        return Arrays.asList({new IndexCreator(){

            @Override
            public IncrementalIndex createIndex() {
                return new OnheapIncrementalIndex(0L, QueryGranularity.MINUTE, new AggregatorFactory[]{new CountAggregatorFactory("cnt")}, 1000);
            }
        }}, {new IndexCreator(){

            @Override
            public IncrementalIndex createIndex() {
                return new OffheapIncrementalIndex(0L, QueryGranularity.MINUTE, new AggregatorFactory[]{new CountAggregatorFactory("cnt")}, TestQueryRunners.pool, true, 0x6400000);
            }
        }});
    }

    @Test
    public void testSanity() throws Exception {
        IncrementalIndex index = this.indexCreator.createIndex();
        index.add((InputRow)new MapBasedInputRow(new DateTime().minus(1L).getMillis(), (List)Lists.newArrayList((Object[])new String[]{"billy"}), (Map)ImmutableMap.of((Object)"billy", (Object)"hi")));
        index.add((InputRow)new MapBasedInputRow(new DateTime().minus(1L).getMillis(), (List)Lists.newArrayList((Object[])new String[]{"sally"}), (Map)ImmutableMap.of((Object)"sally", (Object)"bo")));
        GroupByQueryEngine engine = IncrementalIndexStorageAdapterTest.makeGroupByQueryEngine();
        Sequence rows = engine.process(GroupByQuery.builder().setDataSource("test").setGranularity(QueryGranularity.ALL).setInterval(new Interval(0L, new DateTime().getMillis())).addDimension("billy").addDimension("sally").addAggregator((AggregatorFactory)new LongSumAggregatorFactory("cnt", "cnt")).build(), (StorageAdapter)new IncrementalIndexStorageAdapter(index));
        ArrayList results = (ArrayList)Sequences.toList((Sequence)rows, (List)Lists.newArrayList());
        Assert.assertEquals((long)2L, (long)results.size());
        MapBasedRow row = (MapBasedRow)results.get(0);
        Assert.assertEquals((Object)ImmutableMap.of((Object)"billy", (Object)"hi", (Object)"cnt", (Object)1L), (Object)row.getEvent());
        row = (MapBasedRow)results.get(1);
        Assert.assertEquals((Object)ImmutableMap.of((Object)"sally", (Object)"bo", (Object)"cnt", (Object)1L), (Object)row.getEvent());
    }

    @Test
    public void testObjectColumnSelectorOnVaryingColumnSchema() throws Exception {
        IncrementalIndex index = this.indexCreator.createIndex();
        index.add((InputRow)new MapBasedInputRow(new DateTime((Object)"2014-09-01T00:00:00"), (List)Lists.newArrayList((Object[])new String[]{"billy"}), (Map)ImmutableMap.of((Object)"billy", (Object)"hi")));
        index.add((InputRow)new MapBasedInputRow(new DateTime((Object)"2014-09-01T01:00:00"), (List)Lists.newArrayList((Object[])new String[]{"billy", "sally"}), (Map)ImmutableMap.of((Object)"billy", (Object)"hip", (Object)"sally", (Object)"hop")));
        GroupByQueryEngine engine = IncrementalIndexStorageAdapterTest.makeGroupByQueryEngine();
        Sequence rows = engine.process(GroupByQuery.builder().setDataSource("test").setGranularity(QueryGranularity.ALL).setInterval(new Interval(0L, new DateTime().getMillis())).addDimension("billy").addDimension("sally").addAggregator((AggregatorFactory)new LongSumAggregatorFactory("cnt", "cnt")).addAggregator((AggregatorFactory)new JavaScriptAggregatorFactory("fieldLength", Arrays.asList("sally", "billy"), "function(current, s, b) { return current + (s == null ? 0 : s.length) + (b == null ? 0 : b.length); }", "function() { return 0; }", "function(a,b) { return a + b; }")).build(), (StorageAdapter)new IncrementalIndexStorageAdapter(index));
        ArrayList results = (ArrayList)Sequences.toList((Sequence)rows, (List)Lists.newArrayList());
        Assert.assertEquals((long)2L, (long)results.size());
        MapBasedRow row = (MapBasedRow)results.get(0);
        Assert.assertEquals((Object)ImmutableMap.of((Object)"billy", (Object)"hi", (Object)"cnt", (Object)1L, (Object)"fieldLength", (Object)2.0), (Object)row.getEvent());
        row = (MapBasedRow)results.get(1);
        Assert.assertEquals((Object)ImmutableMap.of((Object)"billy", (Object)"hip", (Object)"sally", (Object)"hop", (Object)"cnt", (Object)1L, (Object)"fieldLength", (Object)6.0), (Object)row.getEvent());
    }

    private static GroupByQueryEngine makeGroupByQueryEngine() {
        return new GroupByQueryEngine(Suppliers.ofInstance((Object)new GroupByQueryConfig(){

            public int getMaxIntermediateRows() {
                return 5;
            }
        }), new StupidPool((Supplier)new Supplier<ByteBuffer>(){

            public ByteBuffer get() {
                return ByteBuffer.allocate(50000);
            }
        }));
    }

    @Test
    public void testResetSanity() throws IOException {
        IncrementalIndex index = this.indexCreator.createIndex();
        DateTime t = DateTime.now();
        Interval interval = new Interval((ReadableInstant)t.minusMinutes(1), (ReadableInstant)t.plusMinutes(1));
        index.add((InputRow)new MapBasedInputRow(t.minus(1L).getMillis(), (List)Lists.newArrayList((Object[])new String[]{"billy"}), (Map)ImmutableMap.of((Object)"billy", (Object)"hi")));
        index.add((InputRow)new MapBasedInputRow(t.minus(1L).getMillis(), (List)Lists.newArrayList((Object[])new String[]{"sally"}), (Map)ImmutableMap.of((Object)"sally", (Object)"bo")));
        IncrementalIndexStorageAdapter adapter = new IncrementalIndexStorageAdapter(index);
        Sequence cursorSequence = adapter.makeCursors((Filter)new SelectorFilter("sally", "bo"), interval, QueryGranularity.NONE);
        Cursor cursor = (Cursor)((ArrayList)Sequences.toList((Sequence)Sequences.limit((Sequence)cursorSequence, (int)1), (List)Lists.newArrayList())).get(0);
        DimensionSelector dimSelector = cursor.makeDimensionSelector("sally", null);
        Assert.assertEquals((Object)"bo", (Object)dimSelector.lookupName(dimSelector.getRow().get(0)));
        index.add((InputRow)new MapBasedInputRow(t.minus(1L).getMillis(), (List)Lists.newArrayList((Object[])new String[]{"sally"}), (Map)ImmutableMap.of((Object)"sally", (Object)"ah")));
        cursor.reset();
        dimSelector = cursor.makeDimensionSelector("sally", null);
        Assert.assertEquals((Object)"bo", (Object)dimSelector.lookupName(dimSelector.getRow().get(0)));
    }

    @Test
    public void testSingleValueTopN() throws IOException {
        IncrementalIndex index = this.indexCreator.createIndex();
        DateTime t = DateTime.now();
        index.add((InputRow)new MapBasedInputRow(t.minus(1L).getMillis(), (List)Lists.newArrayList((Object[])new String[]{"sally"}), (Map)ImmutableMap.of((Object)"sally", (Object)"bo")));
        TopNQueryEngine engine = new TopNQueryEngine(new StupidPool((Supplier)new Supplier<ByteBuffer>(){

            public ByteBuffer get() {
                return ByteBuffer.allocate(50000);
            }
        }));
        List results = Sequences.toList((Sequence)engine.query(new TopNQueryBuilder().dataSource("test").granularity(QueryGranularity.ALL).intervals((List)Lists.newArrayList((Object[])new Interval[]{new Interval(0L, new DateTime().getMillis())})).dimension("sally").metric("cnt").threshold(10).aggregators((List)Lists.newArrayList((Object[])new AggregatorFactory[]{new LongSumAggregatorFactory("cnt", "cnt")})).build(), (StorageAdapter)new IncrementalIndexStorageAdapter(index)), (List)Lists.newLinkedList());
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)results));
        Assert.assertEquals((long)1L, (long)((TopNResultValue)((Result)results.iterator().next()).getValue()).getValue().size());
    }

    @Test
    public void testFilterByNull() throws Exception {
        IncrementalIndex index = this.indexCreator.createIndex();
        index.add((InputRow)new MapBasedInputRow(new DateTime().minus(1L).getMillis(), (List)Lists.newArrayList((Object[])new String[]{"billy"}), (Map)ImmutableMap.of((Object)"billy", (Object)"hi")));
        index.add((InputRow)new MapBasedInputRow(new DateTime().minus(1L).getMillis(), (List)Lists.newArrayList((Object[])new String[]{"sally"}), (Map)ImmutableMap.of((Object)"sally", (Object)"bo")));
        GroupByQueryEngine engine = IncrementalIndexStorageAdapterTest.makeGroupByQueryEngine();
        Sequence rows = engine.process(GroupByQuery.builder().setDataSource("test").setGranularity(QueryGranularity.ALL).setInterval(new Interval(0L, new DateTime().getMillis())).addDimension("billy").addDimension("sally").addAggregator((AggregatorFactory)new LongSumAggregatorFactory("cnt", "cnt")).setDimFilter((DimFilter)DimFilters.dimEquals((String)"sally", (String)null)).build(), (StorageAdapter)new IncrementalIndexStorageAdapter(index));
        ArrayList results = (ArrayList)Sequences.toList((Sequence)rows, (List)Lists.newArrayList());
        Assert.assertEquals((long)1L, (long)results.size());
        MapBasedRow row = (MapBasedRow)results.get(0);
        Assert.assertEquals((Object)ImmutableMap.of((Object)"billy", (Object)"hi", (Object)"cnt", (Object)1L), (Object)row.getEvent());
    }

    static interface IndexCreator {
        public IncrementalIndex createIndex();
    }
}

