/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.filter;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.metamx.collections.spatial.search.Bound;
import com.metamx.collections.spatial.search.RadiusBound;
import com.metamx.collections.spatial.search.RectangularBound;
import io.druid.data.input.InputRow;
import io.druid.data.input.MapBasedInputRow;
import io.druid.data.input.impl.DimensionsSpec;
import io.druid.data.input.impl.SpatialDimensionSchema;
import io.druid.granularity.QueryGranularity;
import io.druid.query.Druids;
import io.druid.query.FinalizeResultsQueryRunner;
import io.druid.query.Query;
import io.druid.query.QueryRunnerTestHelper;
import io.druid.query.Result;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.CountAggregatorFactory;
import io.druid.query.aggregation.LongSumAggregatorFactory;
import io.druid.query.filter.DimFilter;
import io.druid.query.filter.SpatialDimFilter;
import io.druid.query.timeseries.TimeseriesQuery;
import io.druid.query.timeseries.TimeseriesQueryEngine;
import io.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import io.druid.query.timeseries.TimeseriesQueryRunnerFactory;
import io.druid.query.timeseries.TimeseriesResultValue;
import io.druid.segment.IncrementalIndexSegment;
import io.druid.segment.IndexIO;
import io.druid.segment.IndexMerger;
import io.druid.segment.QueryableIndex;
import io.druid.segment.QueryableIndexSegment;
import io.druid.segment.Segment;
import io.druid.segment.TestHelper;
import io.druid.segment.incremental.IncrementalIndex;
import io.druid.segment.incremental.IncrementalIndexSchema;
import io.druid.segment.incremental.OnheapIncrementalIndex;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SpatialFilterBonusTest {
    public static final int NUM_POINTS = 5000;
    private static Interval DATA_INTERVAL = new Interval((Object)"2013-01-01/2013-01-07");
    private static AggregatorFactory[] METRIC_AGGS = new AggregatorFactory[]{new CountAggregatorFactory("rows"), new LongSumAggregatorFactory("val", "val")};
    private static List<String> DIMS = Lists.newArrayList((Object[])new String[]{"dim", "dim.geo"});
    private final Segment segment;

    public SpatialFilterBonusTest(Segment segment) {
        this.segment = segment;
    }

    @Parameterized.Parameters
    public static Collection<?> constructorFeeder() throws IOException {
        IncrementalIndex rtIndex = SpatialFilterBonusTest.makeIncrementalIndex();
        QueryableIndex mMappedTestIndex = SpatialFilterBonusTest.makeQueryableIndex();
        QueryableIndex mergedRealtimeIndex = SpatialFilterBonusTest.makeMergedQueryableIndex();
        return Arrays.asList({new IncrementalIndexSegment(rtIndex, null)}, {new QueryableIndexSegment(null, mMappedTestIndex)}, {new QueryableIndexSegment(null, mergedRealtimeIndex)});
    }

    private static IncrementalIndex makeIncrementalIndex() throws IOException {
        OnheapIncrementalIndex theIndex = new OnheapIncrementalIndex(new IncrementalIndexSchema.Builder().withMinTimestamp(DATA_INTERVAL.getStartMillis()).withQueryGranularity(QueryGranularity.DAY).withMetrics(METRIC_AGGS).withDimensionsSpec(new DimensionsSpec(null, null, Arrays.asList(new SpatialDimensionSchema("dim.geo", (List)Lists.newArrayList())))).build(), false, 5000);
        theIndex.add((InputRow)new MapBasedInputRow(new DateTime((Object)"2013-01-01").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)new DateTime((Object)"2013-01-01").toString(), (Object)"dim", (Object)"foo", (Object)"dim.geo", (Object)"0.0,0.0", (Object)"val", (Object)17L)));
        theIndex.add((InputRow)new MapBasedInputRow(new DateTime((Object)"2013-01-02").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)new DateTime((Object)"2013-01-02").toString(), (Object)"dim", (Object)"foo", (Object)"dim.geo", (Object)"1.0,3.0", (Object)"val", (Object)29L)));
        theIndex.add((InputRow)new MapBasedInputRow(new DateTime((Object)"2013-01-03").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)new DateTime((Object)"2013-01-03").toString(), (Object)"dim", (Object)"foo", (Object)"dim.geo", (Object)"4.0,2.0", (Object)"val", (Object)13L)));
        theIndex.add((InputRow)new MapBasedInputRow(new DateTime((Object)"2013-01-04").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)new DateTime((Object)"2013-01-04").toString(), (Object)"dim", (Object)"foo", (Object)"dim.geo", (Object)"7.0,3.0", (Object)"val", (Object)91L)));
        theIndex.add((InputRow)new MapBasedInputRow(new DateTime((Object)"2013-01-05").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)new DateTime((Object)"2013-01-05").toString(), (Object)"dim", (Object)"foo", (Object)"dim.geo", (Object)"8.0,6.0", (Object)"val", (Object)47L)));
        theIndex.add((InputRow)new MapBasedInputRow(new DateTime((Object)"2013-01-05").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)new DateTime((Object)"2013-01-05").toString(), (Object)"dim", (Object)"foo", (Object)"dim.geo", (Object)"_mmx.unknown", (Object)"val", (Object)501L)));
        Random rand = new Random();
        for (int i = 6; i < 5000; ++i) {
            theIndex.add((InputRow)new MapBasedInputRow(new DateTime((Object)"2013-01-01").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)new DateTime((Object)"2013-01-01").toString(), (Object)"dim", (Object)"boo", (Object)"dim.geo", (Object)String.format("%s,%s", Float.valueOf((float)((double)(rand.nextFloat() * 10.0f) + 10.0)), Float.valueOf((float)((double)(rand.nextFloat() * 10.0f) + 10.0))), (Object)"val", (Object)i)));
        }
        return theIndex;
    }

    private static QueryableIndex makeQueryableIndex() throws IOException {
        IncrementalIndex theIndex = SpatialFilterBonusTest.makeIncrementalIndex();
        File tmpFile = File.createTempFile("billy", "yay");
        tmpFile.delete();
        tmpFile.mkdirs();
        tmpFile.deleteOnExit();
        IndexMerger.persist((IncrementalIndex)theIndex, (File)tmpFile);
        return IndexIO.loadIndex((File)tmpFile);
    }

    private static QueryableIndex makeMergedQueryableIndex() {
        try {
            OnheapIncrementalIndex first = new OnheapIncrementalIndex(new IncrementalIndexSchema.Builder().withMinTimestamp(DATA_INTERVAL.getStartMillis()).withQueryGranularity(QueryGranularity.DAY).withMetrics(METRIC_AGGS).withDimensionsSpec(new DimensionsSpec(null, null, Arrays.asList(new SpatialDimensionSchema("dim.geo", (List)Lists.newArrayList())))).build(), false, 5000);
            OnheapIncrementalIndex second = new OnheapIncrementalIndex(new IncrementalIndexSchema.Builder().withMinTimestamp(DATA_INTERVAL.getStartMillis()).withQueryGranularity(QueryGranularity.DAY).withMetrics(METRIC_AGGS).withDimensionsSpec(new DimensionsSpec(null, null, Arrays.asList(new SpatialDimensionSchema("dim.geo", (List)Lists.newArrayList())))).build(), false, 5000);
            OnheapIncrementalIndex third = new OnheapIncrementalIndex(new IncrementalIndexSchema.Builder().withMinTimestamp(DATA_INTERVAL.getStartMillis()).withQueryGranularity(QueryGranularity.DAY).withMetrics(METRIC_AGGS).withDimensionsSpec(new DimensionsSpec(null, null, Arrays.asList(new SpatialDimensionSchema("dim.geo", (List)Lists.newArrayList())))).build(), false, 5000);
            first.add((InputRow)new MapBasedInputRow(new DateTime((Object)"2013-01-01").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)new DateTime((Object)"2013-01-01").toString(), (Object)"dim", (Object)"foo", (Object)"dim.geo", (Object)"0.0,0.0", (Object)"val", (Object)17L)));
            first.add((InputRow)new MapBasedInputRow(new DateTime((Object)"2013-01-02").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)new DateTime((Object)"2013-01-02").toString(), (Object)"dim", (Object)"foo", (Object)"dim.geo", (Object)"1.0,3.0", (Object)"val", (Object)29L)));
            first.add((InputRow)new MapBasedInputRow(new DateTime((Object)"2013-01-03").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)new DateTime((Object)"2013-01-03").toString(), (Object)"dim", (Object)"foo", (Object)"dim.geo", (Object)"4.0,2.0", (Object)"val", (Object)13L)));
            first.add((InputRow)new MapBasedInputRow(new DateTime((Object)"2013-01-05").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)new DateTime((Object)"2013-01-05").toString(), (Object)"dim", (Object)"foo", (Object)"dim.geo", (Object)"_mmx.unknown", (Object)"val", (Object)501L)));
            second.add((InputRow)new MapBasedInputRow(new DateTime((Object)"2013-01-04").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)new DateTime((Object)"2013-01-04").toString(), (Object)"dim", (Object)"foo", (Object)"dim.geo", (Object)"7.0,3.0", (Object)"val", (Object)91L)));
            second.add((InputRow)new MapBasedInputRow(new DateTime((Object)"2013-01-05").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)new DateTime((Object)"2013-01-05").toString(), (Object)"dim", (Object)"foo", (Object)"dim.geo", (Object)"8.0,6.0", (Object)"val", (Object)47L)));
            Random rand = new Random();
            for (int i = 6; i < 5000; ++i) {
                third.add((InputRow)new MapBasedInputRow(new DateTime((Object)"2013-01-01").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)new DateTime((Object)"2013-01-01").toString(), (Object)"dim", (Object)"boo", (Object)"dim.geo", (Object)String.format("%s,%s", Float.valueOf((float)((double)(rand.nextFloat() * 10.0f) + 10.0)), Float.valueOf((float)((double)(rand.nextFloat() * 10.0f) + 10.0))), (Object)"val", (Object)i)));
            }
            File tmpFile = File.createTempFile("yay", "who");
            tmpFile.delete();
            File firstFile = new File(tmpFile, "first");
            File secondFile = new File(tmpFile, "second");
            File thirdFile = new File(tmpFile, "third");
            File mergedFile = new File(tmpFile, "merged");
            firstFile.mkdirs();
            firstFile.deleteOnExit();
            secondFile.mkdirs();
            secondFile.deleteOnExit();
            thirdFile.mkdirs();
            thirdFile.deleteOnExit();
            mergedFile.mkdirs();
            mergedFile.deleteOnExit();
            IndexMerger.persist((IncrementalIndex)first, (Interval)DATA_INTERVAL, (File)firstFile);
            IndexMerger.persist((IncrementalIndex)second, (Interval)DATA_INTERVAL, (File)secondFile);
            IndexMerger.persist((IncrementalIndex)third, (Interval)DATA_INTERVAL, (File)thirdFile);
            QueryableIndex mergedRealtime = IndexIO.loadIndex((File)IndexMerger.mergeQueryableIndex(Arrays.asList(IndexIO.loadIndex((File)firstFile), IndexIO.loadIndex((File)secondFile), IndexIO.loadIndex((File)thirdFile)), (AggregatorFactory[])METRIC_AGGS, (File)mergedFile));
            return mergedRealtime;
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Test
    public void testSpatialQuery() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("test").granularity(QueryGranularity.ALL).intervals(Arrays.asList(new Interval((Object)"2013-01-01/2013-01-07"))).filters((DimFilter)new SpatialDimFilter("dim.geo", (Bound)new RadiusBound(new float[]{0.0f, 0.0f}, 5.0f))).aggregators(Arrays.asList(new CountAggregatorFactory("rows"), new LongSumAggregatorFactory("val", "val"))).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2013-01-01T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)3L).put((Object)"val", (Object)59L).build())));
        try {
            TimeseriesQueryRunnerFactory factory = new TimeseriesQueryRunnerFactory(new TimeseriesQueryQueryToolChest(QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()), new TimeseriesQueryEngine(), QueryRunnerTestHelper.NOOP_QUERYWATCHER);
            FinalizeResultsQueryRunner runner = new FinalizeResultsQueryRunner(factory.createRunner(this.segment), factory.getToolchest());
            HashMap context = new HashMap();
            TestHelper.assertExpectedResults(expectedResults, runner.run((Query)query, context));
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Test
    public void testSpatialQueryMorePoints() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("test").granularity(QueryGranularity.DAY).intervals(Arrays.asList(new Interval((Object)"2013-01-01/2013-01-07"))).filters((DimFilter)new SpatialDimFilter("dim.geo", (Bound)new RectangularBound(new float[]{0.0f, 0.0f}, new float[]{9.0f, 9.0f}))).aggregators(Arrays.asList(new CountAggregatorFactory("rows"), new LongSumAggregatorFactory("val", "val"))).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2013-01-01T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)1L).put((Object)"val", (Object)17L).build())), new Result(new DateTime((Object)"2013-01-02T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)1L).put((Object)"val", (Object)29L).build())), new Result(new DateTime((Object)"2013-01-03T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)1L).put((Object)"val", (Object)13L).build())), new Result(new DateTime((Object)"2013-01-04T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)1L).put((Object)"val", (Object)91L).build())), new Result(new DateTime((Object)"2013-01-05T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)1L).put((Object)"val", (Object)47L).build())));
        try {
            TimeseriesQueryRunnerFactory factory = new TimeseriesQueryRunnerFactory(new TimeseriesQueryQueryToolChest(QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()), new TimeseriesQueryEngine(), QueryRunnerTestHelper.NOOP_QUERYWATCHER);
            FinalizeResultsQueryRunner runner = new FinalizeResultsQueryRunner(factory.createRunner(this.segment), factory.getToolchest());
            HashMap context = new HashMap();
            TestHelper.assertExpectedResults(expectedResults, runner.run((Query)query, context));
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

