/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.filter;

import com.google.common.collect.ImmutableMap;
import com.metamx.collections.bitmap.BitmapFactory;
import com.metamx.collections.bitmap.ConciseBitmapFactory;
import com.metamx.collections.bitmap.ImmutableBitmap;
import com.metamx.collections.bitmap.WrappedConciseBitmap;
import com.metamx.collections.spatial.ImmutableRTree;
import io.druid.query.extraction.DimExtractionFn;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.filter.BitmapIndexSelector;
import io.druid.segment.data.ArrayIndexed;
import io.druid.segment.data.Indexed;
import io.druid.segment.filter.ExtractionFilter;
import it.uniroma3.mat.extendedset.intset.ConciseSet;
import java.util.Map;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ExtractionDimFilterTest {
    private static final Map<String, String[]> DIM_VALS = ImmutableMap.of((Object)"foo", (Object)new String[]{"foo1", "foo2", "foo3"}, (Object)"bar", (Object)new String[]{"bar1"}, (Object)"baz", (Object)new String[]{"foo1"});
    private static final Map<String, String> EXTRACTION_VALUES = ImmutableMap.of((Object)"foo1", (Object)"extractDimVal");
    private static ImmutableBitmap foo1BitMap;
    private static final BitmapIndexSelector BITMAP_INDEX_SELECTOR;
    private static final ExtractionFn DIM_EXTRACTION_FN;

    @BeforeClass
    public static void setupStatic() {
        ConciseSet conciseSet = new ConciseSet();
        conciseSet.add(1);
        foo1BitMap = new WrappedConciseBitmap(conciseSet);
    }

    @Test
    public void testEmpty() {
        ExtractionFilter extractionFilter = new ExtractionFilter("foo", "NFDJUKFNDSJFNS", DIM_EXTRACTION_FN);
        ImmutableBitmap immutableBitmap = extractionFilter.getBitmapIndex(BITMAP_INDEX_SELECTOR);
        Assert.assertEquals((long)0L, (long)immutableBitmap.size());
    }

    @Test
    public void testNull() {
        ExtractionFilter extractionFilter = new ExtractionFilter("FDHJSFFHDS", "extractDimVal", DIM_EXTRACTION_FN);
        ImmutableBitmap immutableBitmap = extractionFilter.getBitmapIndex(BITMAP_INDEX_SELECTOR);
        Assert.assertEquals((long)0L, (long)immutableBitmap.size());
    }

    @Test
    public void testNormal() {
        ExtractionFilter extractionFilter = new ExtractionFilter("foo", "extractDimVal", DIM_EXTRACTION_FN);
        ImmutableBitmap immutableBitmap = extractionFilter.getBitmapIndex(BITMAP_INDEX_SELECTOR);
        Assert.assertEquals((long)1L, (long)immutableBitmap.size());
    }

    static {
        BITMAP_INDEX_SELECTOR = new BitmapIndexSelector(){

            public Indexed<String> getDimensionValues(String dimension) {
                Object[] vals = (String[])DIM_VALS.get(dimension);
                return vals == null ? null : new ArrayIndexed(vals, String.class);
            }

            public int getNumRows() {
                return 1;
            }

            public BitmapFactory getBitmapFactory() {
                return new ConciseBitmapFactory();
            }

            public ImmutableBitmap getBitmapIndex(String dimension, String value) {
                return "foo1".equals(value) ? foo1BitMap : null;
            }

            public ImmutableRTree getSpatialIndex(String dimension) {
                return null;
            }
        };
        DIM_EXTRACTION_FN = new DimExtractionFn(){

            public byte[] getCacheKey() {
                return new byte[0];
            }

            public String apply(String dimValue) {
                String retval = (String)EXTRACTION_VALUES.get(dimValue);
                return retval == null ? dimValue : retval;
            }

            public boolean preservesOrdering() {
                return false;
            }
        };
    }
}

