/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import io.druid.segment.data.VSizeIndexed;
import io.druid.segment.data.VSizeIndexedInts;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class VSizeIndexedTest {
    @Test
    public void testSanity() throws Exception {
        List<int[]> someInts = Arrays.asList({1, 2, 3, 4, 5}, {6, 7, 8, 9, 10}, {11, 12, 13, 14, 15, 16, 17, 18, 19, 20});
        VSizeIndexed indexed = VSizeIndexed.fromIterable((Iterable)Iterables.transform(someInts, (Function)new Function<int[], VSizeIndexedInts>(){

            public VSizeIndexedInts apply(int[] input) {
                return VSizeIndexedInts.fromArray((int[])input, (int)20);
            }
        }));
        this.assertSame(someInts, indexed);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        indexed.writeToChannel(Channels.newChannel(baos));
        byte[] bytes = baos.toByteArray();
        Assert.assertEquals((long)indexed.getSerializedSize(), (long)bytes.length);
        VSizeIndexed deserializedIndexed = VSizeIndexed.readFromByteBuffer((ByteBuffer)ByteBuffer.wrap(bytes));
        this.assertSame(someInts, deserializedIndexed);
    }

    private void assertSame(List<int[]> someInts, VSizeIndexed indexed) {
        Assert.assertEquals((long)3L, (long)indexed.size());
        for (int i = 0; i < indexed.size(); ++i) {
            int[] ints = someInts.get(i);
            VSizeIndexedInts vSizeIndexedInts = indexed.get(i);
            Assert.assertEquals((long)ints.length, (long)vSizeIndexedInts.size());
            Assert.assertEquals((long)1L, (long)vSizeIndexedInts.getNumBytes());
            for (int j = 0; j < ints.length; ++j) {
                Assert.assertEquals((long)ints[j], (long)vSizeIndexedInts.get(j));
            }
        }
    }
}

