/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import io.druid.segment.data.InMemoryCompressedLongs;
import io.druid.segment.data.IndexedLongs;
import java.nio.ByteOrder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InMemoryCompressedLongsTest {
    private InMemoryCompressedLongs longs;
    private long[] vals;

    @Before
    public void setUp() throws Exception {
        this.longs = null;
        this.vals = null;
    }

    private void setupSimple() {
        this.vals = new long[]{0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 12L, 13L, 14L, 16L};
        this.longs = new InMemoryCompressedLongs(5, ByteOrder.nativeOrder());
        for (int i = 0; i < this.vals.length; ++i) {
            Assert.assertEquals((long)i, (long)this.longs.add(this.vals[i]));
        }
    }

    @Test
    public void testSanity() throws Exception {
        this.setupSimple();
        Assert.assertEquals((long)this.vals.length, (long)this.longs.size());
        for (int i = 0; i < this.longs.size(); ++i) {
            Assert.assertEquals((long)this.vals[i], (long)this.longs.get(i));
        }
    }

    @Test
    public void testBulkFill() throws Exception {
        this.setupSimple();
        this.tryFill(0, 16);
        this.tryFill(3, 6);
        this.tryFill(7, 7);
        this.tryFill(7, 9);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testBulkFillTooMuch() throws Exception {
        this.setupSimple();
        this.tryFill(7, 10);
    }

    private void tryFill(int startIndex, int size) {
        long[] filled = new long[size];
        this.longs.fill(startIndex, filled);
        for (int i = startIndex; i < filled.length; ++i) {
            Assert.assertEquals((long)this.vals[i + startIndex], (long)filled[i]);
        }
    }

    @Test
    public void testCanConvertToCompressedLongsIndexedSupplier() throws Exception {
        this.setupSimple();
        IndexedLongs indexed = this.longs.toCompressedLongsIndexedSupplier().get();
        for (int i = 0; i < this.longs.size(); ++i) {
            Assert.assertEquals((long)this.longs.get(i), (long)indexed.get(i));
        }
        indexed.close();
    }
}

