/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.collect.Maps;
import io.druid.segment.data.IOPeon;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

class IOPeonForTesting
implements IOPeon {
    Map<String, ByteArrayOutputStream> outStreams = Maps.newHashMap();

    IOPeonForTesting() {
    }

    public OutputStream makeOutputStream(String filename) throws IOException {
        ByteArrayOutputStream stream = this.outStreams.get(filename);
        if (stream == null) {
            stream = new ByteArrayOutputStream();
            this.outStreams.put(filename, stream);
        }
        return stream;
    }

    public InputStream makeInputStream(String filename) throws IOException {
        ByteArrayOutputStream outStream = this.outStreams.get(filename);
        if (outStream == null) {
            throw new FileNotFoundException(String.format("unknown file[%s]", filename));
        }
        return new ByteArrayInputStream(outStream.toByteArray());
    }

    public void cleanup() throws IOException {
        this.outStreams.clear();
    }
}

