/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.druid.segment.data.CompressedObjectStrategy;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CompressionStrategyTest {
    protected final CompressedObjectStrategy.CompressionStrategy compressionStrategy;
    private static final int DATA_SIZER = 65535;
    private static byte[] originalData;

    @Parameterized.Parameters
    public static Iterable<Object[]> compressionStrategies() {
        return Iterables.transform(Arrays.asList(CompressedObjectStrategy.CompressionStrategy.values()), (Function)new Function<CompressedObjectStrategy.CompressionStrategy, Object[]>(){

            public Object[] apply(CompressedObjectStrategy.CompressionStrategy compressionStrategy) {
                return new Object[]{compressionStrategy};
            }
        });
    }

    public CompressionStrategyTest(CompressedObjectStrategy.CompressionStrategy compressionStrategy) {
        this.compressionStrategy = compressionStrategy;
    }

    @BeforeClass
    public static void setupClass() {
        originalData = new byte[65535];
        Random random = new Random(54671457L);
        random.nextBytes(originalData);
    }

    @Test
    public void testBasicOperations() {
        ByteBuffer compressed = ByteBuffer.wrap(this.compressionStrategy.getCompressor().compress(originalData));
        ByteBuffer output = ByteBuffer.allocate(originalData.length);
        this.compressionStrategy.getDecompressor().decompress(compressed, compressed.array().length, output);
        byte[] checkArray = new byte[65535];
        output.get(checkArray);
        Assert.assertArrayEquals((String)"Uncompressed data does not match", (byte[])originalData, (byte[])checkArray);
    }

    @Test
    public void testOutputSizeKnownOperations() {
        ByteBuffer compressed = ByteBuffer.wrap(this.compressionStrategy.getCompressor().compress(originalData));
        ByteBuffer output = ByteBuffer.allocate(originalData.length);
        this.compressionStrategy.getDecompressor().decompress(compressed, compressed.array().length, output, originalData.length);
        byte[] checkArray = new byte[65535];
        output.get(checkArray);
        Assert.assertArrayEquals((String)"Uncompressed data does not match", (byte[])originalData, (byte[])checkArray);
    }

    @Test
    public void testDirectMemoryOperations() {
        ByteBuffer compressed = ByteBuffer.wrap(this.compressionStrategy.getCompressor().compress(originalData));
        ByteBuffer output = ByteBuffer.allocateDirect(originalData.length);
        this.compressionStrategy.getDecompressor().decompress(compressed, compressed.array().length, output);
        byte[] checkArray = new byte[65535];
        output.get(checkArray);
        Assert.assertArrayEquals((String)"Uncompressed data does not match", (byte[])originalData, (byte[])checkArray);
    }

    @Test(timeout=60000L)
    public void testConcurrency() throws Exception {
        int numThreads = 20;
        ArrayBlockingQueue<Runnable> queue = new ArrayBlockingQueue<Runnable>(20);
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(20, 20, 100L, TimeUnit.MILLISECONDS, queue);
        ArrayList<Future<Boolean>> results = new ArrayList<Future<Boolean>>();
        for (int i = 0; i < 20; ++i) {
            results.add(threadPoolExecutor.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    ByteBuffer compressed = ByteBuffer.wrap(CompressionStrategyTest.this.compressionStrategy.getCompressor().compress(originalData));
                    ByteBuffer output = ByteBuffer.allocate(originalData.length);
                    CompressionStrategyTest.this.compressionStrategy.getDecompressor().decompress(compressed, compressed.array().length, output);
                    byte[] checkArray = new byte[65535];
                    output.get(checkArray);
                    Assert.assertArrayEquals((String)"Uncompressed data does not match", (byte[])originalData, (byte[])checkArray);
                    return true;
                }
            }));
        }
        threadPoolExecutor.shutdown();
        for (Future future : results) {
            Assert.assertTrue((boolean)((Boolean)future.get()));
        }
    }

    @Test(timeout=60000L)
    public void testKnownSizeConcurrency() throws Exception {
        int numThreads = 20;
        ListeningExecutorService threadPoolExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(20));
        ArrayList<ListenableFuture> results = new ArrayList<ListenableFuture>();
        for (int i = 0; i < 20; ++i) {
            results.add(threadPoolExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    ByteBuffer compressed = ByteBuffer.wrap(CompressionStrategyTest.this.compressionStrategy.getCompressor().compress(originalData));
                    ByteBuffer output = ByteBuffer.allocate(originalData.length);
                    CompressionStrategyTest.this.compressionStrategy.getDecompressor().decompress(compressed, compressed.array().length, output, originalData.length);
                    byte[] checkArray = new byte[65535];
                    output.get(checkArray);
                    Assert.assertArrayEquals((String)"Uncompressed data does not match", (byte[])originalData, (byte[])checkArray);
                }
            }));
        }
        Futures.allAsList(results).get();
    }
}

