/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import io.druid.jackson.DefaultObjectMapper;
import io.druid.segment.data.BitmapSerde;
import io.druid.segment.data.BitmapSerdeFactory;
import io.druid.segment.data.ConciseBitmapSerdeFactory;
import io.druid.segment.data.RoaringBitmapSerdeFactory;
import org.junit.Assert;
import org.junit.Test;

public class BitmapSerdeFactoryTest {
    @Test
    public void testSerialization() throws Exception {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        Assert.assertEquals((Object)"{\"type\":\"roaring\"}", (Object)mapper.writeValueAsString((Object)new RoaringBitmapSerdeFactory()));
        Assert.assertEquals((Object)"{\"type\":\"concise\"}", (Object)mapper.writeValueAsString((Object)new ConciseBitmapSerdeFactory()));
        Assert.assertEquals((Object)"{\"type\":\"concise\"}", (Object)mapper.writeValueAsString((Object)BitmapSerde.createLegacyFactory()));
        Assert.assertEquals((Object)"{\"type\":\"concise\"}", (Object)mapper.writeValueAsString((Object)new BitmapSerde.DefaultBitmapSerdeFactory()));
        Assert.assertEquals((Object)"{\"type\":\"concise\"}", (Object)mapper.writeValueAsString((Object)new BitmapSerde.LegacyBitmapSerdeFactory()));
    }

    @Test
    public void testDeserialization() throws Exception {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        Assert.assertTrue((boolean)(mapper.readValue("{\"type\":\"roaring\"}", BitmapSerdeFactory.class) instanceof RoaringBitmapSerdeFactory));
        Assert.assertTrue((boolean)(mapper.readValue("{\"type\":\"concise\"}", BitmapSerdeFactory.class) instanceof ConciseBitmapSerdeFactory));
        Assert.assertTrue((boolean)(mapper.readValue("{\"type\":\"BitmapSerde$SomeRandomClass\"}", BitmapSerdeFactory.class) instanceof ConciseBitmapSerdeFactory));
    }
}

