/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import io.druid.data.input.InputRow;
import io.druid.data.input.MapBasedInputRow;
import io.druid.granularity.QueryGranularity;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.CountAggregatorFactory;
import io.druid.segment.IndexIO;
import io.druid.segment.IndexMerger;
import io.druid.segment.QueryableIndex;
import io.druid.segment.data.IncrementalIndexTest;
import io.druid.segment.incremental.IncrementalIndex;
import io.druid.segment.incremental.OnheapIncrementalIndex;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.apache.commons.io.FileUtils;
import org.junit.Test;

public class IndexMergerTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPersist() throws Exception {
        long timestamp = System.currentTimeMillis();
        IncrementalIndex toPersist = IncrementalIndexTest.createIndex(true, null);
        IncrementalIndexTest.populateIndex(timestamp, toPersist);
        File tempDir = Files.createTempDir();
        try {
            QueryableIndex index = IndexIO.loadIndex((File)IndexMerger.persist((IncrementalIndex)toPersist, (File)tempDir));
            Assert.assertEquals((int)2, (int)index.getColumn("__time").getLength());
            Assert.assertEquals(Arrays.asList("dim1", "dim2"), (Object)Lists.newArrayList((Iterable)index.getAvailableDimensions()));
            Assert.assertEquals((int)3, (int)index.getColumnNames().size());
        }
        finally {
            tempDir.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPersistMerge() throws Exception {
        long timestamp = System.currentTimeMillis();
        IncrementalIndex toPersist1 = IncrementalIndexTest.createIndex(true, null);
        IncrementalIndexTest.populateIndex(timestamp, toPersist1);
        OnheapIncrementalIndex toPersist2 = new OnheapIncrementalIndex(0L, QueryGranularity.NONE, new AggregatorFactory[]{new CountAggregatorFactory("count")}, 1000);
        toPersist2.add((InputRow)new MapBasedInputRow(timestamp, Arrays.asList("dim1", "dim2"), (Map)ImmutableMap.of((Object)"dim1", (Object)"1", (Object)"dim2", (Object)"2")));
        toPersist2.add((InputRow)new MapBasedInputRow(timestamp, Arrays.asList("dim1", "dim2"), (Map)ImmutableMap.of((Object)"dim1", (Object)"5", (Object)"dim2", (Object)"6")));
        File tempDir1 = Files.createTempDir();
        File tempDir2 = Files.createTempDir();
        File mergedDir = Files.createTempDir();
        try {
            QueryableIndex index1 = IndexIO.loadIndex((File)IndexMerger.persist((IncrementalIndex)toPersist1, (File)tempDir1));
            Assert.assertEquals((int)2, (int)index1.getColumn("__time").getLength());
            Assert.assertEquals(Arrays.asList("dim1", "dim2"), (Object)Lists.newArrayList((Iterable)index1.getAvailableDimensions()));
            Assert.assertEquals((int)3, (int)index1.getColumnNames().size());
            QueryableIndex index2 = IndexIO.loadIndex((File)IndexMerger.persist((IncrementalIndex)toPersist2, (File)tempDir2));
            Assert.assertEquals((int)2, (int)index2.getColumn("__time").getLength());
            Assert.assertEquals(Arrays.asList("dim1", "dim2"), (Object)Lists.newArrayList((Iterable)index2.getAvailableDimensions()));
            Assert.assertEquals((int)3, (int)index2.getColumnNames().size());
            QueryableIndex merged = IndexIO.loadIndex((File)IndexMerger.mergeQueryableIndex(Arrays.asList(index1, index2), (AggregatorFactory[])new AggregatorFactory[]{new CountAggregatorFactory("count")}, (File)mergedDir));
            Assert.assertEquals((int)3, (int)merged.getColumn("__time").getLength());
            Assert.assertEquals(Arrays.asList("dim1", "dim2"), (Object)Lists.newArrayList((Iterable)merged.getAvailableDimensions()));
            Assert.assertEquals((int)3, (int)merged.getColumnNames().size());
        }
        finally {
            FileUtils.deleteQuietly((File)tempDir1);
            FileUtils.deleteQuietly((File)tempDir2);
            FileUtils.deleteQuietly((File)mergedDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPersistEmptyColumn() throws Exception {
        OnheapIncrementalIndex toPersist1 = new OnheapIncrementalIndex(0L, QueryGranularity.NONE, new AggregatorFactory[0], 10);
        OnheapIncrementalIndex toPersist2 = new OnheapIncrementalIndex(0L, QueryGranularity.NONE, new AggregatorFactory[0], 10);
        File tmpDir1 = Files.createTempDir();
        File tmpDir2 = Files.createTempDir();
        File tmpDir3 = Files.createTempDir();
        try {
            toPersist1.add((InputRow)new MapBasedInputRow(1L, (List)ImmutableList.of((Object)"dim1", (Object)"dim2"), (Map)ImmutableMap.of((Object)"dim1", (Object)ImmutableList.of(), (Object)"dim2", (Object)"foo")));
            toPersist2.add((InputRow)new MapBasedInputRow(1L, (List)ImmutableList.of((Object)"dim1", (Object)"dim2"), (Map)ImmutableMap.of((Object)"dim1", (Object)ImmutableList.of(), (Object)"dim2", (Object)"bar")));
            QueryableIndex index1 = IndexIO.loadIndex((File)IndexMerger.persist((IncrementalIndex)toPersist1, (File)tmpDir1));
            QueryableIndex index2 = IndexIO.loadIndex((File)IndexMerger.persist((IncrementalIndex)toPersist1, (File)tmpDir2));
            QueryableIndex merged = IndexIO.loadIndex((File)IndexMerger.mergeQueryableIndex(Arrays.asList(index1, index2), (AggregatorFactory[])new AggregatorFactory[0], (File)tmpDir3));
            Assert.assertEquals((int)1, (int)index1.getColumn("__time").getLength());
            Assert.assertEquals((Object)ImmutableList.of((Object)"dim2"), (Object)ImmutableList.copyOf((Iterable)index1.getAvailableDimensions()));
            Assert.assertEquals((int)1, (int)index2.getColumn("__time").getLength());
            Assert.assertEquals((Object)ImmutableList.of((Object)"dim2"), (Object)ImmutableList.copyOf((Iterable)index2.getAvailableDimensions()));
            Assert.assertEquals((int)1, (int)merged.getColumn("__time").getLength());
            Assert.assertEquals((Object)ImmutableList.of((Object)"dim2"), (Object)ImmutableList.copyOf((Iterable)merged.getAvailableDimensions()));
        }
        finally {
            FileUtils.deleteQuietly((File)tmpDir1);
            FileUtils.deleteQuietly((File)tmpDir2);
            FileUtils.deleteQuietly((File)tmpDir3);
        }
    }
}

