/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.metamx.collections.bitmap.BitmapFactory;
import com.metamx.collections.bitmap.ConciseBitmapFactory;
import io.druid.granularity.QueryGranularity;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.segment.IndexIO;
import io.druid.segment.IndexMerger;
import io.druid.segment.IndexableAdapter;
import io.druid.segment.QueryableIndex;
import io.druid.segment.incremental.IncrementalIndex;
import io.druid.segment.incremental.IncrementalIndexAdapter;
import io.druid.segment.incremental.OnheapIncrementalIndex;
import java.io.File;
import java.util.List;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class EmptyIndexTest {
    @Test
    public void testEmptyIndex() throws Exception {
        File tmpDir = File.createTempFile("emptyIndex", "");
        if (!tmpDir.delete()) {
            throw new IllegalStateException("tmp delete failed");
        }
        if (!tmpDir.mkdir()) {
            throw new IllegalStateException("tmp mkdir failed");
        }
        tmpDir.deleteOnExit();
        OnheapIncrementalIndex emptyIndex = new OnheapIncrementalIndex(0L, QueryGranularity.NONE, new AggregatorFactory[0], 1000);
        IncrementalIndexAdapter emptyIndexAdapter = new IncrementalIndexAdapter(new Interval((Object)"2012-08-01/P3D"), (IncrementalIndex)emptyIndex, (BitmapFactory)new ConciseBitmapFactory());
        IndexMerger.merge((List)Lists.newArrayList((Object[])new IndexableAdapter[]{emptyIndexAdapter}), (AggregatorFactory[])new AggregatorFactory[0], (File)tmpDir);
        QueryableIndex emptyQueryableIndex = IndexIO.loadIndex((File)tmpDir);
        Assert.assertEquals((String)"getDimensionNames", (long)0L, (long)Iterables.size((Iterable)emptyQueryableIndex.getAvailableDimensions()));
        Assert.assertEquals((String)"getMetricNames", (long)0L, (long)Iterables.size((Iterable)emptyQueryableIndex.getColumnNames()));
        Assert.assertEquals((String)"getDataInterval", (Object)new Interval((Object)"2012-08-01/P3D"), (Object)emptyQueryableIndex.getDataInterval());
        Assert.assertEquals((String)"getReadOnlyTimestamps", (long)0L, (long)emptyQueryableIndex.getColumn("__time").getLength());
    }
}

