/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.metamx.common.Pair;
import io.druid.granularity.QueryGranularity;
import io.druid.query.Druids;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.Result;
import io.druid.query.TestQueryRunners;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.CountAggregatorFactory;
import io.druid.query.aggregation.DoubleSumAggregatorFactory;
import io.druid.query.aggregation.MaxAggregatorFactory;
import io.druid.query.aggregation.MinAggregatorFactory;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import io.druid.query.aggregation.post.ArithmeticPostAggregator;
import io.druid.query.aggregation.post.ConstantPostAggregator;
import io.druid.query.aggregation.post.FieldAccessPostAggregator;
import io.druid.query.filter.DimFilter;
import io.druid.query.search.SearchResultValue;
import io.druid.query.search.search.SearchHit;
import io.druid.query.search.search.SearchQuery;
import io.druid.query.spec.MultipleIntervalSegmentSpec;
import io.druid.query.spec.QuerySegmentSpec;
import io.druid.query.timeboundary.TimeBoundaryQuery;
import io.druid.query.timeboundary.TimeBoundaryResultValue;
import io.druid.query.timeseries.TimeseriesQuery;
import io.druid.query.timeseries.TimeseriesResultValue;
import io.druid.query.topn.TopNQuery;
import io.druid.query.topn.TopNQueryBuilder;
import io.druid.query.topn.TopNResultValue;
import io.druid.segment.QueryableIndex;
import io.druid.segment.QueryableIndexSegment;
import io.druid.segment.SchemalessIndex;
import io.druid.segment.Segment;
import io.druid.segment.TestHelper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class AppendTest {
    private static final AggregatorFactory[] METRIC_AGGS = new AggregatorFactory[]{new DoubleSumAggregatorFactory("index", "index"), new CountAggregatorFactory("count"), new HyperUniquesAggregatorFactory("quality_uniques", "quality")};
    private static final AggregatorFactory[] METRIC_AGGS_NO_UNIQ = new AggregatorFactory[]{new DoubleSumAggregatorFactory("index", "index"), new CountAggregatorFactory("count")};
    final String dataSource = "testing";
    final QueryGranularity allGran = QueryGranularity.ALL;
    final String dimensionValue = "dimension";
    final String valueValue = "value";
    final String marketDimension = "market";
    final String qualityDimension = "quality";
    final String placementDimension = "placement";
    final String placementishDimension = "placementish";
    final String indexMetric = "index";
    final CountAggregatorFactory rowsCount = new CountAggregatorFactory("rows");
    final DoubleSumAggregatorFactory indexDoubleSum = new DoubleSumAggregatorFactory("index", "index");
    final HyperUniquesAggregatorFactory uniques = new HyperUniquesAggregatorFactory("uniques", "quality_uniques");
    final ConstantPostAggregator constant = new ConstantPostAggregator("const", (Number)1L);
    final FieldAccessPostAggregator rowsPostAgg = new FieldAccessPostAggregator("rows", "rows");
    final FieldAccessPostAggregator indexPostAgg = new FieldAccessPostAggregator("index", "index");
    final ArithmeticPostAggregator addRowsIndexConstant = new ArithmeticPostAggregator("addRowsIndexConstant", "+", (List)Lists.newArrayList((Object[])new PostAggregator[]{this.constant, this.rowsPostAgg, this.indexPostAgg}));
    final List<AggregatorFactory> commonAggregators = Arrays.asList(this.rowsCount, this.indexDoubleSum, this.uniques);
    final QuerySegmentSpec fullOnInterval = new MultipleIntervalSegmentSpec(Arrays.asList(new Interval((Object)"1970-01-01T00:00:00.000Z/2020-01-01T00:00:00.000Z")));
    private Segment segment;
    private Segment segment2;
    private Segment segment3;

    @Before
    public void setUp() throws Exception {
        QueryableIndex appendedIndex = SchemalessIndex.getAppendedIncrementalIndex(Arrays.asList(new Pair((Object)"append.json.1", (Object)METRIC_AGGS_NO_UNIQ), new Pair((Object)"append.json.2", (Object)METRIC_AGGS)), Arrays.asList(new Interval((Object)"2011-01-12T00:00:00.000Z/2011-01-16T00:00:00.000Z"), new Interval((Object)"2011-01-14T22:00:00.000Z/2011-01-16T00:00:00.000Z")));
        this.segment = new QueryableIndexSegment(null, appendedIndex);
        QueryableIndex append2 = SchemalessIndex.getAppendedIncrementalIndex(Arrays.asList(new Pair((Object)"append.json.3", (Object)METRIC_AGGS_NO_UNIQ), new Pair((Object)"append.json.4", (Object)METRIC_AGGS)), Arrays.asList(new Interval((Object)"2011-01-12T00:00:00.000Z/2011-01-16T00:00:00.000Z"), new Interval((Object)"2011-01-13T00:00:00.000Z/2011-01-14T00:00:00.000Z")));
        this.segment2 = new QueryableIndexSegment(null, append2);
        QueryableIndex append3 = SchemalessIndex.getAppendedIncrementalIndex(Arrays.asList(new Pair((Object)"append.json.5", (Object)METRIC_AGGS), new Pair((Object)"append.json.6", (Object)METRIC_AGGS), new Pair((Object)"append.json.7", (Object)METRIC_AGGS)), Arrays.asList(new Interval((Object)"2011-01-12T00:00:00.000Z/2011-01-22T00:00:00.000Z"), new Interval((Object)"2011-01-13T00:00:00.000Z/2011-01-16T00:00:00.000Z"), new Interval((Object)"2011-01-18T00:00:00.000Z/2011-01-21T00:00:00.000Z")));
        this.segment3 = new QueryableIndexSegment(null, append3);
    }

    @Test
    public void testTimeBoundary() {
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TimeBoundaryResultValue((Object)ImmutableMap.of((Object)"minTime", (Object)new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)"maxTime", (Object)new DateTime((Object)"2011-01-15T02:00:00.000Z")))));
        TimeBoundaryQuery query = Druids.newTimeBoundaryQueryBuilder().dataSource("testing").build();
        QueryRunner runner = TestQueryRunners.makeTimeBoundaryQueryRunner(this.segment);
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(expectedResults, runner.run((Query)query, context));
    }

    @Test
    public void testTimeBoundary2() {
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TimeBoundaryResultValue((Object)ImmutableMap.of((Object)"minTime", (Object)new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)"maxTime", (Object)new DateTime((Object)"2011-01-15T00:00:00.000Z")))));
        TimeBoundaryQuery query = Druids.newTimeBoundaryQueryBuilder().dataSource("testing").build();
        QueryRunner runner = TestQueryRunners.makeTimeBoundaryQueryRunner(this.segment2);
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(expectedResults, runner.run((Query)query, context));
    }

    @Test
    public void testTimeSeries() {
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)8L).put((Object)"index", (Object)700.0).put((Object)"addRowsIndexConstant", (Object)709.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)0.0).build())));
        TimeseriesQuery query = this.makeTimeseriesQuery();
        QueryRunner runner = TestQueryRunners.makeTimeSeriesQueryRunner(this.segment);
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(expectedResults, runner.run((Query)query, context));
    }

    @Test
    public void testTimeSeries2() {
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)7L).put((Object)"index", (Object)500.0).put((Object)"addRowsIndexConstant", (Object)508.0).put((Object)"uniques", (Object)0.0).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)0.0).build())));
        TimeseriesQuery query = this.makeTimeseriesQuery();
        QueryRunner runner = TestQueryRunners.makeTimeSeriesQueryRunner(this.segment2);
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(expectedResults, runner.run((Query)query, context));
    }

    @Test
    public void testFilteredTimeSeries() {
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)5L).put((Object)"index", (Object)500.0).put((Object)"addRowsIndexConstant", (Object)506.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build())));
        TimeseriesQuery query = this.makeFilteredTimeseriesQuery();
        QueryRunner runner = TestQueryRunners.makeTimeSeriesQueryRunner(this.segment);
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(expectedResults, runner.run((Query)query, context));
    }

    @Test
    public void testFilteredTimeSeries2() {
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)4L).put((Object)"index", (Object)400.0).put((Object)"addRowsIndexConstant", (Object)405.0).put((Object)"uniques", (Object)0.0).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build())));
        TimeseriesQuery query = this.makeFilteredTimeseriesQuery();
        QueryRunner runner = TestQueryRunners.makeTimeSeriesQueryRunner(this.segment2);
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(expectedResults, runner.run((Query)query, context));
    }

    @Test
    public void testTopNSeries() {
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)3L).put((Object)"index", (Object)300.0).put((Object)"addRowsIndexConstant", (Object)304.0).put((Object)"uniques", (Object)0.0).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build(), new HashMap<String, Object>(){
            {
                this.put("market", null);
                this.put("rows", 3L);
                this.put("index", 200.0);
                this.put("addRowsIndexConstant", 204.0);
                this.put("uniques", 0.0);
                this.put("maxIndex", 100.0);
                this.put("minIndex", 0.0);
            }
        }, ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"rows", (Object)2L).put((Object)"index", (Object)200.0).put((Object)"addRowsIndexConstant", (Object)203.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build()))));
        TopNQuery query = this.makeTopNQuery();
        QueryRunner runner = TestQueryRunners.makeTopNQueryRunner(this.segment);
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(expectedResults, runner.run((Query)query, context));
    }

    @Test
    public void testTopNSeries2() {
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"rows", (Object)3L).put((Object)"index", (Object)300.0).put((Object)"addRowsIndexConstant", (Object)304.0).put((Object)"uniques", (Object)0.0).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build(), new HashMap<String, Object>(){
            {
                this.put("market", null);
                this.put("rows", 3L);
                this.put("index", 100.0);
                this.put("addRowsIndexConstant", 104.0);
                this.put("uniques", 0.0);
                this.put("maxIndex", 100.0);
                this.put("minIndex", 0.0);
            }
        }, ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)1L).put((Object)"index", (Object)100.0).put((Object)"addRowsIndexConstant", (Object)102.0).put((Object)"uniques", (Object)0.0).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build()))));
        TopNQuery query = this.makeTopNQuery();
        QueryRunner runner = TestQueryRunners.makeTopNQueryRunner(this.segment2);
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(expectedResults, runner.run((Query)query, context));
    }

    @Test
    public void testFilteredTopNSeries() {
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)1L).put((Object)"index", (Object)100.0).put((Object)"addRowsIndexConstant", (Object)102.0).put((Object)"uniques", (Object)0.0).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build()))));
        TopNQuery query = this.makeFilteredTopNQuery();
        QueryRunner runner = TestQueryRunners.makeTopNQueryRunner(this.segment);
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(expectedResults, runner.run((Query)query, context));
    }

    @Test
    public void testFilteredTopNSeries2() {
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue((List)Lists.newArrayList())));
        TopNQuery query = this.makeFilteredTopNQuery();
        QueryRunner runner = TestQueryRunners.makeTopNQueryRunner(this.segment2);
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(expectedResults, runner.run((Query)query, context));
    }

    @Test
    public void testSearch() {
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new SearchResultValue(Arrays.asList(new SearchHit("placementish", "a"), new SearchHit("quality", "automotive"), new SearchHit("placement", "mezzanine"), new SearchHit("market", "total_market")))));
        SearchQuery query = this.makeSearchQuery();
        QueryRunner runner = TestQueryRunners.makeSearchQueryRunner(this.segment);
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(expectedResults, runner.run((Query)query, context));
    }

    @Test
    public void testSearchWithOverlap() {
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new SearchResultValue(Arrays.asList(new SearchHit("placementish", "a"), new SearchHit("placement", "mezzanine"), new SearchHit("market", "total_market")))));
        SearchQuery query = this.makeSearchQuery();
        QueryRunner runner = TestQueryRunners.makeSearchQueryRunner(this.segment2);
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(expectedResults, runner.run((Query)query, context));
    }

    @Test
    public void testFilteredSearch() {
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new SearchResultValue(Arrays.asList(new SearchHit("placement", "mezzanine"), new SearchHit("market", "total_market")))));
        SearchQuery query = this.makeFilteredSearchQuery();
        QueryRunner runner = TestQueryRunners.makeSearchQueryRunner(this.segment);
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(expectedResults, runner.run((Query)query, context));
    }

    @Test
    public void testFilteredSearch2() {
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new SearchResultValue(Arrays.asList(new SearchHit("placementish", "a"), new SearchHit("placement", "mezzanine"), new SearchHit("market", "total_market")))));
        SearchQuery query = this.makeFilteredSearchQuery();
        QueryRunner runner = TestQueryRunners.makeSearchQueryRunner(this.segment2);
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(expectedResults, runner.run((Query)query, context));
    }

    @Test
    public void testRowFiltering() {
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)5L).put((Object)"index", (Object)500.0).put((Object)"addRowsIndexConstant", (Object)506.0).put((Object)"uniques", (Object)0.0).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build())));
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(this.allGran).intervals(this.fullOnInterval).filters("market", "breakstuff").aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.commonAggregators, (Iterable)Lists.newArrayList((Object[])new AggregatorFactory[]{new MaxAggregatorFactory("maxIndex", "index"), new MinAggregatorFactory("minIndex", "index")})))).postAggregators(Arrays.asList(this.addRowsIndexConstant)).build();
        QueryRunner runner = TestQueryRunners.makeTimeSeriesQueryRunner(this.segment3);
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(expectedResults, runner.run((Query)query, context));
    }

    private TimeseriesQuery makeTimeseriesQuery() {
        return Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(this.allGran).intervals(this.fullOnInterval).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.commonAggregators, (Iterable)Lists.newArrayList((Object[])new AggregatorFactory[]{new MaxAggregatorFactory("maxIndex", "index"), new MinAggregatorFactory("minIndex", "index")})))).postAggregators(Arrays.asList(this.addRowsIndexConstant)).build();
    }

    private TimeseriesQuery makeFilteredTimeseriesQuery() {
        return Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(this.allGran).intervals(this.fullOnInterval).filters((DimFilter)Druids.newOrDimFilterBuilder().fields(Arrays.asList(Druids.newSelectorDimFilterBuilder().dimension("market").value("spot").build(), Druids.newSelectorDimFilterBuilder().dimension("market").value("total_market").build())).build()).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.commonAggregators, (Iterable)Lists.newArrayList((Object[])new AggregatorFactory[]{new MaxAggregatorFactory("maxIndex", "index"), new MinAggregatorFactory("minIndex", "index")})))).postAggregators(Arrays.asList(this.addRowsIndexConstant)).build();
    }

    private TopNQuery makeTopNQuery() {
        return new TopNQueryBuilder().dataSource("testing").granularity(this.allGran).dimension("market").metric("index").threshold(3).intervals(this.fullOnInterval).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.commonAggregators, (Iterable)Lists.newArrayList((Object[])new AggregatorFactory[]{new MaxAggregatorFactory("maxIndex", "index"), new MinAggregatorFactory("minIndex", "index")})))).postAggregators(Arrays.asList(this.addRowsIndexConstant)).build();
    }

    private TopNQuery makeFilteredTopNQuery() {
        return new TopNQueryBuilder().dataSource("testing").granularity(this.allGran).dimension("market").metric("index").threshold(3).filters((DimFilter)Druids.newAndDimFilterBuilder().fields(Arrays.asList(Druids.newSelectorDimFilterBuilder().dimension("market").value("spot").build(), Druids.newSelectorDimFilterBuilder().dimension("placement").value("preferred").build())).build()).intervals(this.fullOnInterval).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.commonAggregators, (Iterable)Lists.newArrayList((Object[])new AggregatorFactory[]{new MaxAggregatorFactory("maxIndex", "index"), new MinAggregatorFactory("minIndex", "index")})))).postAggregators(Arrays.asList(this.addRowsIndexConstant)).build();
    }

    private SearchQuery makeSearchQuery() {
        return Druids.newSearchQueryBuilder().dataSource("testing").granularity(this.allGran).intervals(this.fullOnInterval).query("a").build();
    }

    private SearchQuery makeFilteredSearchQuery() {
        return Druids.newSearchQueryBuilder().dataSource("testing").filters((DimFilter)Druids.newNotDimFilterBuilder().field((DimFilter)Druids.newSelectorDimFilterBuilder().dimension("market").value("spot").build()).build()).granularity(this.allGran).intervals(this.fullOnInterval).query("a").build();
    }
}

