/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.topn;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import io.druid.collections.StupidPool;
import io.druid.query.BySegmentResultValueClass;
import io.druid.query.Druids;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerFactory;
import io.druid.query.QueryRunnerTestHelper;
import io.druid.query.Result;
import io.druid.query.TestQueryRunners;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.MaxAggregatorFactory;
import io.druid.query.aggregation.MinAggregatorFactory;
import io.druid.query.aggregation.cardinality.CardinalityAggregatorFactory;
import io.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.dimension.ExtractionDimensionSpec;
import io.druid.query.extraction.DimExtractionFn;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.extraction.RegexDimExtractionFn;
import io.druid.query.extraction.TimeFormatExtractionFn;
import io.druid.query.filter.AndDimFilter;
import io.druid.query.filter.DimFilter;
import io.druid.query.spec.MultipleIntervalSegmentSpec;
import io.druid.query.spec.QuerySegmentSpec;
import io.druid.query.topn.BySegmentTopNResultValue;
import io.druid.query.topn.InvertedTopNMetricSpec;
import io.druid.query.topn.LexicographicTopNMetricSpec;
import io.druid.query.topn.NumericTopNMetricSpec;
import io.druid.query.topn.TopNMetricSpec;
import io.druid.query.topn.TopNQuery;
import io.druid.query.topn.TopNQueryBuilder;
import io.druid.query.topn.TopNQueryConfig;
import io.druid.query.topn.TopNQueryQueryToolChest;
import io.druid.query.topn.TopNQueryRunnerFactory;
import io.druid.query.topn.TopNResultValue;
import io.druid.segment.TestHelper;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TopNQueryRunnerTest {
    private final QueryRunner runner;

    @Parameterized.Parameters
    public static Collection<?> constructorFeeder() throws IOException {
        ArrayList retVal = Lists.newArrayList();
        retVal.addAll(QueryRunnerTestHelper.makeQueryRunners((QueryRunnerFactory)new TopNQueryRunnerFactory(TestQueryRunners.getPool(), new TopNQueryQueryToolChest(new TopNQueryConfig(), QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()), QueryRunnerTestHelper.NOOP_QUERYWATCHER)));
        retVal.addAll(QueryRunnerTestHelper.makeQueryRunners((QueryRunnerFactory)new TopNQueryRunnerFactory(new StupidPool((Supplier)new Supplier<ByteBuffer>(){

            public ByteBuffer get() {
                return ByteBuffer.allocate(2000);
            }
        }), new TopNQueryQueryToolChest(new TopNQueryConfig(), QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()), QueryRunnerTestHelper.NOOP_QUERYWATCHER)));
        return retVal;
    }

    public TopNQueryRunnerTest(QueryRunner runner) {
        this.runner = runner;
    }

    @Test
    public void testFullOnTopN() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension("market").metric("index").threshold(4).intervals(QueryRunnerTestHelper.fullOnInterval).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(QueryRunnerTestHelper.commonAggregators, (Iterable)Lists.newArrayList((Object[])new AggregatorFactory[]{new MaxAggregatorFactory("maxIndex", "index"), new MinAggregatorFactory("minIndex", "index")})))).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"rows", (Object)186L).put((Object)"index", (Object)215679.82879638672).put((Object)"addRowsIndexConstant", (Object)215866.82879638672).put((Object)"uniques", (Object)2.000977198748901).put((Object)"maxIndex", (Object)1743.9217529296875).put((Object)"minIndex", (Object)792.3260498046875).build(), ImmutableMap.builder().put((Object)"market", (Object)"upfront").put((Object)"rows", (Object)186L).put((Object)"index", (Object)192046.1060180664).put((Object)"addRowsIndexConstant", (Object)192233.1060180664).put((Object)"uniques", (Object)2.000977198748901).put((Object)"maxIndex", (Object)1870.06103515625).put((Object)"minIndex", (Object)545.9906005859375).build(), ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)837L).put((Object)"index", (Object)95606.57232284546).put((Object)"addRowsIndexConstant", (Object)96444.57232284546).put((Object)"uniques", (Object)9.019833517963864).put((Object)"maxIndex", (Object)277.2735290527344).put((Object)"minIndex", (Object)59.02102279663086).build()))));
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(expectedResults, this.runner.run((Query)query, context));
    }

    @Test
    public void testFullOnTopNOverPostAggs() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension("market").metric("addRowsIndexConstant").threshold(4).intervals(QueryRunnerTestHelper.fullOnInterval).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(QueryRunnerTestHelper.commonAggregators, (Iterable)Lists.newArrayList((Object[])new AggregatorFactory[]{new MaxAggregatorFactory("maxIndex", "index"), new MinAggregatorFactory("minIndex", "index")})))).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"rows", (Object)186L).put((Object)"index", (Object)215679.82879638672).put((Object)"addRowsIndexConstant", (Object)215866.82879638672).put((Object)"uniques", (Object)2.000977198748901).put((Object)"maxIndex", (Object)1743.9217529296875).put((Object)"minIndex", (Object)792.3260498046875).build(), ImmutableMap.builder().put((Object)"market", (Object)"upfront").put((Object)"rows", (Object)186L).put((Object)"index", (Object)192046.1060180664).put((Object)"addRowsIndexConstant", (Object)192233.1060180664).put((Object)"uniques", (Object)2.000977198748901).put((Object)"maxIndex", (Object)1870.06103515625).put((Object)"minIndex", (Object)545.9906005859375).build(), ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)837L).put((Object)"index", (Object)95606.57232284546).put((Object)"addRowsIndexConstant", (Object)96444.57232284546).put((Object)"uniques", (Object)9.019833517963864).put((Object)"maxIndex", (Object)277.2735290527344).put((Object)"minIndex", (Object)59.02102279663086).build()))));
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(expectedResults, this.runner.run((Query)query, context));
    }

    @Test
    public void testFullOnTopNOverUniques() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension("market").metric("uniques").threshold(3).intervals(QueryRunnerTestHelper.fullOnInterval).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(QueryRunnerTestHelper.commonAggregators, (Iterable)Lists.newArrayList((Object[])new AggregatorFactory[]{new MaxAggregatorFactory("maxIndex", "index"), new MinAggregatorFactory("minIndex", "index")})))).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)837L).put((Object)"index", (Object)95606.57232284546).put((Object)"addRowsIndexConstant", (Object)96444.57232284546).put((Object)"uniques", (Object)9.019833517963864).put((Object)"maxIndex", (Object)277.2735290527344).put((Object)"minIndex", (Object)59.02102279663086).build(), ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"rows", (Object)186L).put((Object)"index", (Object)215679.82879638672).put((Object)"addRowsIndexConstant", (Object)215866.82879638672).put((Object)"uniques", (Object)2.000977198748901).put((Object)"maxIndex", (Object)1743.9217529296875).put((Object)"minIndex", (Object)792.3260498046875).build(), ImmutableMap.builder().put((Object)"market", (Object)"upfront").put((Object)"rows", (Object)186L).put((Object)"index", (Object)192046.1060180664).put((Object)"addRowsIndexConstant", (Object)192233.1060180664).put((Object)"uniques", (Object)2.000977198748901).put((Object)"maxIndex", (Object)1870.06103515625).put((Object)"minIndex", (Object)545.9906005859375).build()))));
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(expectedResults, this.runner.run((Query)query, context));
    }

    @Test
    public void testTopNOverMissingUniques() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension("market").metric("uniques").threshold(3).intervals(QueryRunnerTestHelper.fullOnInterval).aggregators(Arrays.asList(new HyperUniquesAggregatorFactory("uniques", "missingUniques"))).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"uniques", (Object)0).build(), ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"uniques", (Object)0).build(), ImmutableMap.builder().put((Object)"market", (Object)"upfront").put((Object)"uniques", (Object)0).build()))));
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(expectedResults, this.runner.run((Query)query, context));
    }

    @Test
    public void testTopNBySegment() {
        HashMap<String, String> specialContext = new HashMap<String, String>();
        specialContext.put("bySegment", "true");
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension("market").metric("index").threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).context(specialContext).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"addRowsIndexConstant", (Object)5356.814697265625, (Object)"index", (Object)5351.814697265625, (Object)"market", (Object)"total_market", (Object)"uniques", (Object)2.000977198748901, (Object)"rows", (Object)4L), ImmutableMap.of((Object)"addRowsIndexConstant", (Object)4880.669677734375, (Object)"index", (Object)4875.669677734375, (Object)"market", (Object)"upfront", (Object)"uniques", (Object)2.000977198748901, (Object)"rows", (Object)4L), ImmutableMap.of((Object)"addRowsIndexConstant", (Object)2250.8768157958984, (Object)"index", (Object)2231.8768157958984, (Object)"market", (Object)"spot", (Object)"uniques", (Object)9.019833517963864, (Object)"rows", (Object)18L)))));
        Sequence results = new TopNQueryQueryToolChest(new TopNQueryConfig(), QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()).postMergeQueryDecoration(this.runner).run((Query)query, specialContext);
        List resultList = Sequences.toList((Sequence)Sequences.map((Sequence)results, (Function)new Function<Result<TopNResultValue>, Result<BySegmentTopNResultValue>>(){

            @Nullable
            public Result<BySegmentTopNResultValue> apply(Result<TopNResultValue> input) {
                return new Result(input.getTimestamp(), (Object)((BySegmentTopNResultValue)input.getValue()));
            }
        }), (List)Lists.newArrayList());
        TestHelper.assertExpectedResults(expectedResults, ((BySegmentTopNResultValue)((Result)resultList.get(0)).getValue()).getResults());
    }

    @Test
    public void testTopN() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension("market").metric("index").threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"total_market", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814697265625, (Object)"addRowsIndexConstant", (Object)5356.814697265625, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"upfront", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669677734375, (Object)"addRowsIndexConstant", (Object)4880.669677734375, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"spot", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.8768157958984, (Object)"addRowsIndexConstant", (Object)2250.8768157958984, (Object)"uniques", (Object)9.019833517963864)))));
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(expectedResults, this.runner.run((Query)query, context));
    }

    @Test
    public void testTopNByUniques() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension("market").metric((TopNMetricSpec)new NumericTopNMetricSpec("uniques")).threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"spot", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.8768157958984, (Object)"addRowsIndexConstant", (Object)2250.8768157958984, (Object)"uniques", (Object)9.019833517963864), ImmutableMap.of((Object)"market", (Object)"total_market", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814697265625, (Object)"addRowsIndexConstant", (Object)5356.814697265625, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"upfront", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669677734375, (Object)"addRowsIndexConstant", (Object)4880.669677734375, (Object)"uniques", (Object)2.000977198748901)))));
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(expectedResults, this.runner.run((Query)query, context));
    }

    @Test
    public void testTopNWithOrFilter1() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).filters("market", "total_market", new String[]{"upfront", "spot"}).dimension("market").metric("index").threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"total_market", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814697265625, (Object)"addRowsIndexConstant", (Object)5356.814697265625, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"upfront", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669677734375, (Object)"addRowsIndexConstant", (Object)4880.669677734375, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"spot", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.8768157958984, (Object)"addRowsIndexConstant", (Object)2250.8768157958984, (Object)"uniques", (Object)9.019833517963864)))));
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(expectedResults, this.runner.run((Query)query, context));
    }

    @Test
    public void testTopNWithOrFilter2() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).filters("market", "total_market", new String[]{"upfront"}).dimension("market").metric("index").threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"total_market", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814697265625, (Object)"addRowsIndexConstant", (Object)5356.814697265625, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"upfront", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669677734375, (Object)"addRowsIndexConstant", (Object)4880.669677734375, (Object)"uniques", (Object)2.000977198748901)))));
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(expectedResults, this.runner.run((Query)query, context));
    }

    @Test
    public void testTopNWithFilter1() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).filters("market", "upfront").dimension("market").metric("index").threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"upfront", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669677734375, (Object)"addRowsIndexConstant", (Object)4880.669677734375, (Object)"uniques", (Object)2.000977198748901)))));
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(expectedResults, this.runner.run((Query)query, context));
    }

    @Test
    public void testTopNWithFilter2() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).filters("quality", "mezzanine").dimension("market").metric("index").threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"upfront", (Object)"rows", (Object)2L, (Object)"index", (Object)2591.68359375, (Object)"addRowsIndexConstant", (Object)2594.68359375, (Object)"uniques", (Object)1.0002442201269182), ImmutableMap.of((Object)"market", (Object)"total_market", (Object)"rows", (Object)2L, (Object)"index", (Object)2508.39599609375, (Object)"addRowsIndexConstant", (Object)2511.39599609375, (Object)"uniques", (Object)1.0002442201269182), ImmutableMap.of((Object)"market", (Object)"spot", (Object)"rows", (Object)2L, (Object)"index", (Object)220.63774871826172, (Object)"addRowsIndexConstant", (Object)223.63774871826172, (Object)"uniques", (Object)1.0002442201269182)))));
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(expectedResults, this.runner.run((Query)query, context));
    }

    @Test
    public void testTopNWithFilter2OneDay() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).filters("quality", "mezzanine").dimension("market").metric("index").threshold(4).intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Arrays.asList(new Interval((Object)"2011-04-01T00:00:00.000Z/2011-04-02T00:00:00.000Z")))).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"upfront", (Object)"rows", (Object)1L, (Object)"index", (Object)new Float(1447.34116).doubleValue(), (Object)"addRowsIndexConstant", (Object)new Float(1449.34116).doubleValue(), (Object)"uniques", (Object)1.0002442201269182), ImmutableMap.of((Object)"market", (Object)"total_market", (Object)"rows", (Object)1L, (Object)"index", (Object)new Float(1314.839715).doubleValue(), (Object)"addRowsIndexConstant", (Object)new Float(1316.839715).doubleValue(), (Object)"uniques", (Object)1.0002442201269182), ImmutableMap.of((Object)"market", (Object)"spot", (Object)"rows", (Object)1L, (Object)"index", (Object)new Float(109.705815).doubleValue(), (Object)"addRowsIndexConstant", (Object)new Float(111.705815).doubleValue(), (Object)"uniques", (Object)1.0002442201269182)))));
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(expectedResults, this.runner.run((Query)query, context));
    }

    @Test
    public void testTopNWithNonExistentFilterInOr() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).filters("market", "total_market", new String[]{"upfront", "billyblank"}).dimension("market").metric("index").threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"total_market", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814697265625, (Object)"addRowsIndexConstant", (Object)5356.814697265625, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"upfront", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669677734375, (Object)"addRowsIndexConstant", (Object)4880.669677734375, (Object)"uniques", (Object)2.000977198748901)))));
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(expectedResults, this.runner.run((Query)query, context));
    }

    @Test
    public void testTopNWithNonExistentFilter() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).filters("market", "billyblank").dimension("market").metric("index").threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(Lists.newArrayList((Object[])new Result[]{new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue((List)Lists.newArrayList()))}), this.runner.run((Query)query, context));
    }

    @Test
    public void testTopNWithNonExistentFilterMultiDim() {
        AndDimFilter andDimFilter = Druids.newAndDimFilterBuilder().fields((List)Lists.newArrayList((Object[])new DimFilter[]{Druids.newSelectorDimFilterBuilder().dimension("market").value("billyblank").build(), Druids.newSelectorDimFilterBuilder().dimension("quality").value("mezzanine").build()})).build();
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).filters((DimFilter)andDimFilter).dimension("market").metric("index").threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(Lists.newArrayList((Object[])new Result[]{new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue((List)Lists.newArrayList()))}), this.runner.run((Query)query, context));
    }

    @Test
    public void testTopNWithMultiValueDimFilter1() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).filters("placementish", "m").dimension("market").metric("index").threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(Sequences.toList((Sequence)this.runner.run((Query)new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).filters("quality", "mezzanine").dimension("market").metric("index").threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build(), context), (List)Lists.newArrayList()), this.runner.run((Query)query, context));
    }

    @Test
    public void testTopNWithMultiValueDimFilter2() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).filters("placementish", "m", new String[]{"a", "b"}).dimension("quality").metric("index").threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(Sequences.toList((Sequence)this.runner.run((Query)new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).filters("quality", "mezzanine", new String[]{"automotive", "business"}).dimension("quality").metric("index").threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build(), context), (List)Lists.newArrayList()), this.runner.run((Query)query, context));
    }

    @Test
    public void testTopNWithMultiValueDimFilter3() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).filters("placementish", "a").dimension("placementish").metric("index").threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        ArrayList expectedResults = Lists.newArrayList((Object[])new Result[]{new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"placementish", (Object)"a", (Object)"rows", (Object)2L, (Object)"index", (Object)283.31103515625, (Object)"addRowsIndexConstant", (Object)286.31103515625, (Object)"uniques", (Object)1.0002442201269182), ImmutableMap.of((Object)"placementish", (Object)"preferred", (Object)"rows", (Object)2L, (Object)"index", (Object)283.31103515625, (Object)"addRowsIndexConstant", (Object)286.31103515625, (Object)"uniques", (Object)1.0002442201269182))))});
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(expectedResults, this.runner.run((Query)query, context));
    }

    @Test
    public void testTopNWithMultiValueDimFilter4() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).filters("placementish", "a", new String[]{"b"}).dimension("placementish").metric("index").threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        ArrayList expectedResults = Lists.newArrayList((Object[])new Result[]{new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"placementish", (Object)"preferred", (Object)"rows", (Object)4L, (Object)"index", (Object)514.868408203125, (Object)"addRowsIndexConstant", (Object)519.868408203125, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"placementish", (Object)"a", (Object)"rows", (Object)2L, (Object)"index", (Object)283.31103515625, (Object)"addRowsIndexConstant", (Object)286.31103515625, (Object)"uniques", (Object)1.0002442201269182), ImmutableMap.of((Object)"placementish", (Object)"b", (Object)"rows", (Object)2L, (Object)"index", (Object)231.557373046875, (Object)"addRowsIndexConstant", (Object)234.557373046875, (Object)"uniques", (Object)1.0002442201269182))))});
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(expectedResults, this.runner.run((Query)query, context));
    }

    @Test
    public void testTopNWithMultiValueDimFilter5() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).filters("placementish", "preferred").dimension("placementish").metric("index").threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        ArrayList expectedResults = Lists.newArrayList((Object[])new Result[]{new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"placementish", (Object)"preferred", (Object)"rows", (Object)26L, (Object)"index", (Object)12459.361190795898, (Object)"addRowsIndexConstant", (Object)12486.361190795898, (Object)"uniques", (Object)9.019833517963864), ImmutableMap.of((Object)"placementish", (Object)"p", (Object)"rows", (Object)6L, (Object)"index", (Object)5407.213653564453, (Object)"addRowsIndexConstant", (Object)5414.213653564453, (Object)"uniques", (Object)1.0002442201269182), ImmutableMap.of((Object)"placementish", (Object)"m", (Object)"rows", (Object)6L, (Object)"index", (Object)5320.717338562012, (Object)"addRowsIndexConstant", (Object)5327.717338562012, (Object)"uniques", (Object)1.0002442201269182), ImmutableMap.of((Object)"placementish", (Object)"t", (Object)"rows", (Object)4L, (Object)"index", (Object)422.3440856933594, (Object)"addRowsIndexConstant", (Object)427.3440856933594, (Object)"uniques", (Object)2.000977198748901))))});
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(expectedResults, this.runner.run((Query)query, context));
    }

    @Test
    public void testTopNWithNonExistentDimension() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension("doesn't exist").metric("index").threshold(1).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(new LinkedHashMap<String, Object>(){
            {
                this.put("doesn't exist", null);
                this.put("rows", 26L);
                this.put("index", 12459.361190795898);
                this.put("addRowsIndexConstant", 12486.361190795898);
                this.put("uniques", 9.019833517963864);
            }
        }))));
        TestHelper.assertExpectedResults(expectedResults, this.runner.run((Query)query, new HashMap()));
    }

    @Test
    public void testTopNWithNonExistentDimensionAndActualFilter() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).filters("market", "upfront").dimension("doesn't exist").metric("index").threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(new LinkedHashMap<String, Object>(){
            {
                this.put("doesn't exist", null);
                this.put("rows", 4L);
                this.put("index", 4875.669677734375);
                this.put("addRowsIndexConstant", 4880.669677734375);
                this.put("uniques", 2.000977198748901);
            }
        }))));
        TestHelper.assertExpectedResults(expectedResults, this.runner.run((Query)query, new HashMap()));
    }

    @Test
    public void testTopNWithNonExistentDimensionAndNonExistentFilter() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).filters("doesn't exist", null).dimension("doesn't exist").metric("index").threshold(1).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(new LinkedHashMap<String, Object>(){
            {
                this.put("doesn't exist", null);
                this.put("rows", 26L);
                this.put("index", 12459.361190795898);
                this.put("addRowsIndexConstant", 12486.361190795898);
                this.put("uniques", 9.019833517963864);
            }
        }))));
        TestHelper.assertExpectedResults(expectedResults, this.runner.run((Query)query, new HashMap()));
    }

    @Test
    public void testTopNLexicographic() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension("market").metric((TopNMetricSpec)new LexicographicTopNMetricSpec("")).threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"spot", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.8768157958984, (Object)"addRowsIndexConstant", (Object)2250.8768157958984, (Object)"uniques", (Object)9.019833517963864), ImmutableMap.of((Object)"market", (Object)"total_market", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814697265625, (Object)"addRowsIndexConstant", (Object)5356.814697265625, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"upfront", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669677734375, (Object)"addRowsIndexConstant", (Object)4880.669677734375, (Object)"uniques", (Object)2.000977198748901)))));
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(expectedResults, this.runner.run((Query)query, context));
    }

    @Test
    public void testTopNLexicographicWithPreviousStop() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension("market").metric((TopNMetricSpec)new LexicographicTopNMetricSpec("spot")).threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"total_market", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814697265625, (Object)"addRowsIndexConstant", (Object)5356.814697265625, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"upfront", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669677734375, (Object)"addRowsIndexConstant", (Object)4880.669677734375, (Object)"uniques", (Object)2.000977198748901)))));
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(expectedResults, this.runner.run((Query)query, context));
    }

    @Test
    public void testTopNLexicographicWithNonExistingPreviousStop() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension("market").metric((TopNMetricSpec)new LexicographicTopNMetricSpec("t")).threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"total_market", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814697265625, (Object)"addRowsIndexConstant", (Object)5356.814697265625, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"upfront", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669677734375, (Object)"addRowsIndexConstant", (Object)4880.669677734375, (Object)"uniques", (Object)2.000977198748901)))));
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(expectedResults, this.runner.run((Query)query, context));
    }

    @Test
    public void testTopNInvertedLexicographicWithPreviousStop() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension("market").metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new LexicographicTopNMetricSpec("upfront"))).threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"total_market", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814697265625, (Object)"addRowsIndexConstant", (Object)5356.814697265625, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"spot", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.8768157958984, (Object)"addRowsIndexConstant", (Object)2250.8768157958984, (Object)"uniques", (Object)9.019833517963864)))));
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(expectedResults, this.runner.run((Query)query, context));
    }

    @Test
    public void testTopNInvertedLexicographicWithNonExistingPreviousStop() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension("market").metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new LexicographicTopNMetricSpec("u"))).threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"total_market", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814697265625, (Object)"addRowsIndexConstant", (Object)5356.814697265625, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"spot", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.8768157958984, (Object)"addRowsIndexConstant", (Object)2250.8768157958984, (Object)"uniques", (Object)9.019833517963864)))));
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(expectedResults, this.runner.run((Query)query, context));
    }

    @Test
    public void testTopNCollapsingDimExtraction() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension((DimensionSpec)new ExtractionDimensionSpec("quality", "quality", (ExtractionFn)new RegexDimExtractionFn(".(.)"), null)).metric("index").threshold(2).intervals(QueryRunnerTestHelper.fullOnInterval).aggregators(Arrays.asList(QueryRunnerTestHelper.rowsCount, QueryRunnerTestHelper.indexDoubleSum)).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"quality", (Object)"e", (Object)"rows", (Object)558L, (Object)"index", (Object)246645.1204032898, (Object)"addRowsIndexConstant", (Object)247204.1204032898), ImmutableMap.of((Object)"quality", (Object)"r", (Object)"rows", (Object)372L, (Object)"index", (Object)222051.08961486816, (Object)"addRowsIndexConstant", (Object)222424.08961486816)))));
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(expectedResults, this.runner.run((Query)query, context));
    }

    @Test
    public void testTopNDimExtraction() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension((DimensionSpec)new ExtractionDimensionSpec("market", "market", (ExtractionFn)new RegexDimExtractionFn("(.)"), null)).metric("rows").threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"s", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.8768157958984, (Object)"addRowsIndexConstant", (Object)2250.8768157958984, (Object)"uniques", (Object)9.019833517963864), ImmutableMap.of((Object)"market", (Object)"t", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814697265625, (Object)"addRowsIndexConstant", (Object)5356.814697265625, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"u", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669677734375, (Object)"addRowsIndexConstant", (Object)4880.669677734375, (Object)"uniques", (Object)2.000977198748901)))));
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(expectedResults, this.runner.run((Query)query, context));
    }

    @Test
    public void testTopNLexicographicDimExtraction() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension((DimensionSpec)new ExtractionDimensionSpec("market", "market", (ExtractionFn)new RegexDimExtractionFn("(.)"), null)).metric((TopNMetricSpec)new LexicographicTopNMetricSpec(null)).threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"s", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.8768157958984, (Object)"addRowsIndexConstant", (Object)2250.8768157958984, (Object)"uniques", (Object)9.019833517963864), ImmutableMap.of((Object)"market", (Object)"t", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814697265625, (Object)"addRowsIndexConstant", (Object)5356.814697265625, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"u", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669677734375, (Object)"addRowsIndexConstant", (Object)4880.669677734375, (Object)"uniques", (Object)2.000977198748901)))));
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(expectedResults, this.runner.run((Query)query, context));
    }

    @Test
    public void testInvertedTopNLexicographicDimExtraction2() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension((DimensionSpec)new ExtractionDimensionSpec("market", "market", (ExtractionFn)new RegexDimExtractionFn("..(.)"), null)).metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new LexicographicTopNMetricSpec(null))).threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"t", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814697265625, (Object)"addRowsIndexConstant", (Object)5356.814697265625, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"o", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.8768157958984, (Object)"addRowsIndexConstant", (Object)2250.8768157958984, (Object)"uniques", (Object)9.019833517963864), ImmutableMap.of((Object)"market", (Object)"f", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669677734375, (Object)"addRowsIndexConstant", (Object)4880.669677734375, (Object)"uniques", (Object)2.000977198748901)))));
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(expectedResults, this.runner.run((Query)query, context));
    }

    @Test
    public void testTopNLexicographicDimExtractionWithPreviousStop() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension((DimensionSpec)new ExtractionDimensionSpec("market", "market", (ExtractionFn)new RegexDimExtractionFn("(.)"), null)).metric((TopNMetricSpec)new LexicographicTopNMetricSpec("s")).threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"t", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814697265625, (Object)"addRowsIndexConstant", (Object)5356.814697265625, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"u", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669677734375, (Object)"addRowsIndexConstant", (Object)4880.669677734375, (Object)"uniques", (Object)2.000977198748901)))));
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(expectedResults, this.runner.run((Query)query, context));
    }

    @Test
    public void testTopNLexicographicDimExtractionWithSortingPreservedAndPreviousStop() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension((DimensionSpec)new ExtractionDimensionSpec("market", "market", (ExtractionFn)new DimExtractionFn(){

            public byte[] getCacheKey() {
                return new byte[0];
            }

            public String apply(String value) {
                return value.substring(0, 1);
            }

            public boolean preservesOrdering() {
                return true;
            }
        }, null)).metric((TopNMetricSpec)new LexicographicTopNMetricSpec("s")).threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"t", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814697265625, (Object)"addRowsIndexConstant", (Object)5356.814697265625, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"u", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669677734375, (Object)"addRowsIndexConstant", (Object)4880.669677734375, (Object)"uniques", (Object)2.000977198748901)))));
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(expectedResults, this.runner.run((Query)query, context));
    }

    @Test
    public void testInvertedTopNLexicographicDimExtractionWithPreviousStop() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension((DimensionSpec)new ExtractionDimensionSpec("market", "market", (ExtractionFn)new RegexDimExtractionFn("(.)"), null)).metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new LexicographicTopNMetricSpec("u"))).threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"t", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814697265625, (Object)"addRowsIndexConstant", (Object)5356.814697265625, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"s", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.8768157958984, (Object)"addRowsIndexConstant", (Object)2250.8768157958984, (Object)"uniques", (Object)9.019833517963864)))));
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(expectedResults, this.runner.run((Query)query, context));
    }

    @Test
    public void testInvertedTopNLexicographicDimExtractionWithPreviousStop2() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension((DimensionSpec)new ExtractionDimensionSpec("market", "market", (ExtractionFn)new RegexDimExtractionFn("..(.)"), null)).metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new LexicographicTopNMetricSpec("p"))).threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"o", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.8768157958984, (Object)"addRowsIndexConstant", (Object)2250.8768157958984, (Object)"uniques", (Object)9.019833517963864), ImmutableMap.of((Object)"market", (Object)"f", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669677734375, (Object)"addRowsIndexConstant", (Object)4880.669677734375, (Object)"uniques", (Object)2.000977198748901)))));
        TestHelper.assertExpectedResults(expectedResults, this.runner.run((Query)query, new HashMap()));
    }

    @Test
    public void testTopNWithNullProducingDimExtractionFn() {
        DimExtractionFn nullStringDimExtraction = new DimExtractionFn(){

            public byte[] getCacheKey() {
                return new byte[]{-1};
            }

            public String apply(String dimValue) {
                return dimValue.equals("total_market") ? null : dimValue;
            }

            public boolean preservesOrdering() {
                return false;
            }
        };
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).metric("rows").threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).dimension((DimensionSpec)new ExtractionDimensionSpec("market", "market", (ExtractionFn)nullStringDimExtraction, null)).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"spot", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.8768157958984, (Object)"addRowsIndexConstant", (Object)2250.8768157958984, (Object)"uniques", (Object)9.019833517963864), new LinkedHashMap<String, Object>(){
            {
                this.put("market", null);
                this.put("rows", 4L);
                this.put("index", 5351.814697265625);
                this.put("addRowsIndexConstant", 5356.814697265625);
                this.put("uniques", 2.000977198748901);
            }
        }, ImmutableMap.of((Object)"market", (Object)"upfront", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669677734375, (Object)"addRowsIndexConstant", (Object)4880.669677734375, (Object)"uniques", (Object)2.000977198748901)))));
        TestHelper.assertExpectedResults(expectedResults, this.runner.run((Query)query, (Map)Maps.newHashMap()));
    }

    @Test
    public void testTopNWithEmptyStringProducingDimExtractionFn() {
        DimExtractionFn emptyStringDimExtraction = new DimExtractionFn(){

            public byte[] getCacheKey() {
                return new byte[]{-1};
            }

            public String apply(String dimValue) {
                return dimValue.equals("total_market") ? "" : dimValue;
            }

            public boolean preservesOrdering() {
                return false;
            }
        };
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).metric("rows").threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).dimension((DimensionSpec)new ExtractionDimensionSpec("market", "market", (ExtractionFn)emptyStringDimExtraction, null)).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"spot", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.8768157958984, (Object)"addRowsIndexConstant", (Object)2250.8768157958984, (Object)"uniques", (Object)9.019833517963864), new LinkedHashMap<String, Object>(){
            {
                this.put("market", "");
                this.put("rows", 4L);
                this.put("index", 5351.814697265625);
                this.put("addRowsIndexConstant", 5356.814697265625);
                this.put("uniques", 2.000977198748901);
            }
        }, ImmutableMap.of((Object)"market", (Object)"upfront", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669677734375, (Object)"addRowsIndexConstant", (Object)4880.669677734375, (Object)"uniques", (Object)2.000977198748901)))));
        TestHelper.assertExpectedResults(expectedResults, this.runner.run((Query)query, (Map)Maps.newHashMap()));
    }

    @Test
    public void testInvertedTopNQuery() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension("market").metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new NumericTopNMetricSpec("index"))).threshold(3).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"spot", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.8768157958984, (Object)"addRowsIndexConstant", (Object)2250.8768157958984, (Object)"uniques", (Object)9.019833517963864), ImmutableMap.of((Object)"market", (Object)"upfront", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669677734375, (Object)"addRowsIndexConstant", (Object)4880.669677734375, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"total_market", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814697265625, (Object)"addRowsIndexConstant", (Object)5356.814697265625, (Object)"uniques", (Object)2.000977198748901)))));
        TestHelper.assertExpectedResults(expectedResults, this.runner.run((Query)query, new HashMap()));
    }

    @Test
    public void testTopNQueryByComplexMetric() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension("market").metric((TopNMetricSpec)new NumericTopNMetricSpec("numVals")).threshold(10).intervals(QueryRunnerTestHelper.firstToThird).aggregators((List)Lists.newArrayList((Object[])new AggregatorFactory[]{new CardinalityAggregatorFactory("numVals", (List)ImmutableList.of((Object)"market"), false)})).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"spot", (Object)"numVals", (Object)1.0002442201269182), ImmutableMap.of((Object)"market", (Object)"total_market", (Object)"numVals", (Object)1.0002442201269182), ImmutableMap.of((Object)"market", (Object)"upfront", (Object)"numVals", (Object)1.0002442201269182)))));
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(expectedResults, this.runner.run((Query)query, context));
    }

    @Test
    public void testTopNDependentPostAgg() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension("market").metric(QueryRunnerTestHelper.dependentPostAggMetric).threshold(4).intervals(QueryRunnerTestHelper.fullOnInterval).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(QueryRunnerTestHelper.commonAggregators, (Iterable)Lists.newArrayList((Object[])new AggregatorFactory[]{new MaxAggregatorFactory("maxIndex", "index"), new MinAggregatorFactory("minIndex", "index")})))).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant, QueryRunnerTestHelper.dependentPostAgg, QueryRunnerTestHelper.hyperUniqueFinalizingPostAgg)).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"rows", (Object)186L).put((Object)"index", (Object)215679.82879638672).put((Object)"addRowsIndexConstant", (Object)215866.82879638672).put((Object)QueryRunnerTestHelper.dependentPostAggMetric, (Object)216053.82879638672).put((Object)"uniques", (Object)2.000977198748901).put((Object)"maxIndex", (Object)1743.9217529296875).put((Object)"minIndex", (Object)792.3260498046875).put((Object)"hyperUniqueFinalizingPostAggMetric", (Object)3.000977198748901).build(), ImmutableMap.builder().put((Object)"market", (Object)"upfront").put((Object)"rows", (Object)186L).put((Object)"index", (Object)192046.1060180664).put((Object)"addRowsIndexConstant", (Object)192233.1060180664).put((Object)QueryRunnerTestHelper.dependentPostAggMetric, (Object)192420.1060180664).put((Object)"uniques", (Object)2.000977198748901).put((Object)"maxIndex", (Object)1870.06103515625).put((Object)"minIndex", (Object)545.9906005859375).put((Object)"hyperUniqueFinalizingPostAggMetric", (Object)3.000977198748901).build(), ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)837L).put((Object)"index", (Object)95606.57232284546).put((Object)"addRowsIndexConstant", (Object)96444.57232284546).put((Object)QueryRunnerTestHelper.dependentPostAggMetric, (Object)97282.57232284546).put((Object)"uniques", (Object)9.019833517963864).put((Object)"hyperUniqueFinalizingPostAggMetric", (Object)10.019833517963864).put((Object)"maxIndex", (Object)277.2735290527344).put((Object)"minIndex", (Object)59.02102279663086).build()))));
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(expectedResults, this.runner.run((Query)query, context));
    }

    @Test
    public void testTopNBySegmentResults() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension("market").metric(QueryRunnerTestHelper.dependentPostAggMetric).threshold(4).intervals(QueryRunnerTestHelper.fullOnInterval).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(QueryRunnerTestHelper.commonAggregators, (Iterable)Lists.newArrayList((Object[])new AggregatorFactory[]{new MaxAggregatorFactory("maxIndex", "index"), new MinAggregatorFactory("minIndex", "index")})))).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant, QueryRunnerTestHelper.dependentPostAgg)).context((Map)ImmutableMap.of((Object)"finalize", (Object)true, (Object)"bySegment", (Object)true)).build();
        TopNResultValue topNResult = new TopNResultValue(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"rows", (Object)186L).put((Object)"index", (Object)215679.82879638672).put((Object)"addRowsIndexConstant", (Object)215866.82879638672).put((Object)QueryRunnerTestHelper.dependentPostAggMetric, (Object)216053.82879638672).put((Object)"uniques", (Object)2.000977198748901).put((Object)"maxIndex", (Object)1743.9217529296875).put((Object)"minIndex", (Object)792.3260498046875).build(), ImmutableMap.builder().put((Object)"market", (Object)"upfront").put((Object)"rows", (Object)186L).put((Object)"index", (Object)192046.1060180664).put((Object)"addRowsIndexConstant", (Object)192233.1060180664).put((Object)QueryRunnerTestHelper.dependentPostAggMetric, (Object)192420.1060180664).put((Object)"uniques", (Object)2.000977198748901).put((Object)"maxIndex", (Object)1870.06103515625).put((Object)"minIndex", (Object)545.9906005859375).build(), ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)837L).put((Object)"index", (Object)95606.57232284546).put((Object)"addRowsIndexConstant", (Object)96444.57232284546).put((Object)QueryRunnerTestHelper.dependentPostAggMetric, (Object)97282.57232284546).put((Object)"uniques", (Object)9.019833517963864).put((Object)"maxIndex", (Object)277.2735290527344).put((Object)"minIndex", (Object)59.02102279663086).build()));
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new BySegmentResultValueClass(Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)topNResult)), "testSegment", new Interval((Object)"1970-01-01T00:00:00.000Z/2020-01-01T00:00:00.000Z"))));
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(expectedResults, this.runner.run((Query)query, context));
    }

    @Test
    public void testTopNWithTimeColumn() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").intervals(QueryRunnerTestHelper.firstToThird).aggregators(Arrays.asList(QueryRunnerTestHelper.rowsCount, QueryRunnerTestHelper.jsCountIfTimeGreaterThan, QueryRunnerTestHelper.__timeLongSum)).granularity(QueryRunnerTestHelper.allGran).dimension("market").metric("ntimestamps").threshold(3).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"spot", (Object)"rows", (Object)18L, (Object)"ntimestamps", (Object)9.0, (Object)"sumtime", (Object)23429865600000L), ImmutableMap.of((Object)"market", (Object)"total_market", (Object)"rows", (Object)4L, (Object)"ntimestamps", (Object)2.0, (Object)"sumtime", (Object)5206636800000L), ImmutableMap.of((Object)"market", (Object)"upfront", (Object)"rows", (Object)4L, (Object)"ntimestamps", (Object)2.0, (Object)"sumtime", (Object)5206636800000L)))));
        TestHelper.assertExpectedResults(expectedResults, this.runner.run((Query)query, (Map)Maps.newHashMap()));
    }

    @Test
    public void testTopNTimeExtraction() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension((DimensionSpec)new ExtractionDimensionSpec("__time", "dayOfWeek", (ExtractionFn)new TimeFormatExtractionFn("EEEE", null, null), null)).metric("index").threshold(2).intervals(QueryRunnerTestHelper.fullOnInterval).aggregators(Arrays.asList(QueryRunnerTestHelper.rowsCount, QueryRunnerTestHelper.indexDoubleSum)).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"dayOfWeek", (Object)"Wednesday", (Object)"rows", (Object)182L, (Object)"index", (Object)76010.28100585938, (Object)"addRowsIndexConstant", (Object)76193.28100585938), ImmutableMap.of((Object)"dayOfWeek", (Object)"Thursday", (Object)"rows", (Object)182L, (Object)"index", (Object)75203.26300811768, (Object)"addRowsIndexConstant", (Object)75386.26300811768)))));
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(expectedResults, this.runner.run((Query)query, context));
    }
}

