/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.timeseries;

import com.google.common.collect.ImmutableMap;
import io.druid.granularity.QueryGranularity;
import io.druid.query.Result;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.CountAggregatorFactory;
import io.druid.query.aggregation.LongSumAggregatorFactory;
import io.druid.query.timeseries.TimeseriesBinaryFn;
import io.druid.query.timeseries.TimeseriesResultValue;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.joda.time.DateTime;
import org.junit.Test;

public class TimeseriesBinaryFnTest {
    final CountAggregatorFactory rowsCount = new CountAggregatorFactory("rows");
    final LongSumAggregatorFactory indexLongSum = new LongSumAggregatorFactory("index", "index");
    final List<AggregatorFactory> aggregatorFactories = Arrays.asList(this.rowsCount, this.indexLongSum);
    final DateTime currTime = new DateTime();

    @Test
    public void testMerge() {
        Result result1 = new Result(this.currTime, (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)1L, (Object)"index", (Object)2L)));
        Result result2 = new Result(this.currTime, (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)2L, (Object)"index", (Object)3L)));
        Result expected = new Result(this.currTime, (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)3L, (Object)"index", (Object)5L)));
        Result actual = new TimeseriesBinaryFn(QueryGranularity.ALL, this.aggregatorFactories).apply(result1, result2);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testMergeDay() {
        Result result1 = new Result(this.currTime, (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)1L, (Object)"index", (Object)2L)));
        Result result2 = new Result(this.currTime, (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)2L, (Object)"index", (Object)3L)));
        Result expected = new Result(new DateTime(QueryGranularity.DAY.truncate(this.currTime.getMillis())), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)3L, (Object)"index", (Object)5L)));
        Result actual = new TimeseriesBinaryFn(QueryGranularity.DAY, this.aggregatorFactories).apply(result1, result2);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testMergeOneNullResult() {
        Result result1 = new Result(this.currTime, (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)1L, (Object)"index", (Object)2L)));
        Result result2 = null;
        Result expected = result1;
        Result actual = new TimeseriesBinaryFn(QueryGranularity.ALL, this.aggregatorFactories).apply(result1, result2);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testMergeShiftedTimestamp() {
        Result result1 = new Result(this.currTime, (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)1L, (Object)"index", (Object)2L)));
        Result result2 = new Result(this.currTime.plusHours(2), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)2L, (Object)"index", (Object)3L)));
        Result expected = new Result(this.currTime, (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)3L, (Object)"index", (Object)5L)));
        Result actual = new TimeseriesBinaryFn(QueryGranularity.ALL, this.aggregatorFactories).apply(result1, result2);
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

