/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.timeseries;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import io.druid.query.DataSource;
import io.druid.query.Druids;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerFactory;
import io.druid.query.QueryRunnerTestHelper;
import io.druid.query.QueryToolChest;
import io.druid.query.Result;
import io.druid.query.TableDataSource;
import io.druid.query.UnionDataSource;
import io.druid.query.UnionQueryRunner;
import io.druid.query.aggregation.LongSumAggregatorFactory;
import io.druid.query.timeseries.TimeseriesQuery;
import io.druid.query.timeseries.TimeseriesQueryEngine;
import io.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import io.druid.query.timeseries.TimeseriesQueryRunnerFactory;
import io.druid.query.timeseries.TimeseriesResultValue;
import io.druid.segment.TestHelper;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TimeSeriesUnionQueryRunnerTest {
    private final QueryRunner runner;

    public TimeSeriesUnionQueryRunnerTest(QueryRunner runner) {
        this.runner = runner;
    }

    @Parameterized.Parameters
    public static Collection<?> constructorFeeder() throws IOException {
        return QueryRunnerTestHelper.makeUnionQueryRunners((QueryRunnerFactory)new TimeseriesQueryRunnerFactory(new TimeseriesQueryQueryToolChest(QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()), new TimeseriesQueryEngine(), QueryRunnerTestHelper.NOOP_QUERYWATCHER), (DataSource)QueryRunnerTestHelper.unionDataSource);
    }

    @Test
    public void testUnionTimeseries() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource((DataSource)QueryRunnerTestHelper.unionDataSource).granularity(QueryRunnerTestHelper.dayGran).intervals(QueryRunnerTestHelper.firstToThird).aggregators(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"), QueryRunnerTestHelper.qualityUniques)).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)52L, (Object)"idx", (Object)26476L, (Object)"uniques", (Object)9.019833517963864))), new Result(new DateTime((Object)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)52L, (Object)"idx", (Object)23308L, (Object)"uniques", (Object)9.019833517963864))));
        HashMap context = new HashMap();
        List results = Sequences.toList((Sequence)this.runner.run((Query)query, context), (List)Lists.newArrayList());
        TestHelper.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testUnionResultMerging() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource((DataSource)new UnionDataSource((List)Lists.newArrayList((Object[])new TableDataSource[]{new TableDataSource("ds1"), new TableDataSource("ds2")}))).granularity(QueryRunnerTestHelper.dayGran).intervals(QueryRunnerTestHelper.firstToThird).aggregators(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).build();
        TimeseriesQueryQueryToolChest toolChest = new TimeseriesQueryQueryToolChest(QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator());
        QueryRunner mergingrunner = toolChest.mergeResults((QueryRunner)new UnionQueryRunner(Arrays.asList(new QueryRunner<Result<TimeseriesResultValue>>(){

            public Sequence<Result<TimeseriesResultValue>> run(Query<Result<TimeseriesResultValue>> query, Map<String, Object> context) {
                return Sequences.simple((Iterable)Lists.newArrayList((Object[])new Result[]{new Result(new DateTime((Object)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)1L, (Object)"idx", (Object)2L))), new Result(new DateTime((Object)"2011-04-03"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)3L, (Object)"idx", (Object)4L)))}));
            }
        }, new QueryRunner<Result<TimeseriesResultValue>>(){

            public Sequence<Result<TimeseriesResultValue>> run(Query<Result<TimeseriesResultValue>> query, Map<String, Object> context) {
                return Sequences.simple((Iterable)Lists.newArrayList((Object[])new Result[]{new Result(new DateTime((Object)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)5L, (Object)"idx", (Object)6L))), new Result(new DateTime((Object)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)7L, (Object)"idx", (Object)8L))), new Result(new DateTime((Object)"2011-04-04"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)9L, (Object)"idx", (Object)10L)))}));
            }
        }), (QueryToolChest)toolChest));
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)5L, (Object)"idx", (Object)6L))), new Result(new DateTime((Object)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)8L, (Object)"idx", (Object)10L))), new Result(new DateTime((Object)"2011-04-03"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)3L, (Object)"idx", (Object)4L))), new Result(new DateTime((Object)"2011-04-04"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)9L, (Object)"idx", (Object)10L))));
        List results = Sequences.toList((Sequence)mergingrunner.run((Query)query, (Map)Maps.newHashMap()), (List)Lists.newArrayList());
        System.out.println(results);
        TestHelper.assertExpectedResults(expectedResults, results);
    }
}

