/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.timeboundary;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import io.druid.jackson.DefaultObjectMapper;
import io.druid.query.Druids;
import io.druid.query.Query;
import io.druid.query.timeboundary.TimeBoundaryQuery;
import java.io.IOException;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class TimeBoundaryQueryTest {
    private static final ObjectMapper jsonMapper = new DefaultObjectMapper();

    @Test
    public void testQuerySerialization() throws IOException {
        TimeBoundaryQuery query = Druids.newTimeBoundaryQueryBuilder().dataSource("testing").build();
        String json = jsonMapper.writeValueAsString((Object)query);
        Query serdeQuery = (Query)jsonMapper.readValue(json, Query.class);
        Assert.assertEquals((Object)query, (Object)serdeQuery);
    }

    @Test
    public void testContextSerde() throws Exception {
        TimeBoundaryQuery query = Druids.newTimeBoundaryQueryBuilder().dataSource("foo").intervals("2013/2014").context((Map)ImmutableMap.of((Object)"priority", (Object)1, (Object)"useCache", (Object)true, (Object)"populateCache", (Object)true, (Object)"finalize", (Object)true)).build();
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        TimeBoundaryQuery serdeQuery = (TimeBoundaryQuery)mapper.readValue(mapper.writeValueAsBytes(mapper.readValue(mapper.writeValueAsString((Object)query), TimeBoundaryQuery.class)), TimeBoundaryQuery.class);
        Assert.assertEquals((Object)1, (Object)serdeQuery.getContextValue("priority"));
        Assert.assertEquals((Object)true, (Object)serdeQuery.getContextValue("useCache"));
        Assert.assertEquals((Object)true, (Object)serdeQuery.getContextValue("populateCache"));
        Assert.assertEquals((Object)true, (Object)serdeQuery.getContextValue("finalize"));
    }

    @Test
    public void testContextSerde2() throws Exception {
        TimeBoundaryQuery query = Druids.newTimeBoundaryQueryBuilder().dataSource("foo").intervals("2013/2014").context((Map)ImmutableMap.of((Object)"priority", (Object)"1", (Object)"useCache", (Object)"true", (Object)"populateCache", (Object)"true", (Object)"finalize", (Object)"true")).build();
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        TimeBoundaryQuery serdeQuery = (TimeBoundaryQuery)mapper.readValue(mapper.writeValueAsBytes(mapper.readValue(mapper.writeValueAsString((Object)query), TimeBoundaryQuery.class)), TimeBoundaryQuery.class);
        Assert.assertEquals((Object)"1", (Object)serdeQuery.getContextValue("priority"));
        Assert.assertEquals((Object)"true", (Object)serdeQuery.getContextValue("useCache"));
        Assert.assertEquals((Object)"true", (Object)serdeQuery.getContextValue("populateCache"));
        Assert.assertEquals((Object)"true", (Object)serdeQuery.getContextValue("finalize"));
    }
}

