/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.timeboundary;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import io.druid.query.DataSource;
import io.druid.query.Druids;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerFactory;
import io.druid.query.QueryRunnerTestHelper;
import io.druid.query.Result;
import io.druid.query.TableDataSource;
import io.druid.query.timeboundary.TimeBoundaryQuery;
import io.druid.query.timeboundary.TimeBoundaryQueryRunnerFactory;
import io.druid.query.timeboundary.TimeBoundaryResultValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TimeBoundaryQueryRunnerTest {
    private final QueryRunner runner;

    @Parameterized.Parameters
    public static Collection<?> constructorFeeder() throws IOException {
        return QueryRunnerTestHelper.makeQueryRunners((QueryRunnerFactory)new TimeBoundaryQueryRunnerFactory(QueryRunnerTestHelper.NOOP_QUERYWATCHER));
    }

    public TimeBoundaryQueryRunnerTest(QueryRunner runner) {
        this.runner = runner;
    }

    @Test
    public void testTimeBoundary() {
        TimeBoundaryQuery timeBoundaryQuery = Druids.newTimeBoundaryQueryBuilder().dataSource("testing").build();
        HashMap context = new HashMap();
        List results = Sequences.toList((Sequence)this.runner.run((Query)timeBoundaryQuery, context), (List)Lists.newArrayList());
        TimeBoundaryResultValue val = (TimeBoundaryResultValue)((Result)results.iterator().next()).getValue();
        DateTime minTime = val.getMinTime();
        DateTime maxTime = val.getMaxTime();
        Assert.assertEquals((Object)new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)minTime);
        Assert.assertEquals((Object)new DateTime((Object)"2011-04-15T00:00:00.000Z"), (Object)maxTime);
    }

    @Test
    public void testTimeBoundaryMax() {
        TimeBoundaryQuery timeBoundaryQuery = Druids.newTimeBoundaryQueryBuilder().dataSource("testing").bound("maxTime").build();
        ConcurrentMap context = new MapMaker().makeMap();
        context.put(Result.MISSING_SEGMENTS_KEY, Lists.newArrayList());
        List results = Sequences.toList((Sequence)this.runner.run((Query)timeBoundaryQuery, (Map)context), (List)Lists.newArrayList());
        TimeBoundaryResultValue val = (TimeBoundaryResultValue)((Result)results.iterator().next()).getValue();
        DateTime minTime = val.getMinTime();
        DateTime maxTime = val.getMaxTime();
        Assert.assertNull((Object)minTime);
        Assert.assertEquals((Object)new DateTime((Object)"2011-04-15T00:00:00.000Z"), (Object)maxTime);
    }

    @Test
    public void testTimeBoundaryMin() {
        TimeBoundaryQuery timeBoundaryQuery = Druids.newTimeBoundaryQueryBuilder().dataSource("testing").bound("minTime").build();
        ConcurrentMap context = new MapMaker().makeMap();
        context.put(Result.MISSING_SEGMENTS_KEY, Lists.newArrayList());
        List results = Sequences.toList((Sequence)this.runner.run((Query)timeBoundaryQuery, (Map)context), (List)Lists.newArrayList());
        TimeBoundaryResultValue val = (TimeBoundaryResultValue)((Result)results.iterator().next()).getValue();
        DateTime minTime = val.getMinTime();
        DateTime maxTime = val.getMaxTime();
        Assert.assertEquals((Object)new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)minTime);
        Assert.assertNull((Object)maxTime);
    }

    @Test
    public void testMergeResults() throws Exception {
        List<Result> results = Arrays.asList(new Result(new DateTime(), (Object)new TimeBoundaryResultValue((Object)ImmutableMap.of((Object)"maxTime", (Object)"2012-01-01", (Object)"minTime", (Object)"2011-01-01"))), new Result(new DateTime(), (Object)new TimeBoundaryResultValue((Object)ImmutableMap.of((Object)"maxTime", (Object)"2012-02-01", (Object)"minTime", (Object)"2011-01-01"))));
        TimeBoundaryQuery query = new TimeBoundaryQuery((DataSource)new TableDataSource("test"), null, null, null);
        Iterable actual = query.mergeResults(results);
        Assert.assertTrue((boolean)((TimeBoundaryResultValue)((Result)actual.iterator().next()).getValue()).getMaxTime().equals((Object)new DateTime((Object)"2012-02-01")));
    }

    @Test
    public void testMergeResultsEmptyResults() throws Exception {
        ArrayList results = Lists.newArrayList();
        TimeBoundaryQuery query = new TimeBoundaryQuery((DataSource)new TableDataSource("test"), null, null, null);
        Iterable actual = query.mergeResults((List)results);
        Assert.assertFalse((boolean)actual.iterator().hasNext());
    }
}

