/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.search;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import io.druid.query.Druids;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerFactory;
import io.druid.query.QueryRunnerTestHelper;
import io.druid.query.Result;
import io.druid.query.filter.AndDimFilter;
import io.druid.query.filter.DimFilter;
import io.druid.query.filter.OrDimFilter;
import io.druid.query.search.SearchQueryQueryToolChest;
import io.druid.query.search.SearchQueryRunnerFactory;
import io.druid.query.search.search.FragmentSearchQuerySpec;
import io.druid.query.search.search.SearchHit;
import io.druid.query.search.search.SearchQuery;
import io.druid.query.search.search.SearchQueryConfig;
import io.druid.query.search.search.SearchQuerySpec;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SearchQueryRunnerTest {
    private final QueryRunner runner;

    @Parameterized.Parameters
    public static Collection<?> constructorFeeder() throws IOException {
        return QueryRunnerTestHelper.makeQueryRunners((QueryRunnerFactory)new SearchQueryRunnerFactory(new SearchQueryQueryToolChest(new SearchQueryConfig(), QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()), QueryRunnerTestHelper.NOOP_QUERYWATCHER));
    }

    public SearchQueryRunnerTest(QueryRunner runner) {
        this.runner = runner;
    }

    @Test
    public void testSearch() {
        SearchQuery searchQuery = Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).intervals(QueryRunnerTestHelper.fullOnInterval).query("a").build();
        TreeMap expectedResults = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
        expectedResults.put("quality", Sets.newHashSet((Object[])new String[]{"automotive", "mezzanine", "travel", "health", "entertainment"}));
        expectedResults.put("market", Sets.newHashSet((Object[])new String[]{"total_market"}));
        expectedResults.put("placementish", Sets.newHashSet((Object[])new String[]{"a"}));
        this.checkSearchQuery(searchQuery, expectedResults);
    }

    @Test
    public void testSearchSameValueInMultiDims() {
        SearchQuery searchQuery = Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).intervals(QueryRunnerTestHelper.fullOnInterval).dimensions(Arrays.asList("placement", "placementish")).query("e").build();
        TreeMap expectedResults = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
        expectedResults.put("placement", Sets.newHashSet((Object[])new String[]{"preferred"}));
        expectedResults.put("placementish", Sets.newHashSet((Object[])new String[]{"e", "preferred"}));
        this.checkSearchQuery(searchQuery, expectedResults);
    }

    @Test
    public void testFragmentSearch() {
        SearchQuery searchQuery = Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).intervals(QueryRunnerTestHelper.fullOnInterval).query((SearchQuerySpec)new FragmentSearchQuerySpec(Arrays.asList("auto", "ve"))).build();
        TreeMap expectedResults = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
        expectedResults.put("quality", Sets.newHashSet((Object[])new String[]{"automotive"}));
        this.checkSearchQuery(searchQuery, expectedResults);
    }

    @Test
    public void testSearchWithDimensionQuality() {
        HashMap<String, Set<String>> expectedResults = new HashMap<String, Set<String>>();
        expectedResults.put("quality", new HashSet<String>(Arrays.asList("automotive", "mezzanine", "travel", "health", "entertainment")));
        this.checkSearchQuery(Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimensions("quality").intervals(QueryRunnerTestHelper.fullOnInterval).query("a").build(), expectedResults);
    }

    @Test
    public void testSearchWithDimensionProvider() {
        TreeMap expectedResults = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
        expectedResults.put("market", new HashSet<String>(Arrays.asList("total_market")));
        this.checkSearchQuery(Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimensions("market").intervals(QueryRunnerTestHelper.fullOnInterval).query("a").build(), expectedResults);
    }

    @Test
    public void testSearchWithDimensionsQualityAndProvider() {
        TreeMap expectedResults = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
        expectedResults.putAll(ImmutableMap.of((Object)"quality", new HashSet<String>(Arrays.asList("automotive", "mezzanine", "travel", "health", "entertainment")), (Object)"market", new HashSet<String>(Arrays.asList("total_market"))));
        this.checkSearchQuery(Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimensions(Arrays.asList("quality", "market")).intervals(QueryRunnerTestHelper.fullOnInterval).query("a").build(), expectedResults);
    }

    @Test
    public void testSearchWithDimensionsPlacementAndProvider() {
        TreeMap expectedResults = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
        expectedResults.put("market", new HashSet<String>(Arrays.asList("total_market")));
        this.checkSearchQuery(Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimensions(Arrays.asList("placementish", "market")).intervals(QueryRunnerTestHelper.fullOnInterval).query("mark").build(), expectedResults);
    }

    @Test
    public void testSearchWithSingleFilter1() {
        TreeMap expectedResults = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
        expectedResults.put("quality", new HashSet<String>(Arrays.asList("automotive")));
        this.checkSearchQuery(Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).filters("quality", "automotive").intervals(QueryRunnerTestHelper.fullOnInterval).dimensions("quality").query("a").build(), expectedResults);
    }

    @Test
    public void testSearchWithSingleFilter2() {
        TreeMap expectedResults = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
        expectedResults.put("market", new HashSet<String>(Arrays.asList("total_market")));
        this.checkSearchQuery(Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).filters("market", "total_market").intervals(QueryRunnerTestHelper.fullOnInterval).dimensions("market").query("a").build(), expectedResults);
    }

    @Test
    public void testSearchMultiAndFilter() {
        TreeMap expectedResults = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
        expectedResults.put("quality", new HashSet<String>(Arrays.asList("automotive")));
        AndDimFilter filter = Druids.newAndDimFilterBuilder().fields(Arrays.asList(Druids.newSelectorDimFilterBuilder().dimension("market").value("spot").build(), Druids.newSelectorDimFilterBuilder().dimension("quality").value("automotive").build())).build();
        this.checkSearchQuery(Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).filters((DimFilter)filter).dimensions("quality").intervals(QueryRunnerTestHelper.fullOnInterval).query("a").build(), expectedResults);
    }

    @Test
    public void testSearchWithMultiOrFilter() {
        TreeMap expectedResults = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
        expectedResults.put("quality", new HashSet<String>(Arrays.asList("automotive")));
        OrDimFilter filter = Druids.newOrDimFilterBuilder().fields(Arrays.asList(Druids.newSelectorDimFilterBuilder().dimension("quality").value("total_market").build(), Druids.newSelectorDimFilterBuilder().dimension("quality").value("automotive").build())).build();
        this.checkSearchQuery(Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimensions("quality").filters((DimFilter)filter).intervals(QueryRunnerTestHelper.fullOnInterval).query("a").build(), expectedResults);
    }

    @Test
    public void testSearchWithEmptyResults() {
        TreeMap expectedResults = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
        this.checkSearchQuery(Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).intervals(QueryRunnerTestHelper.fullOnInterval).query("abcd123").build(), expectedResults);
    }

    @Test
    public void testSearchWithFilterEmptyResults() {
        TreeMap expectedResults = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
        AndDimFilter filter = Druids.newAndDimFilterBuilder().fields(Arrays.asList(Druids.newSelectorDimFilterBuilder().dimension("market").value("total_market").build(), Druids.newSelectorDimFilterBuilder().dimension("quality").value("automotive").build())).build();
        this.checkSearchQuery(Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).filters((DimFilter)filter).intervals(QueryRunnerTestHelper.fullOnInterval).query("a").build(), expectedResults);
    }

    @Test
    public void testSearchNonExistingDimension() {
        TreeMap expectedResults = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
        this.checkSearchQuery(Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).intervals(QueryRunnerTestHelper.fullOnInterval).dimensions("does_not_exist").query("a").build(), expectedResults);
    }

    private void checkSearchQuery(SearchQuery searchQuery, Map<String, Set<String>> expectedResults) {
        HashMap context = new HashMap();
        List results = Sequences.toList((Sequence)this.runner.run((Query)searchQuery, context), (List)Lists.newArrayList());
        for (Result result : results) {
            Assert.assertEquals((Object)new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)result.getTimestamp());
            Assert.assertTrue((boolean)(result.getValue() instanceof Iterable));
            Iterable resultValues = (Iterable)result.getValue();
            for (SearchHit resultValue : resultValues) {
                String dimension = resultValue.getDimension();
                String theValue = resultValue.getValue();
                Assert.assertTrue((String)String.format("Result had unknown dimension[%s]", dimension), (boolean)expectedResults.containsKey(dimension));
                Set<String> expectedSet = expectedResults.get(dimension);
                Assert.assertTrue((String)String.format("Couldn't remove dim[%s], value[%s]", dimension, theValue), (boolean)expectedSet.remove(theValue));
            }
        }
        for (Map.Entry entry : expectedResults.entrySet()) {
            Assert.assertTrue((String)String.format("Dimension[%s] should have had everything removed, still has[%s]", entry.getKey(), entry.getValue()), (boolean)((Set)entry.getValue()).isEmpty());
        }
    }
}

