/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.search;

import com.google.common.collect.ImmutableList;
import io.druid.granularity.QueryGranularity;
import io.druid.query.Result;
import io.druid.query.search.SearchBinaryFn;
import io.druid.query.search.SearchResultValue;
import io.druid.query.search.search.LexicographicSearchSortSpec;
import io.druid.query.search.search.SearchHit;
import io.druid.query.search.search.SearchSortSpec;
import io.druid.query.search.search.StrlenSearchSortSpec;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;
import org.joda.time.DateTime;
import org.junit.Test;

public class SearchBinaryFnTest {
    private final DateTime currTime = new DateTime();

    private void assertSearchMergeResult(Object o1, Object o2) {
        Iterator i1 = ((Iterable)o1).iterator();
        Iterator i2 = ((Iterable)o2).iterator();
        while (i1.hasNext() && i2.hasNext()) {
            Assert.assertEquals(i1.next(), i2.next());
        }
        Assert.assertTrue((!i1.hasNext() && !i2.hasNext() ? 1 : 0) != 0);
    }

    @Test
    public void testMerge() {
        Result r1 = new Result(this.currTime, (Object)new SearchResultValue((List)ImmutableList.of((Object)new SearchHit("blah", "foo"))));
        Result r2 = new Result(this.currTime, (Object)new SearchResultValue((List)ImmutableList.of((Object)new SearchHit("blah2", "foo2"))));
        Result expected = new Result(this.currTime, (Object)new SearchResultValue((List)ImmutableList.of((Object)new SearchHit("blah", "foo"), (Object)new SearchHit("blah2", "foo2"))));
        Result actual = new SearchBinaryFn((SearchSortSpec)new LexicographicSearchSortSpec(), QueryGranularity.ALL, Integer.MAX_VALUE).apply(r1, r2);
        Assert.assertEquals((Object)expected.getTimestamp(), (Object)actual.getTimestamp());
        this.assertSearchMergeResult(expected.getValue(), actual.getValue());
    }

    @Test
    public void testMergeDay() {
        Result r1 = new Result(this.currTime, (Object)new SearchResultValue((List)ImmutableList.of((Object)new SearchHit("blah", "foo"))));
        Result r2 = new Result(this.currTime, (Object)new SearchResultValue((List)ImmutableList.of((Object)new SearchHit("blah2", "foo2"))));
        Result expected = new Result(new DateTime(QueryGranularity.DAY.truncate(this.currTime.getMillis())), (Object)new SearchResultValue((List)ImmutableList.of((Object)new SearchHit("blah", "foo"), (Object)new SearchHit("blah2", "foo2"))));
        Result actual = new SearchBinaryFn((SearchSortSpec)new LexicographicSearchSortSpec(), QueryGranularity.DAY, Integer.MAX_VALUE).apply(r1, r2);
        Assert.assertEquals((Object)expected.getTimestamp(), (Object)actual.getTimestamp());
        this.assertSearchMergeResult(expected.getValue(), actual.getValue());
    }

    @Test
    public void testMergeOneResultNull() {
        Result r1 = new Result(this.currTime, (Object)new SearchResultValue((List)ImmutableList.of((Object)new SearchHit("blah", "foo"))));
        Result r2 = null;
        Result expected = r1;
        Result actual = new SearchBinaryFn((SearchSortSpec)new LexicographicSearchSortSpec(), QueryGranularity.ALL, Integer.MAX_VALUE).apply(r1, r2);
        Assert.assertEquals((Object)expected.getTimestamp(), (Object)actual.getTimestamp());
        this.assertSearchMergeResult(expected.getValue(), actual.getValue());
    }

    @Test
    public void testMergeShiftedTimestamp() {
        Result r1 = new Result(this.currTime, (Object)new SearchResultValue((List)ImmutableList.of((Object)new SearchHit("blah", "foo"))));
        Result r2 = new Result(this.currTime.plusHours(2), (Object)new SearchResultValue((List)ImmutableList.of((Object)new SearchHit("blah2", "foo2"))));
        Result expected = new Result(this.currTime, (Object)new SearchResultValue((List)ImmutableList.of((Object)new SearchHit("blah", "foo"), (Object)new SearchHit("blah2", "foo2"))));
        Result actual = new SearchBinaryFn((SearchSortSpec)new LexicographicSearchSortSpec(), QueryGranularity.ALL, Integer.MAX_VALUE).apply(r1, r2);
        Assert.assertEquals((Object)expected.getTimestamp(), (Object)actual.getTimestamp());
        this.assertSearchMergeResult(expected.getValue(), actual.getValue());
    }

    @Test
    public void testStrlenMerge() {
        Result r1 = new Result(this.currTime, (Object)new SearchResultValue((List)ImmutableList.of((Object)new SearchHit("blah", "thisislong"))));
        Result r2 = new Result(this.currTime, (Object)new SearchResultValue((List)ImmutableList.of((Object)new SearchHit("blah", "short"))));
        Result expected = new Result(this.currTime, (Object)new SearchResultValue((List)ImmutableList.of((Object)new SearchHit("blah", "short"), (Object)new SearchHit("blah", "thisislong"))));
        Result actual = new SearchBinaryFn((SearchSortSpec)new StrlenSearchSortSpec(), QueryGranularity.ALL, Integer.MAX_VALUE).apply(r1, r2);
        Assert.assertEquals((Object)expected.getTimestamp(), (Object)actual.getTimestamp());
        this.assertSearchMergeResult(expected.getValue(), actual.getValue());
    }

    @Test
    public void testMergeUniqueResults() {
        Result r1;
        Result r2 = r1 = new Result(this.currTime, (Object)new SearchResultValue((List)ImmutableList.of((Object)new SearchHit("blah", "foo"))));
        Result expected = r1;
        Result actual = new SearchBinaryFn((SearchSortSpec)new LexicographicSearchSortSpec(), QueryGranularity.ALL, Integer.MAX_VALUE).apply(r1, r2);
        Assert.assertEquals((Object)expected.getTimestamp(), (Object)actual.getTimestamp());
        this.assertSearchMergeResult(expected.getValue(), actual.getValue());
    }

    @Test
    public void testMergeLimit() {
        Result r1 = new Result(this.currTime, (Object)new SearchResultValue((List)ImmutableList.of((Object)new SearchHit("blah", "foo"))));
        Result r2 = new Result(this.currTime, (Object)new SearchResultValue((List)ImmutableList.of((Object)new SearchHit("blah2", "foo2"))));
        Result expected = r1;
        Result actual = new SearchBinaryFn((SearchSortSpec)new LexicographicSearchSortSpec(), QueryGranularity.ALL, 1).apply(r1, r2);
        Assert.assertEquals((Object)expected.getTimestamp(), (Object)actual.getTimestamp());
        this.assertSearchMergeResult(expected.getValue(), actual.getValue());
    }
}

