/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.metadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import io.druid.jackson.DefaultObjectMapper;
import io.druid.query.Druids;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerFactory;
import io.druid.query.QueryRunnerTestHelper;
import io.druid.query.metadata.SegmentMetadataQueryQueryToolChest;
import io.druid.query.metadata.SegmentMetadataQueryRunnerFactory;
import io.druid.query.metadata.metadata.ColumnAnalysis;
import io.druid.query.metadata.metadata.ColumnIncluderator;
import io.druid.query.metadata.metadata.ListColumnIncluderator;
import io.druid.query.metadata.metadata.SegmentAnalysis;
import io.druid.query.metadata.metadata.SegmentMetadataQuery;
import io.druid.segment.QueryableIndexSegment;
import io.druid.segment.Segment;
import io.druid.segment.TestIndex;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class SegmentMetadataQueryTest {
    private final QueryRunner runner = SegmentMetadataQueryTest.makeQueryRunner((QueryRunnerFactory)new SegmentMetadataQueryRunnerFactory(new SegmentMetadataQueryQueryToolChest(), QueryRunnerTestHelper.NOOP_QUERYWATCHER));
    private ObjectMapper mapper = new DefaultObjectMapper();

    public static QueryRunner makeQueryRunner(QueryRunnerFactory factory) {
        return QueryRunnerTestHelper.makeQueryRunner(factory, (Segment)new QueryableIndexSegment("testSegment", TestIndex.getMMappedTestIndex()));
    }

    @Test
    public void testSegmentMetadataQuery() {
        SegmentMetadataQuery query = Druids.newSegmentMetadataQueryBuilder().dataSource("testing").intervals("2013/2014").toInclude((ColumnIncluderator)new ListColumnIncluderator(Arrays.asList("placement"))).merge(true).build();
        HashMap context = new HashMap();
        List results = Sequences.toList((Sequence)this.runner.run((Query)query, context), (List)Lists.newArrayList());
        SegmentAnalysis val = (SegmentAnalysis)results.iterator().next();
        Assert.assertEquals((Object)"testSegment", (Object)val.getId());
        Assert.assertEquals((long)69843L, (long)val.getSize());
        Assert.assertEquals(Arrays.asList(new Interval((Object)"2011-01-12T00:00:00.000Z/2011-04-15T00:00:00.001Z")), (Object)val.getIntervals());
        Assert.assertEquals((long)1L, (long)val.getColumns().size());
        ColumnAnalysis columnAnalysis = (ColumnAnalysis)val.getColumns().get("placement");
        Assert.assertEquals((Object)"STRING", (Object)columnAnalysis.getType());
        Assert.assertEquals((long)10881L, (long)columnAnalysis.getSize());
        Assert.assertEquals((Object)new Integer(1), (Object)columnAnalysis.getCardinality());
        Assert.assertNull((Object)columnAnalysis.getErrorMessage());
    }

    @Test
    public void testSerde() throws Exception {
        String queryStr = "{\n  \"queryType\":\"segmentMetadata\",\n  \"dataSource\":\"test_ds\",\n  \"intervals\":[\"2013-12-04T00:00:00.000Z/2013-12-05T00:00:00.000Z\"]\n}";
        Query query = (Query)this.mapper.readValue(queryStr, Query.class);
        Assert.assertTrue((boolean)(query instanceof SegmentMetadataQuery));
        Assert.assertEquals((Object)"test_ds", (Object)Iterables.getOnlyElement((Iterable)query.getDataSource().getNames()));
        Assert.assertEquals((Object)new Interval((Object)"2013-12-04T00:00:00.000Z/2013-12-05T00:00:00.000Z"), query.getIntervals().get(0));
        Assert.assertEquals((Object)query, (Object)this.mapper.readValue(this.mapper.writeValueAsString((Object)query), Query.class));
    }
}

