/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.metadata;

import com.google.common.collect.Lists;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import io.druid.query.DataSource;
import io.druid.query.LegacyDataSource;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerTestHelper;
import io.druid.query.metadata.SegmentMetadataQueryQueryToolChest;
import io.druid.query.metadata.SegmentMetadataQueryRunnerFactory;
import io.druid.query.metadata.metadata.ColumnAnalysis;
import io.druid.query.metadata.metadata.SegmentAnalysis;
import io.druid.query.metadata.metadata.SegmentMetadataQuery;
import io.druid.query.spec.QuerySegmentSpecs;
import io.druid.segment.IncrementalIndexSegment;
import io.druid.segment.QueryableIndexSegment;
import io.druid.segment.Segment;
import io.druid.segment.TestIndex;
import io.druid.segment.column.ValueType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.junit.Test;

public class SegmentAnalyzerTest {
    @Test
    public void testIncrementalDoesNotWork() throws Exception {
        List<SegmentAnalysis> results = this.getSegmentAnalysises((Segment)new IncrementalIndexSegment(TestIndex.getIncrementalTestIndex(false), null));
        Assert.assertEquals((int)0, (int)results.size());
    }

    @Test
    public void testMappedWorks() throws Exception {
        ColumnAnalysis columnAnalysis;
        List<SegmentAnalysis> results = this.getSegmentAnalysises((Segment)new QueryableIndexSegment("test_1", TestIndex.getMMappedTestIndex()));
        Assert.assertEquals((int)1, (int)results.size());
        SegmentAnalysis analysis = results.get(0);
        Assert.assertEquals((String)"test_1", (String)analysis.getId());
        Map columns = analysis.getColumns();
        Assert.assertEquals((int)TestIndex.COLUMNS.length, (int)columns.size());
        for (String dimension : TestIndex.DIMENSIONS) {
            columnAnalysis = (ColumnAnalysis)columns.get(dimension);
            Assert.assertEquals((String)dimension, (String)ValueType.STRING.name(), (String)columnAnalysis.getType());
            Assert.assertTrue((String)dimension, (columnAnalysis.getSize() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((String)dimension, (columnAnalysis.getCardinality() > 0 ? 1 : 0) != 0);
        }
        for (String metric : TestIndex.METRICS) {
            columnAnalysis = (ColumnAnalysis)columns.get(metric);
            Assert.assertEquals((String)metric, (String)ValueType.FLOAT.name(), (String)columnAnalysis.getType());
            Assert.assertTrue((String)metric, (columnAnalysis.getSize() > 0L ? 1 : 0) != 0);
            Assert.assertNull((String)metric, (Object)columnAnalysis.getCardinality());
        }
    }

    private List<SegmentAnalysis> getSegmentAnalysises(Segment index) {
        QueryRunner runner = QueryRunnerTestHelper.makeQueryRunner(new SegmentMetadataQueryRunnerFactory(new SegmentMetadataQueryQueryToolChest(), QueryRunnerTestHelper.NOOP_QUERYWATCHER), index);
        SegmentMetadataQuery query = new SegmentMetadataQuery((DataSource)new LegacyDataSource("test"), QuerySegmentSpecs.create((String)"2011/2012"), null, null, null);
        HashMap context = new HashMap();
        return Sequences.toList((Sequence)query.run(runner, context), (List)Lists.newArrayList());
    }
}

