/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby.having;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.druid.data.input.MapBasedInputRow;
import io.druid.data.input.Row;
import io.druid.jackson.DefaultObjectMapper;
import io.druid.query.groupby.having.AndHavingSpec;
import io.druid.query.groupby.having.EqualToHavingSpec;
import io.druid.query.groupby.having.GreaterThanHavingSpec;
import io.druid.query.groupby.having.HavingSpec;
import io.druid.query.groupby.having.LessThanHavingSpec;
import io.druid.query.groupby.having.NotHavingSpec;
import io.druid.query.groupby.having.OrHavingSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;

public class HavingSpecTest {
    private static final Row ROW = new MapBasedInputRow(0L, new ArrayList(), (Map)ImmutableMap.of((Object)"metric", (Object)Float.valueOf(10.0f)));

    @Test
    public void testHavingClauseSerde() throws Exception {
        List<HavingSpec> havings = Arrays.asList(new GreaterThanHavingSpec("agg", (Number)1.3), new OrHavingSpec(Arrays.asList(new LessThanHavingSpec("lessAgg", (Number)1L), new NotHavingSpec((HavingSpec)new EqualToHavingSpec("equalAgg", (Number)2.0)))));
        AndHavingSpec andHavingSpec = new AndHavingSpec(havings);
        ImmutableMap notMap = ImmutableMap.of((Object)"type", (Object)"not", (Object)"havingSpec", (Object)ImmutableMap.of((Object)"type", (Object)"equalTo", (Object)"aggregation", (Object)"equalAgg", (Object)"value", (Object)2.0));
        ImmutableMap lessMap = ImmutableMap.of((Object)"type", (Object)"lessThan", (Object)"aggregation", (Object)"lessAgg", (Object)"value", (Object)1);
        ImmutableMap greaterMap = ImmutableMap.of((Object)"type", (Object)"greaterThan", (Object)"aggregation", (Object)"agg", (Object)"value", (Object)1.3);
        ImmutableMap orMap = ImmutableMap.of((Object)"type", (Object)"or", (Object)"havingSpecs", (Object)ImmutableList.of((Object)lessMap, (Object)notMap));
        ImmutableMap payloadMap = ImmutableMap.of((Object)"type", (Object)"and", (Object)"havingSpecs", (Object)ImmutableList.of((Object)greaterMap, (Object)orMap));
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        Assert.assertEquals((Object)andHavingSpec, (Object)mapper.convertValue((Object)payloadMap, AndHavingSpec.class));
    }

    @Test
    public void testGreaterThanHavingSpec() {
        GreaterThanHavingSpec spec = new GreaterThanHavingSpec("metric", (Number)10.003);
        Assert.assertFalse((boolean)spec.eval(ROW));
        spec = new GreaterThanHavingSpec("metric", (Number)10);
        Assert.assertFalse((boolean)spec.eval(ROW));
        spec = new GreaterThanHavingSpec("metric", (Number)9);
        Assert.assertTrue((boolean)spec.eval(ROW));
    }

    private MapBasedInputRow makeRow(long ts, String dim, int value) {
        ArrayList dimensions = Lists.newArrayList((Object[])new String[]{dim});
        ImmutableMap metrics = ImmutableMap.of((Object)"metric", (Object)Float.valueOf(value));
        return new MapBasedInputRow(ts, (List)dimensions, (Map)metrics);
    }

    @Test
    public void testLessThanHavingSpec() {
        LessThanHavingSpec spec = new LessThanHavingSpec("metric", (Number)10);
        Assert.assertFalse((boolean)spec.eval(ROW));
        spec = new LessThanHavingSpec("metric", (Number)11);
        Assert.assertTrue((boolean)spec.eval(ROW));
        spec = new LessThanHavingSpec("metric", (Number)9);
        Assert.assertFalse((boolean)spec.eval(ROW));
    }

    @Test
    public void testEqualHavingSpec() {
        EqualToHavingSpec spec = new EqualToHavingSpec("metric", (Number)10);
        Assert.assertTrue((boolean)spec.eval(ROW));
        spec = new EqualToHavingSpec("metric", (Number)9);
        Assert.assertFalse((boolean)spec.eval(ROW));
        spec = new EqualToHavingSpec("metric", (Number)11);
        Assert.assertFalse((boolean)spec.eval(ROW));
    }

    @Test
    public void testAndHavingSpecShouldSupportShortcutEvaluation() {
        AtomicInteger counter = new AtomicInteger(0);
        AndHavingSpec spec = new AndHavingSpec((List)ImmutableList.of((Object)new CountingHavingSpec(counter, true), (Object)new CountingHavingSpec(counter, false), (Object)new CountingHavingSpec(counter, true), (Object)new CountingHavingSpec(counter, false)));
        spec.eval(ROW);
        Assert.assertEquals((long)2L, (long)counter.get());
    }

    @Test
    public void testAndHavingSpec() {
        AtomicInteger counter = new AtomicInteger(0);
        AndHavingSpec spec = new AndHavingSpec((List)ImmutableList.of((Object)new CountingHavingSpec(counter, true), (Object)new CountingHavingSpec(counter, true), (Object)new CountingHavingSpec(counter, true), (Object)new CountingHavingSpec(counter, true)));
        spec.eval(ROW);
        Assert.assertEquals((long)4L, (long)counter.get());
        counter.set(0);
        spec = new AndHavingSpec((List)ImmutableList.of((Object)new CountingHavingSpec(counter, false), (Object)new CountingHavingSpec(counter, true), (Object)new CountingHavingSpec(counter, true), (Object)new CountingHavingSpec(counter, true)));
        spec.eval(ROW);
        Assert.assertEquals((long)1L, (long)counter.get());
    }

    @Test
    public void testOrHavingSpecSupportsShortcutEvaluation() {
        AtomicInteger counter = new AtomicInteger(0);
        OrHavingSpec spec = new OrHavingSpec((List)ImmutableList.of((Object)new CountingHavingSpec(counter, true), (Object)new CountingHavingSpec(counter, true), (Object)new CountingHavingSpec(counter, true), (Object)new CountingHavingSpec(counter, false)));
        spec.eval(ROW);
        Assert.assertEquals((long)1L, (long)counter.get());
    }

    @Test
    public void testOrHavingSpec() {
        AtomicInteger counter = new AtomicInteger(0);
        OrHavingSpec spec = new OrHavingSpec((List)ImmutableList.of((Object)new CountingHavingSpec(counter, false), (Object)new CountingHavingSpec(counter, false), (Object)new CountingHavingSpec(counter, false), (Object)new CountingHavingSpec(counter, false)));
        spec.eval(ROW);
        Assert.assertEquals((long)4L, (long)counter.get());
        counter.set(0);
        spec = new OrHavingSpec((List)ImmutableList.of((Object)new CountingHavingSpec(counter, false), (Object)new CountingHavingSpec(counter, false), (Object)new CountingHavingSpec(counter, false), (Object)new CountingHavingSpec(counter, true)));
        spec.eval(ROW);
        Assert.assertEquals((long)4L, (long)counter.get());
    }

    @Test
    public void testNotHavingSepc() {
        NotHavingSpec spec = new NotHavingSpec(HavingSpec.NEVER);
        Assert.assertTrue((boolean)spec.eval(ROW));
        spec = new NotHavingSpec(HavingSpec.ALWAYS);
        Assert.assertFalse((boolean)spec.eval(ROW));
    }

    private static class CountingHavingSpec
    implements HavingSpec {
        private final AtomicInteger counter;
        private final boolean value;

        private CountingHavingSpec(AtomicInteger counter, boolean value) {
            this.counter = counter;
            this.value = value;
        }

        public boolean eval(Row row) {
            this.counter.incrementAndGet();
            return this.value;
        }

        public byte[] getCacheKey() {
            return new byte[0];
        }
    }
}

