/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import io.druid.collections.StupidPool;
import io.druid.data.input.MapBasedRow;
import io.druid.data.input.Row;
import io.druid.jackson.DefaultObjectMapper;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerFactory;
import io.druid.query.QueryRunnerTestHelper;
import io.druid.query.Result;
import io.druid.query.TestQueryRunners;
import io.druid.query.groupby.GroupByQuery;
import io.druid.query.groupby.GroupByQueryConfig;
import io.druid.query.groupby.GroupByQueryEngine;
import io.druid.query.groupby.GroupByQueryQueryToolChest;
import io.druid.query.groupby.GroupByQueryRunnerFactory;
import io.druid.query.timeseries.TimeseriesQuery;
import io.druid.query.timeseries.TimeseriesQueryRunnerTest;
import io.druid.query.timeseries.TimeseriesResultValue;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class GroupByTimeseriesQueryRunnerTest
extends TimeseriesQueryRunnerTest {
    @Parameterized.Parameters
    public static Collection<?> constructorFeeder() throws IOException {
        GroupByQueryConfig config = new GroupByQueryConfig();
        config.setMaxIntermediateRows(10000);
        Supplier configSupplier = Suppliers.ofInstance((Object)config);
        GroupByQueryEngine engine = new GroupByQueryEngine(configSupplier, new StupidPool((Supplier)new Supplier<ByteBuffer>(){

            public ByteBuffer get() {
                return ByteBuffer.allocate(0x100000);
            }
        }));
        GroupByQueryRunnerFactory factory = new GroupByQueryRunnerFactory(engine, QueryRunnerTestHelper.NOOP_QUERYWATCHER, configSupplier, new GroupByQueryQueryToolChest(configSupplier, (ObjectMapper)new DefaultObjectMapper(), engine, TestQueryRunners.pool, QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()), TestQueryRunners.pool);
        Collection<?> objects = QueryRunnerTestHelper.makeQueryRunners((QueryRunnerFactory)factory);
        Object[][] newObjects = new Object[objects.size()][];
        int i = 0;
        for (Object object : objects) {
            if (!(object instanceof Object[])) continue;
            Object[] queryRunnerArray = (Object[])object;
            Preconditions.checkState((queryRunnerArray.length == 1 ? 1 : 0) != 0);
            Preconditions.checkState((boolean)(queryRunnerArray[0] instanceof QueryRunner));
            final QueryRunner groupByRunner = (QueryRunner)queryRunnerArray[0];
            QueryRunner timeseriesRunner = new QueryRunner(){

                public Sequence run(Query query, Map responseContext) {
                    TimeseriesQuery tsQuery = (TimeseriesQuery)query;
                    return Sequences.map((Sequence)groupByRunner.run((Query)GroupByQuery.builder().setDataSource(tsQuery.getDataSource()).setQuerySegmentSpec(tsQuery.getQuerySegmentSpec()).setGranularity(tsQuery.getGranularity()).setDimFilter(tsQuery.getDimensionsFilter()).setAggregatorSpecs(tsQuery.getAggregatorSpecs()).setPostAggregatorSpecs(tsQuery.getPostAggregatorSpecs()).build(), responseContext), (Function)new Function<Row, Result<TimeseriesResultValue>>(){

                        public Result<TimeseriesResultValue> apply(Row input) {
                            MapBasedRow row = (MapBasedRow)input;
                            return new Result(row.getTimestamp(), (Object)new TimeseriesResultValue(row.getEvent()));
                        }
                    });
                }
            };
            newObjects[i] = new Object[]{timeseriesRunner};
            ++i;
        }
        return Arrays.asList(newObjects);
    }

    public GroupByTimeseriesQueryRunnerTest(QueryRunner runner) {
        super(runner);
    }

    @Override
    public void testFullOnTimeseries() {
    }

    @Override
    public void testFullOnTimeseriesWithFilter() {
    }

    @Override
    public void testTimeseriesQueryZeroFilling() {
    }

    @Override
    public void testTimeseriesWithNonExistentFilter() {
    }

    @Override
    public void testTimeseriesWithNonExistentFilterAndMultiDim() {
    }

    @Override
    public void testTimeseriesWithFilterOnNonExistentDimension() {
    }
}

