/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import io.druid.jackson.DefaultObjectMapper;
import io.druid.query.Query;
import io.druid.query.QueryRunnerTestHelper;
import io.druid.query.aggregation.LongSumAggregatorFactory;
import io.druid.query.dimension.DefaultDimensionSpec;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.groupby.GroupByQuery;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class GroupByQueryTest {
    private static final ObjectMapper jsonMapper = new DefaultObjectMapper();

    @Test
    public void testQuerySerialization() throws IOException {
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        String json = jsonMapper.writeValueAsString((Object)query);
        Query serdeQuery = (Query)jsonMapper.readValue(json, Query.class);
        Assert.assertEquals((Object)query, (Object)serdeQuery);
    }
}

