/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.extraction.extraction;

import com.google.common.collect.Sets;
import io.druid.jackson.DefaultObjectMapper;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.extraction.TimeDimExtractionFn;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;

public class TimeDimExtractionFnTest {
    private static final String[] dims = new String[]{"01/01/2012", "01/02/2012", "03/03/2012", "03/04/2012", "05/05/2012", "12/21/2012"};

    @Test
    public void testMonthExtraction() {
        HashSet months = Sets.newHashSet();
        TimeDimExtractionFn extractionFn = new TimeDimExtractionFn("MM/dd/yyyy", "MM/yyyy");
        for (String dim : dims) {
            months.add(extractionFn.apply(dim));
        }
        Assert.assertEquals((long)months.size(), (long)4L);
        Assert.assertTrue((boolean)months.contains("01/2012"));
        Assert.assertTrue((boolean)months.contains("03/2012"));
        Assert.assertTrue((boolean)months.contains("05/2012"));
        Assert.assertTrue((boolean)months.contains("12/2012"));
    }

    @Test
    public void testQuarterExtraction() {
        HashSet quarters = Sets.newHashSet();
        TimeDimExtractionFn extractionFn = new TimeDimExtractionFn("MM/dd/yyyy", "QQQ/yyyy");
        for (String dim : dims) {
            quarters.add(extractionFn.apply(dim));
        }
        Assert.assertEquals((long)quarters.size(), (long)3L);
        Assert.assertTrue((boolean)quarters.contains("Q1/2012"));
        Assert.assertTrue((boolean)quarters.contains("Q2/2012"));
        Assert.assertTrue((boolean)quarters.contains("Q4/2012"));
    }

    @Test
    public void testSerde() throws Exception {
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        String json = "{ \"type\" : \"time\", \"timeFormat\" : \"MM/dd/yyyy\", \"resultFormat\" : \"QQQ/yyyy\" }";
        TimeDimExtractionFn extractionFn = (TimeDimExtractionFn)objectMapper.readValue("{ \"type\" : \"time\", \"timeFormat\" : \"MM/dd/yyyy\", \"resultFormat\" : \"QQQ/yyyy\" }", ExtractionFn.class);
        Assert.assertEquals((Object)"MM/dd/yyyy", (Object)extractionFn.getTimeFormat());
        Assert.assertEquals((Object)"QQQ/yyyy", (Object)extractionFn.getResultFormat());
        Assert.assertEquals((Object)extractionFn, (Object)objectMapper.readValue(objectMapper.writeValueAsBytes((Object)extractionFn), ExtractionFn.class));
    }
}

