/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.extraction.extraction;

import com.google.common.collect.Sets;
import io.druid.query.extraction.SearchQuerySpecDimExtractionFn;
import io.druid.query.search.search.FragmentSearchQuerySpec;
import io.druid.query.search.search.SearchQuerySpec;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class SearchQuerySpecDimExtractionFnTest {
    private static final String[] testStrings = new String[]{"Kyoto", "Calgary", "Tokyo", "Stockholm", "Toyokawa", "Pretoria", "Yorktown", "Ontario"};

    @Test
    public void testExtraction() {
        FragmentSearchQuerySpec spec = new FragmentSearchQuerySpec(Arrays.asList("to", "yo"));
        SearchQuerySpecDimExtractionFn extractionFn = new SearchQuerySpecDimExtractionFn((SearchQuerySpec)spec);
        List<String> expected = Arrays.asList("Kyoto", "Tokyo", "Toyokawa", "Yorktown");
        HashSet extracted = Sets.newHashSet();
        for (String str : testStrings) {
            String res = extractionFn.apply(str);
            if (res == null) continue;
            extracted.add(res);
        }
        Assert.assertEquals((long)4L, (long)extracted.size());
        for (String str : extracted) {
            Assert.assertTrue((boolean)expected.contains(str));
        }
    }
}

