/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.cardinality;

import com.google.caliper.Param;
import com.google.caliper.Runner;
import com.google.caliper.SimpleBenchmark;
import com.google.common.base.Function;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import io.druid.query.aggregation.cardinality.CardinalityAggregatorFactory;
import io.druid.query.aggregation.cardinality.CardinalityAggregatorTest;
import io.druid.query.aggregation.cardinality.CardinalityBufferAggregator;
import io.druid.segment.DimensionSelector;
import java.nio.ByteBuffer;
import java.util.List;

public class CardinalityAggregatorBenchmark
extends SimpleBenchmark {
    private static final int MAX = 5000000;
    CardinalityBufferAggregator agg;
    List<DimensionSelector> selectorList;
    ByteBuffer buf;
    int pos;
    @Param(value={"1", "5"})
    int multivaluedSized;
    @Param(value={"true", "false"})
    boolean byRow;

    protected void setUp() {
        FluentIterable values = FluentIterable.from((Iterable)ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(500)), (DiscreteDomain)DiscreteDomain.integers())).transform((Function)new Function<Integer, String[]>(){

            public String[] apply(Integer input) {
                if (CardinalityAggregatorBenchmark.this.multivaluedSized == 1) {
                    return new String[]{input.toString()};
                }
                String[] res = new String[CardinalityAggregatorBenchmark.this.multivaluedSized];
                String value = input.toString();
                for (int i = 0; i < CardinalityAggregatorBenchmark.this.multivaluedSized; ++i) {
                    res[i] = value + i;
                }
                return res;
            }
        }).cycle().limit(5000000);
        CardinalityAggregatorTest.TestDimensionSelector dim1 = new CardinalityAggregatorTest.TestDimensionSelector((Iterable<String[]>)values);
        this.selectorList = Lists.newArrayList((Object[])new DimensionSelector[]{dim1});
        this.agg = new CardinalityBufferAggregator(this.selectorList, this.byRow);
        CardinalityAggregatorFactory factory = new CardinalityAggregatorFactory("billy", (List)Lists.newArrayList((Object[])new String[]{"dim1"}), this.byRow);
        int maxSize = factory.getMaxIntermediateSize();
        this.buf = ByteBuffer.allocate(maxSize + 64);
        this.pos = 10;
        this.buf.limit(this.pos + maxSize);
        this.agg.init(this.buf, this.pos);
    }

    public Object timeBufferAggregate(int reps) throws Exception {
        for (int i = 0; i < reps; ++i) {
            this.agg.aggregate(this.buf, this.pos);
            for (DimensionSelector selector : this.selectorList) {
                if (i % 4999999 == 0) {
                    ((CardinalityAggregatorTest.TestDimensionSelector)selector).reset();
                    continue;
                }
                ((CardinalityAggregatorTest.TestDimensionSelector)selector).increment();
            }
        }
        return this.agg.get(this.buf, this.pos);
    }

    protected void tearDown() {
    }

    public static void main(String[] args) throws Exception {
        Runner.main(CardinalityAggregatorBenchmark.class, (String[])args);
    }
}

