/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation;

import com.google.common.collect.Lists;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.DoubleSumAggregatorFactory;
import io.druid.query.aggregation.FilteredAggregator;
import io.druid.query.aggregation.FilteredAggregatorFactory;
import io.druid.query.aggregation.TestFloatColumnSelector;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.filter.AndDimFilter;
import io.druid.query.filter.DimFilter;
import io.druid.query.filter.NotDimFilter;
import io.druid.query.filter.OrDimFilter;
import io.druid.query.filter.SelectorDimFilter;
import io.druid.segment.ColumnSelectorFactory;
import io.druid.segment.DimensionSelector;
import io.druid.segment.FloatColumnSelector;
import io.druid.segment.LongColumnSelector;
import io.druid.segment.ObjectColumnSelector;
import io.druid.segment.data.ArrayBasedIndexedInts;
import io.druid.segment.data.IndexedInts;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class FilteredAggregatorTest {
    private void aggregate(TestFloatColumnSelector selector, FilteredAggregator agg) {
        agg.aggregate();
        selector.increment();
    }

    @Test
    public void testAggregate() {
        double expectedSecond;
        float[] values = new float[]{0.15f, 0.27f};
        TestFloatColumnSelector selector = new TestFloatColumnSelector(values);
        FilteredAggregatorFactory factory = new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("billy", "value"), (DimFilter)new SelectorDimFilter("dim", "a"));
        FilteredAggregator agg = (FilteredAggregator)factory.factorize(this.makeColumnSelector(selector));
        Assert.assertEquals((Object)"billy", (Object)agg.getName());
        double expectedFirst = new Float(values[0]).doubleValue();
        double expectedThird = expectedSecond = new Float(values[1]).doubleValue() + expectedFirst;
        this.assertValues(agg, selector, expectedFirst, expectedSecond, expectedThird);
    }

    private ColumnSelectorFactory makeColumnSelector(final TestFloatColumnSelector selector) {
        return new ColumnSelectorFactory(){

            public DimensionSelector makeDimensionSelector(String dimensionName, ExtractionFn extractionFn) {
                if (dimensionName.equals("dim")) {
                    return new DimensionSelector(){

                        public IndexedInts getRow() {
                            if (selector.getIndex() % 3 == 2) {
                                return new ArrayBasedIndexedInts(new int[]{1});
                            }
                            return new ArrayBasedIndexedInts(new int[]{0});
                        }

                        public int getValueCardinality() {
                            return 2;
                        }

                        public String lookupName(int id) {
                            switch (id) {
                                case 0: {
                                    return "a";
                                }
                                case 1: {
                                    return "b";
                                }
                            }
                            throw new IllegalArgumentException();
                        }

                        public int lookupId(String name) {
                            switch (name) {
                                case "a": {
                                    return 0;
                                }
                                case "b": {
                                    return 1;
                                }
                            }
                            throw new IllegalArgumentException();
                        }
                    };
                }
                throw new UnsupportedOperationException();
            }

            public LongColumnSelector makeLongColumnSelector(String columnName) {
                throw new UnsupportedOperationException();
            }

            public FloatColumnSelector makeFloatColumnSelector(String columnName) {
                if (columnName.equals("value")) {
                    return selector;
                }
                throw new UnsupportedOperationException();
            }

            public ObjectColumnSelector makeObjectColumnSelector(String columnName) {
                throw new UnsupportedOperationException();
            }
        };
    }

    private void assertValues(FilteredAggregator agg, TestFloatColumnSelector selector, double ... expectedVals) {
        Assert.assertEquals((Object)0.0, (Object)agg.get());
        Assert.assertEquals((Object)0.0, (Object)agg.get());
        Assert.assertEquals((Object)0.0, (Object)agg.get());
        for (double expectedVal : expectedVals) {
            this.aggregate(selector, agg);
            Assert.assertEquals((Object)expectedVal, (Object)agg.get());
            Assert.assertEquals((Object)expectedVal, (Object)agg.get());
            Assert.assertEquals((Object)expectedVal, (Object)agg.get());
        }
    }

    @Test
    public void testAggregateWithNotFilter() {
        double expectedSecond;
        float[] values = new float[]{0.15f, 0.27f};
        TestFloatColumnSelector selector = new TestFloatColumnSelector(values);
        FilteredAggregatorFactory factory = new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("billy", "value"), (DimFilter)new NotDimFilter((DimFilter)new SelectorDimFilter("dim", "b")));
        FilteredAggregator agg = (FilteredAggregator)factory.factorize(this.makeColumnSelector(selector));
        Assert.assertEquals((Object)"billy", (Object)agg.getName());
        double expectedFirst = new Float(values[0]).doubleValue();
        double expectedThird = expectedSecond = new Float(values[1]).doubleValue() + expectedFirst;
        this.assertValues(agg, selector, expectedFirst, expectedSecond, expectedThird);
    }

    @Test
    public void testAggregateWithOrFilter() {
        float[] values = new float[]{0.15f, 0.27f, 0.14f};
        TestFloatColumnSelector selector = new TestFloatColumnSelector(values);
        FilteredAggregatorFactory factory = new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("billy", "value"), (DimFilter)new OrDimFilter((List)Lists.newArrayList((Object[])new DimFilter[]{new SelectorDimFilter("dim", "a"), new SelectorDimFilter("dim", "b")})));
        FilteredAggregator agg = (FilteredAggregator)factory.factorize(this.makeColumnSelector(selector));
        Assert.assertEquals((Object)"billy", (Object)agg.getName());
        double expectedFirst = new Float(values[0]).doubleValue();
        double expectedSecond = new Float(values[1]).doubleValue() + expectedFirst;
        double expectedThird = expectedSecond + new Float(values[2]).doubleValue();
        this.assertValues(agg, selector, expectedFirst, expectedSecond, expectedThird);
    }

    @Test
    public void testAggregateWithAndFilter() {
        double expectedSecond;
        float[] values = new float[]{0.15f, 0.27f};
        TestFloatColumnSelector selector = new TestFloatColumnSelector(values);
        FilteredAggregatorFactory factory = new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("billy", "value"), (DimFilter)new AndDimFilter((List)Lists.newArrayList((Object[])new DimFilter[]{new NotDimFilter((DimFilter)new SelectorDimFilter("dim", "b")), new SelectorDimFilter("dim", "a")})));
        FilteredAggregator agg = (FilteredAggregator)factory.factorize(this.makeColumnSelector(selector));
        Assert.assertEquals((Object)"billy", (Object)agg.getName());
        double expectedFirst = new Float(values[0]).doubleValue();
        double expectedThird = expectedSecond = new Float(values[1]).doubleValue() + expectedFirst;
        this.assertValues(agg, selector, expectedFirst, expectedSecond, expectedThird);
    }
}

