/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import io.druid.granularity.QueryGranularity;
import io.druid.query.Result;
import io.druid.query.ResultGranularTimestampComparator;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;

public class ResultGranularTimestampComparatorTest {
    private final DateTime time = new DateTime((Object)"2011-11-11");

    @Test
    public void testCompareAll() {
        Result r1 = new Result(this.time, null);
        Result r2 = new Result(this.time.plusYears(5), null);
        Assert.assertEquals((long)new ResultGranularTimestampComparator(QueryGranularity.ALL).compare(r1, r2), (long)0L);
    }

    @Test
    public void testCompareDay() {
        Result res = new Result(this.time, null);
        Result same = new Result(this.time.plusHours(12), null);
        Result greater = new Result(this.time.plusHours(25), null);
        Result less = new Result(this.time.minusHours(1), null);
        QueryGranularity day = QueryGranularity.DAY;
        Assert.assertEquals((long)new ResultGranularTimestampComparator(day).compare(res, same), (long)0L);
        Assert.assertEquals((long)new ResultGranularTimestampComparator(day).compare(res, greater), (long)-1L);
        Assert.assertEquals((long)new ResultGranularTimestampComparator(day).compare(res, less), (long)1L);
    }

    @Test
    public void testCompareHour() {
        Result res = new Result(this.time, null);
        Result same = new Result(this.time.plusMinutes(55), null);
        Result greater = new Result(this.time.plusHours(1), null);
        Result less = new Result(this.time.minusHours(1), null);
        QueryGranularity hour = QueryGranularity.HOUR;
        Assert.assertEquals((long)new ResultGranularTimestampComparator(hour).compare(res, same), (long)0L);
        Assert.assertEquals((long)new ResultGranularTimestampComparator(hour).compare(res, greater), (long)-1L);
        Assert.assertEquals((long)new ResultGranularTimestampComparator(hour).compare(res, less), (long)1L);
    }
}

