/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import com.metamx.common.concurrent.ExecutorServiceConfig;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import com.metamx.common.lifecycle.Lifecycle;
import io.druid.query.ChainedExecutionQueryRunner;
import io.druid.query.Druids;
import io.druid.query.PrioritizedExecutorService;
import io.druid.query.Query;
import io.druid.query.QueryInterruptedException;
import io.druid.query.QueryRunner;
import io.druid.query.QueryWatcher;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.CountAggregatorFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ChainedExecutionQueryRunnerTest {
    private final Lock neverRelease = new ReentrantLock();

    @Before
    public void setup() {
        this.neverRelease.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testQueryCancellation() throws Exception {
        DyingQueryRunner remainingRunner;
        DyingQueryRunner interrupted2;
        DyingQueryRunner interrupted1;
        PrioritizedExecutorService exec = PrioritizedExecutorService.create((Lifecycle)new Lifecycle(), (ExecutorServiceConfig)new ExecutorServiceConfig(){

            public String getFormatString() {
                return "test";
            }

            public int getNumThreads() {
                return 2;
            }
        });
        CountDownLatch queriesStarted = new CountDownLatch(2);
        CountDownLatch queriesInterrupted = new CountDownLatch(2);
        final CountDownLatch queryIsRegistered = new CountDownLatch(1);
        Capture capturedFuture = EasyMock.newCapture();
        QueryWatcher watcher = (QueryWatcher)EasyMock.createStrictMock(QueryWatcher.class);
        watcher.registerQuery((Query)EasyMock.anyObject(), (ListenableFuture)EasyMock.and((Object)EasyMock.anyObject(), (Object)EasyMock.capture((Capture)capturedFuture)));
        EasyMock.expectLastCall().andAnswer((IAnswer)new IAnswer<Void>(){

            public Void answer() throws Throwable {
                queryIsRegistered.countDown();
                return null;
            }
        }).once();
        EasyMock.replay((Object[])new Object[]{watcher});
        ArrayBlockingQueue<DyingQueryRunner> interrupted = new ArrayBlockingQueue<DyingQueryRunner>(3);
        HashSet runners = Sets.newHashSet((Object[])new DyingQueryRunner[]{new DyingQueryRunner(queriesStarted, queriesInterrupted, interrupted), new DyingQueryRunner(queriesStarted, queriesInterrupted, interrupted), new DyingQueryRunner(queriesStarted, queriesInterrupted, interrupted)});
        ChainedExecutionQueryRunner chainedRunner = new ChainedExecutionQueryRunner((ExecutorService)exec, Ordering.natural(), watcher, (Iterable)Lists.newArrayList((Iterable)runners));
        ImmutableMap context = ImmutableMap.of();
        final Sequence seq = chainedRunner.run((Query)Druids.newTimeseriesQueryBuilder().dataSource("test").intervals("2014/2015").aggregators((List)Lists.newArrayList((Object[])new AggregatorFactory[]{new CountAggregatorFactory("count")})).build(), (Map)context);
        Future<?> resultFuture = Executors.newFixedThreadPool(1).submit(new Runnable(){

            @Override
            public void run() {
                Sequences.toList((Sequence)seq, (List)Lists.newArrayList());
            }
        });
        queryIsRegistered.await();
        queriesStarted.await();
        Assert.assertTrue((boolean)capturedFuture.hasCaptured());
        ListenableFuture future = (ListenableFuture)capturedFuture.getValue();
        future.cancel(true);
        QueryInterruptedException cause = null;
        try {
            resultFuture.get();
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof QueryInterruptedException));
            cause = (QueryInterruptedException)e.getCause();
        }
        queriesInterrupted.await();
        Assert.assertNotNull(cause);
        Assert.assertTrue((boolean)future.isCancelled());
        DyingQueryRunner dyingQueryRunner = interrupted1 = interrupted.poll();
        synchronized (dyingQueryRunner) {
            Assert.assertTrue((String)"runner 1 started", (boolean)interrupted1.hasStarted);
            Assert.assertTrue((String)"runner 1 interrupted", (boolean)interrupted1.interrupted);
        }
        DyingQueryRunner dyingQueryRunner2 = interrupted2 = interrupted.poll();
        synchronized (dyingQueryRunner2) {
            Assert.assertTrue((String)"runner 2 started", (boolean)interrupted2.hasStarted);
            Assert.assertTrue((String)"runner 2 interrupted", (boolean)interrupted2.interrupted);
        }
        runners.remove(interrupted1);
        runners.remove(interrupted2);
        DyingQueryRunner dyingQueryRunner3 = remainingRunner = (DyingQueryRunner)runners.iterator().next();
        synchronized (dyingQueryRunner3) {
            Assert.assertTrue((String)"runner 3 should be interrupted or not have started", (!remainingRunner.hasStarted || remainingRunner.interrupted ? 1 : 0) != 0);
        }
        Assert.assertFalse((String)"runner 1 not completed", (boolean)interrupted1.hasCompleted);
        Assert.assertFalse((String)"runner 2 not completed", (boolean)interrupted2.hasCompleted);
        Assert.assertFalse((String)"runner 3 not completed", (boolean)remainingRunner.hasCompleted);
        EasyMock.verify((Object[])new Object[]{watcher});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testQueryTimeout() throws Exception {
        DyingQueryRunner remainingRunner;
        DyingQueryRunner interrupted2;
        DyingQueryRunner interrupted1;
        PrioritizedExecutorService exec = PrioritizedExecutorService.create((Lifecycle)new Lifecycle(), (ExecutorServiceConfig)new ExecutorServiceConfig(){

            public String getFormatString() {
                return "test";
            }

            public int getNumThreads() {
                return 2;
            }
        });
        CountDownLatch queriesStarted = new CountDownLatch(2);
        CountDownLatch queriesInterrupted = new CountDownLatch(2);
        final CountDownLatch queryIsRegistered = new CountDownLatch(1);
        Capture capturedFuture = new Capture();
        QueryWatcher watcher = (QueryWatcher)EasyMock.createStrictMock(QueryWatcher.class);
        watcher.registerQuery((Query)EasyMock.anyObject(), (ListenableFuture)EasyMock.and((Object)EasyMock.anyObject(), (Object)EasyMock.capture((Capture)capturedFuture)));
        EasyMock.expectLastCall().andAnswer((IAnswer)new IAnswer<Void>(){

            public Void answer() throws Throwable {
                queryIsRegistered.countDown();
                return null;
            }
        }).once();
        EasyMock.replay((Object[])new Object[]{watcher});
        ArrayBlockingQueue<DyingQueryRunner> interrupted = new ArrayBlockingQueue<DyingQueryRunner>(3);
        HashSet runners = Sets.newHashSet((Object[])new DyingQueryRunner[]{new DyingQueryRunner(queriesStarted, queriesInterrupted, interrupted), new DyingQueryRunner(queriesStarted, queriesInterrupted, interrupted), new DyingQueryRunner(queriesStarted, queriesInterrupted, interrupted)});
        ChainedExecutionQueryRunner chainedRunner = new ChainedExecutionQueryRunner((ExecutorService)exec, Ordering.natural(), watcher, (Iterable)Lists.newArrayList((Iterable)runners));
        HashMap context = new HashMap();
        final Sequence seq = chainedRunner.run((Query)Druids.newTimeseriesQueryBuilder().dataSource("test").intervals("2014/2015").aggregators((List)Lists.newArrayList((Object[])new AggregatorFactory[]{new CountAggregatorFactory("count")})).context((Map)ImmutableMap.of((Object)"timeout", (Object)100, (Object)"queryId", (Object)"test")).build(), context);
        Future<?> resultFuture = Executors.newFixedThreadPool(1).submit(new Runnable(){

            @Override
            public void run() {
                Sequences.toList((Sequence)seq, (List)Lists.newArrayList());
            }
        });
        queryIsRegistered.await();
        queriesStarted.await();
        Assert.assertTrue((boolean)capturedFuture.hasCaptured());
        ListenableFuture future = (ListenableFuture)capturedFuture.getValue();
        QueryInterruptedException cause = null;
        try {
            resultFuture.get();
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof QueryInterruptedException));
            Assert.assertEquals((Object)"Query timeout", (Object)e.getCause().getMessage());
            cause = (QueryInterruptedException)e.getCause();
        }
        queriesInterrupted.await();
        Assert.assertNotNull(cause);
        Assert.assertTrue((boolean)future.isCancelled());
        DyingQueryRunner dyingQueryRunner = interrupted1 = interrupted.poll();
        synchronized (dyingQueryRunner) {
            Assert.assertTrue((String)"runner 1 started", (boolean)interrupted1.hasStarted);
            Assert.assertTrue((String)"runner 1 interrupted", (boolean)interrupted1.interrupted);
        }
        DyingQueryRunner dyingQueryRunner2 = interrupted2 = interrupted.poll();
        synchronized (dyingQueryRunner2) {
            Assert.assertTrue((String)"runner 2 started", (boolean)interrupted2.hasStarted);
            Assert.assertTrue((String)"runner 2 interrupted", (boolean)interrupted2.interrupted);
        }
        runners.remove(interrupted1);
        runners.remove(interrupted2);
        DyingQueryRunner dyingQueryRunner3 = remainingRunner = (DyingQueryRunner)runners.iterator().next();
        synchronized (dyingQueryRunner3) {
            Assert.assertTrue((String)"runner 3 should be interrupted or not have started", (!remainingRunner.hasStarted || remainingRunner.interrupted ? 1 : 0) != 0);
        }
        Assert.assertFalse((String)"runner 1 not completed", (boolean)interrupted1.hasCompleted);
        Assert.assertFalse((String)"runner 2 not completed", (boolean)interrupted2.hasCompleted);
        Assert.assertFalse((String)"runner 3 not completed", (boolean)remainingRunner.hasCompleted);
        EasyMock.verify((Object[])new Object[]{watcher});
    }

    private class DyingQueryRunner
    implements QueryRunner<Integer> {
        private final CountDownLatch start;
        private final CountDownLatch stop;
        private final Queue<DyingQueryRunner> interruptedRunners;
        private volatile boolean hasStarted = false;
        private volatile boolean hasCompleted = false;
        private volatile boolean interrupted = false;

        public DyingQueryRunner(CountDownLatch start, CountDownLatch stop, Queue<DyingQueryRunner> interruptedRunners) {
            this.start = start;
            this.stop = stop;
            this.interruptedRunners = interruptedRunners;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Sequence<Integer> run(Query<Integer> query, Map<String, Object> responseContext) {
            DyingQueryRunner dyingQueryRunner = this;
            synchronized (dyingQueryRunner) {
                try {
                    this.hasStarted = true;
                    this.start.countDown();
                    ChainedExecutionQueryRunnerTest.this.neverRelease.lockInterruptibly();
                }
                catch (InterruptedException e) {
                    this.interrupted = true;
                    this.interruptedRunners.offer(this);
                    this.stop.countDown();
                    throw new QueryInterruptedException("I got killed");
                }
            }
            this.hasCompleted = true;
            this.stop.countDown();
            return Sequences.simple((Iterable)Lists.newArrayList((Object[])new Integer[]{123}));
        }
    }
}

