/*
 * Decompiled with CFR 0.152.
 */
package io.druid.data.input;

import io.druid.data.input.InputRow;
import io.druid.data.input.ProtoBufInputRowParser;
import io.druid.data.input.ProtoTestEventWrapper;
import io.druid.data.input.impl.DimensionsSpec;
import io.druid.data.input.impl.JSONParseSpec;
import io.druid.data.input.impl.ParseSpec;
import io.druid.data.input.impl.TimestampSpec;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;

public class ProtoBufInputRowParserTest {
    public static final String[] DIMENSIONS = new String[]{"eventType", "id", "someOtherId", "isValid"};

    @Test
    public void testParse() throws Exception {
        ProtoBufInputRowParser parser = new ProtoBufInputRowParser((ParseSpec)new JSONParseSpec(new TimestampSpec("timestamp", "iso"), new DimensionsSpec(Arrays.asList(DIMENSIONS), Arrays.asList(new String[0]), null)), "prototest.desc");
        DateTime dateTime = new DateTime(2012, 7, 12, 9, 30);
        ProtoTestEventWrapper.ProtoTestEvent event = ProtoTestEventWrapper.ProtoTestEvent.newBuilder().setDescription("description").setEventType(ProtoTestEventWrapper.ProtoTestEvent.EventCategory.CATEGORY_ONE).setId(4711L).setIsValid(true).setSomeOtherId(4712).setTimestamp(dateTime.toString()).setSomeFloatColumn(47.11f).setSomeIntColumn(815).setSomeLongColumn(816L).build();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        event.writeTo(out);
        InputRow row = parser.parse(ByteBuffer.wrap(out.toByteArray()));
        System.out.println(row);
        Arrays.sort(DIMENSIONS);
        Assert.assertEquals(Arrays.asList(DIMENSIONS), (Object)row.getDimensions());
        Assert.assertEquals((long)dateTime.getMillis(), (long)row.getTimestampFromEpoch());
        this.assertDimensionEquals(row, "id", "4711");
        this.assertDimensionEquals(row, "isValid", "true");
        this.assertDimensionEquals(row, "someOtherId", "4712");
        this.assertDimensionEquals(row, "description", "description");
        this.assertDimensionEquals(row, "eventType", ProtoTestEventWrapper.ProtoTestEvent.EventCategory.CATEGORY_ONE.name());
        Assert.assertEquals((double)47.11f, (double)row.getFloatMetric("someFloatColumn"), (double)0.0);
        Assert.assertEquals((double)815.0, (double)row.getFloatMetric("someIntColumn"), (double)0.0);
        Assert.assertEquals((double)816.0, (double)row.getFloatMetric("someLongColumn"), (double)0.0);
    }

    private void assertDimensionEquals(InputRow row, String dimension, Object expected) {
        List values = row.getDimension(dimension);
        Assert.assertEquals((long)1L, (long)values.size());
        Assert.assertEquals((Object)expected, values.get(0));
    }
}

