/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.virtual;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.druid.data.input.InputRow;
import io.druid.data.input.MapBasedInputRow;
import io.druid.data.input.Row;
import io.druid.java.util.common.DateTimes;
import io.druid.query.dimension.DefaultDimensionSpec;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.dimension.ExtractionDimensionSpec;
import io.druid.query.expression.TestExprMacroTable;
import io.druid.query.extraction.BucketExtractionFn;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.filter.ValueMatcher;
import io.druid.query.groupby.RowBasedColumnSelectorFactory;
import io.druid.segment.ColumnSelectorFactory;
import io.druid.segment.ColumnValueSelector;
import io.druid.segment.DimensionSelector;
import io.druid.segment.column.ValueType;
import io.druid.segment.virtual.ExpressionVirtualColumn;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class ExpressionVirtualColumnTest {
    private static final InputRow ROW0 = new MapBasedInputRow(DateTimes.of((String)"2000-01-01T00:00:00").getMillis(), (List)ImmutableList.of(), (Map)ImmutableMap.of());
    private static final InputRow ROW1 = new MapBasedInputRow(DateTimes.of((String)"2000-01-01T00:00:00").getMillis(), (List)ImmutableList.of(), (Map)ImmutableMap.of((Object)"x", (Object)4));
    private static final InputRow ROW2 = new MapBasedInputRow(DateTimes.of((String)"2000-01-01T02:00:00").getMillis(), (List)ImmutableList.of(), (Map)ImmutableMap.of((Object)"x", (Object)2.1, (Object)"y", (Object)3L, (Object)"z", (Object)"foobar"));
    private static final InputRow ROW3 = new MapBasedInputRow(DateTimes.of((String)"2000-01-02T01:00:00").getMillis(), (List)ImmutableList.of(), (Map)ImmutableMap.of((Object)"x", (Object)2L, (Object)"y", (Object)3L, (Object)"z", (Object)"foobar"));
    private static final ExpressionVirtualColumn XPLUSY = new ExpressionVirtualColumn("expr", "x + y", ValueType.FLOAT, TestExprMacroTable.INSTANCE);
    private static final ExpressionVirtualColumn CONSTANT_LIKE = new ExpressionVirtualColumn("expr", "like('foo', 'f%')", ValueType.FLOAT, TestExprMacroTable.INSTANCE);
    private static final ExpressionVirtualColumn ZLIKE = new ExpressionVirtualColumn("expr", "like(z, 'f%')", ValueType.FLOAT, TestExprMacroTable.INSTANCE);
    private static final ExpressionVirtualColumn ZCONCATX = new ExpressionVirtualColumn("expr", "z + cast(x, 'string')", ValueType.STRING, TestExprMacroTable.INSTANCE);
    private static final ExpressionVirtualColumn TIMEFLOOR = new ExpressionVirtualColumn("expr", "timestamp_floor(__time, 'P1D')", ValueType.LONG, TestExprMacroTable.INSTANCE);
    private static final ThreadLocal<Row> CURRENT_ROW = new ThreadLocal();
    private static final ColumnSelectorFactory COLUMN_SELECTOR_FACTORY = RowBasedColumnSelectorFactory.create(CURRENT_ROW, null);

    @Test
    public void testObjectSelector() {
        ColumnValueSelector selector = XPLUSY.makeColumnValueSelector("expr", COLUMN_SELECTOR_FACTORY);
        CURRENT_ROW.set((Row)ROW0);
        Assert.assertEquals(null, (Object)selector.getObject());
        CURRENT_ROW.set((Row)ROW1);
        Assert.assertEquals((Object)4.0, (Object)selector.getObject());
        CURRENT_ROW.set((Row)ROW2);
        Assert.assertEquals((Object)5.1, (Object)selector.getObject());
        CURRENT_ROW.set((Row)ROW3);
        Assert.assertEquals((Object)5L, (Object)selector.getObject());
    }

    @Test
    public void testLongSelector() {
        ColumnValueSelector selector = XPLUSY.makeColumnValueSelector("expr", COLUMN_SELECTOR_FACTORY);
        CURRENT_ROW.set((Row)ROW0);
        Assert.assertEquals((long)0L, (long)selector.getLong());
        CURRENT_ROW.set((Row)ROW1);
        Assert.assertEquals((long)4L, (long)selector.getLong());
        CURRENT_ROW.set((Row)ROW2);
        Assert.assertEquals((long)5L, (long)selector.getLong());
        CURRENT_ROW.set((Row)ROW3);
        Assert.assertEquals((long)5L, (long)selector.getLong());
    }

    @Test
    public void testLongSelectorUsingStringFunction() {
        ColumnValueSelector selector = ZCONCATX.makeColumnValueSelector("expr", COLUMN_SELECTOR_FACTORY);
        CURRENT_ROW.set((Row)ROW0);
        Assert.assertEquals((long)0L, (long)selector.getLong());
        CURRENT_ROW.set((Row)ROW1);
        Assert.assertEquals((long)4L, (long)selector.getLong());
        CURRENT_ROW.set((Row)ROW2);
        Assert.assertEquals((long)0L, (long)selector.getLong());
        CURRENT_ROW.set((Row)ROW3);
        Assert.assertEquals((long)0L, (long)selector.getLong());
    }

    @Test
    public void testFloatSelector() {
        ColumnValueSelector selector = XPLUSY.makeColumnValueSelector("expr", COLUMN_SELECTOR_FACTORY);
        CURRENT_ROW.set((Row)ROW0);
        Assert.assertEquals((float)0.0f, (float)selector.getFloat(), (float)0.0f);
        CURRENT_ROW.set((Row)ROW1);
        Assert.assertEquals((float)4.0f, (float)selector.getFloat(), (float)0.0f);
        CURRENT_ROW.set((Row)ROW2);
        Assert.assertEquals((float)5.1f, (float)selector.getFloat(), (float)0.0f);
        CURRENT_ROW.set((Row)ROW3);
        Assert.assertEquals((float)5.0f, (float)selector.getFloat(), (float)0.0f);
    }

    @Test
    public void testDimensionSelector() {
        DimensionSelector selector = XPLUSY.makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec("expr", "expr"), COLUMN_SELECTOR_FACTORY);
        ValueMatcher nullMatcher = selector.makeValueMatcher((String)null);
        ValueMatcher fiveMatcher = selector.makeValueMatcher("5");
        ValueMatcher nonNullMatcher = selector.makeValueMatcher(Predicates.notNull());
        CURRENT_ROW.set((Row)ROW0);
        Assert.assertEquals((Object)true, (Object)nullMatcher.matches());
        Assert.assertEquals((Object)false, (Object)fiveMatcher.matches());
        Assert.assertEquals((Object)false, (Object)nonNullMatcher.matches());
        Assert.assertEquals(null, (Object)selector.lookupName(selector.getRow().get(0)));
        CURRENT_ROW.set((Row)ROW1);
        Assert.assertEquals((Object)false, (Object)nullMatcher.matches());
        Assert.assertEquals((Object)false, (Object)fiveMatcher.matches());
        Assert.assertEquals((Object)true, (Object)nonNullMatcher.matches());
        Assert.assertEquals((Object)"4.0", (Object)selector.lookupName(selector.getRow().get(0)));
        CURRENT_ROW.set((Row)ROW2);
        Assert.assertEquals((Object)false, (Object)nullMatcher.matches());
        Assert.assertEquals((Object)false, (Object)fiveMatcher.matches());
        Assert.assertEquals((Object)true, (Object)nonNullMatcher.matches());
        Assert.assertEquals((Object)"5.1", (Object)selector.lookupName(selector.getRow().get(0)));
        CURRENT_ROW.set((Row)ROW3);
        Assert.assertEquals((Object)false, (Object)nullMatcher.matches());
        Assert.assertEquals((Object)true, (Object)fiveMatcher.matches());
        Assert.assertEquals((Object)true, (Object)nonNullMatcher.matches());
        Assert.assertEquals((Object)"5", (Object)selector.lookupName(selector.getRow().get(0)));
    }

    @Test
    public void testDimensionSelectorUsingStringFunction() {
        DimensionSelector selector = ZCONCATX.makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec("expr", "expr"), COLUMN_SELECTOR_FACTORY);
        Assert.assertNotNull((Object)selector);
        CURRENT_ROW.set((Row)ROW0);
        Assert.assertEquals((long)1L, (long)selector.getRow().size());
        Assert.assertEquals(null, (Object)selector.lookupName(selector.getRow().get(0)));
        CURRENT_ROW.set((Row)ROW1);
        Assert.assertEquals((long)1L, (long)selector.getRow().size());
        Assert.assertEquals((Object)"4", (Object)selector.lookupName(selector.getRow().get(0)));
        CURRENT_ROW.set((Row)ROW2);
        Assert.assertEquals((long)1L, (long)selector.getRow().size());
        Assert.assertEquals((Object)"foobar2.1", (Object)selector.lookupName(selector.getRow().get(0)));
        CURRENT_ROW.set((Row)ROW3);
        Assert.assertEquals((long)1L, (long)selector.getRow().size());
        Assert.assertEquals((Object)"foobar2", (Object)selector.lookupName(selector.getRow().get(0)));
    }

    @Test
    public void testDimensionSelectorWithExtraction() {
        DimensionSelector selector = XPLUSY.makeDimensionSelector((DimensionSpec)new ExtractionDimensionSpec("expr", "x", (ExtractionFn)new BucketExtractionFn(Double.valueOf(1.0), Double.valueOf(0.0))), COLUMN_SELECTOR_FACTORY);
        ValueMatcher nullMatcher = selector.makeValueMatcher((String)null);
        ValueMatcher fiveMatcher = selector.makeValueMatcher("5");
        ValueMatcher nonNullMatcher = selector.makeValueMatcher(Predicates.notNull());
        CURRENT_ROW.set((Row)ROW0);
        Assert.assertEquals((Object)true, (Object)nullMatcher.matches());
        Assert.assertEquals((Object)false, (Object)fiveMatcher.matches());
        Assert.assertEquals((Object)false, (Object)nonNullMatcher.matches());
        Assert.assertEquals(null, (Object)selector.lookupName(selector.getRow().get(0)));
        CURRENT_ROW.set((Row)ROW1);
        Assert.assertEquals((Object)false, (Object)nullMatcher.matches());
        Assert.assertEquals((Object)false, (Object)fiveMatcher.matches());
        Assert.assertEquals((Object)true, (Object)nonNullMatcher.matches());
        Assert.assertEquals((Object)"4", (Object)selector.lookupName(selector.getRow().get(0)));
        CURRENT_ROW.set((Row)ROW2);
        Assert.assertEquals((Object)false, (Object)nullMatcher.matches());
        Assert.assertEquals((Object)true, (Object)fiveMatcher.matches());
        Assert.assertEquals((Object)true, (Object)nonNullMatcher.matches());
        Assert.assertEquals((Object)"5", (Object)selector.lookupName(selector.getRow().get(0)));
        CURRENT_ROW.set((Row)ROW3);
        Assert.assertEquals((Object)false, (Object)nullMatcher.matches());
        Assert.assertEquals((Object)true, (Object)fiveMatcher.matches());
        Assert.assertEquals((Object)true, (Object)nonNullMatcher.matches());
        Assert.assertEquals((Object)"5", (Object)selector.lookupName(selector.getRow().get(0)));
    }

    @Test
    public void testLongSelectorWithConstantLikeExprMacro() {
        ColumnValueSelector selector = CONSTANT_LIKE.makeColumnValueSelector("expr", COLUMN_SELECTOR_FACTORY);
        CURRENT_ROW.set((Row)ROW0);
        Assert.assertEquals((long)1L, (long)selector.getLong());
    }

    @Test
    public void testLongSelectorWithZLikeExprMacro() {
        ColumnValueSelector selector = ZLIKE.makeColumnValueSelector("expr", COLUMN_SELECTOR_FACTORY);
        CURRENT_ROW.set((Row)ROW0);
        Assert.assertEquals((long)0L, (long)selector.getLong());
        CURRENT_ROW.set((Row)ROW1);
        Assert.assertEquals((long)0L, (long)selector.getLong());
        CURRENT_ROW.set((Row)ROW2);
        Assert.assertEquals((long)1L, (long)selector.getLong());
        CURRENT_ROW.set((Row)ROW3);
        Assert.assertEquals((long)1L, (long)selector.getLong());
    }

    @Test
    public void testLongSelectorOfTimeColumn() {
        ColumnValueSelector selector = TIMEFLOOR.makeColumnValueSelector("expr", COLUMN_SELECTOR_FACTORY);
        CURRENT_ROW.set((Row)ROW0);
        Assert.assertEquals((long)DateTimes.of((String)"2000-01-01").getMillis(), (long)selector.getLong());
        Assert.assertEquals((float)DateTimes.of((String)"2000-01-01").getMillis(), (float)selector.getFloat(), (float)0.0f);
        Assert.assertEquals((double)DateTimes.of((String)"2000-01-01").getMillis(), (double)selector.getDouble(), (double)0.0);
        Assert.assertEquals((Object)DateTimes.of((String)"2000-01-01").getMillis(), (Object)selector.getObject());
        CURRENT_ROW.set((Row)ROW1);
        Assert.assertEquals((long)DateTimes.of((String)"2000-01-01").getMillis(), (long)selector.getLong());
        CURRENT_ROW.set((Row)ROW2);
        Assert.assertEquals((long)DateTimes.of((String)"2000-01-01").getMillis(), (long)selector.getLong());
        CURRENT_ROW.set((Row)ROW3);
        Assert.assertEquals((long)DateTimes.of((String)"2000-01-02").getMillis(), (long)selector.getLong());
        Assert.assertEquals((double)DateTimes.of((String)"2000-01-02").getMillis(), (double)selector.getDouble(), (double)0.0);
    }

    @Test
    public void testRequiredColumns() {
        Assert.assertEquals((Object)ImmutableList.of((Object)"x", (Object)"y"), (Object)XPLUSY.requiredColumns());
        Assert.assertEquals((Object)ImmutableList.of(), (Object)CONSTANT_LIKE.requiredColumns());
        Assert.assertEquals((Object)ImmutableList.of((Object)"z"), (Object)ZLIKE.requiredColumns());
        Assert.assertEquals((Object)ImmutableList.of((Object)"z", (Object)"x"), (Object)ZCONCATX.requiredColumns());
    }
}

