/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.filter;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.druid.data.input.InputRow;
import io.druid.data.input.impl.DimensionsSpec;
import io.druid.data.input.impl.InputRowParser;
import io.druid.data.input.impl.MapInputRowParser;
import io.druid.data.input.impl.ParseSpec;
import io.druid.data.input.impl.TimeAndDimsParseSpec;
import io.druid.data.input.impl.TimestampSpec;
import io.druid.java.util.common.DateTimes;
import io.druid.java.util.common.Pair;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.extraction.SubstringDimExtractionFn;
import io.druid.query.filter.DimFilter;
import io.druid.query.filter.LikeDimFilter;
import io.druid.segment.IndexBuilder;
import io.druid.segment.StorageAdapter;
import io.druid.segment.filter.BaseFilterTest;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import org.junit.AfterClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class LikeFilterTest
extends BaseFilterTest {
    private static final String TIMESTAMP_COLUMN = "timestamp";
    private static final InputRowParser<Map<String, Object>> PARSER = new MapInputRowParser((ParseSpec)new TimeAndDimsParseSpec(new TimestampSpec("timestamp", "iso", DateTimes.of((String)"2000")), new DimensionsSpec(null, null, null)));
    private static final List<InputRow> ROWS = ImmutableList.of(PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"0", (Object)"dim1", (Object)"")).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"1", (Object)"dim1", (Object)"foo")).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"2", (Object)"dim1", (Object)"foobar")).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"3", (Object)"dim1", (Object)"bar")).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"4", (Object)"dim1", (Object)"foobarbaz")).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"5", (Object)"dim1", (Object)"foo%bar")).get(0));

    public LikeFilterTest(String testName, IndexBuilder indexBuilder, Function<IndexBuilder, Pair<StorageAdapter, Closeable>> finisher, boolean cnf, boolean optimize) {
        super(testName, ROWS, indexBuilder, finisher, cnf, optimize);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        BaseFilterTest.tearDown(LikeFilterTest.class.getName());
    }

    @Test
    public void testExactMatch() {
        this.assertFilterMatches((DimFilter)new LikeDimFilter("dim1", "bar", null, null), (List<String>)ImmutableList.of((Object)"3"));
    }

    @Test
    public void testExactMatchWithEscape() {
        this.assertFilterMatches((DimFilter)new LikeDimFilter("dim1", "@bar", "@", null), (List<String>)ImmutableList.of((Object)"3"));
    }

    @Test
    public void testExactMatchWithExtractionFn() {
        this.assertFilterMatches((DimFilter)new LikeDimFilter("dim1", "bar", null, (ExtractionFn)new SubstringDimExtractionFn(3, Integer.valueOf(3))), (List<String>)ImmutableList.of((Object)"2", (Object)"4"));
    }

    @Test
    public void testPrefixMatch() {
        this.assertFilterMatches((DimFilter)new LikeDimFilter("dim1", "foo%", null, null), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"4", (Object)"5"));
    }

    @Test
    public void testPrefixMatchWithEscape() {
        this.assertFilterMatches((DimFilter)new LikeDimFilter("dim1", "foo@%%", "@", null), (List<String>)ImmutableList.of((Object)"5"));
    }

    @Test
    public void testPrefixMatchWithExtractionFn() {
        this.assertFilterMatches((DimFilter)new LikeDimFilter("dim1", "a%", null, (ExtractionFn)new SubstringDimExtractionFn(1, null)), (List<String>)ImmutableList.of((Object)"3"));
    }

    @Test
    public void testWildcardMatch() {
        this.assertFilterMatches((DimFilter)new LikeDimFilter("dim1", "%oba%", null, null), (List<String>)ImmutableList.of((Object)"2", (Object)"4"));
    }

    @Test
    public void testMatchEmptyString() {
        this.assertFilterMatches((DimFilter)new LikeDimFilter("dim1", "", null, null), (List<String>)ImmutableList.of((Object)"0"));
    }

    @Test
    public void testMatchEmptyStringWithExtractionFn() {
        this.assertFilterMatches((DimFilter)new LikeDimFilter("dim1", "", null, (ExtractionFn)new SubstringDimExtractionFn(100, Integer.valueOf(1))), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
    }

    @Test
    public void testWildcardMatchWithEscape() {
        this.assertFilterMatches((DimFilter)new LikeDimFilter("dim1", "%@%ba%", "@", null), (List<String>)ImmutableList.of((Object)"5"));
    }

    @Test
    public void testWildcardMatchEverything() {
        this.assertFilterMatches((DimFilter)new LikeDimFilter("dim1", "%", "@", null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
    }

    @Test
    public void testPrefixAndSuffixMatch() {
        this.assertFilterMatches((DimFilter)new LikeDimFilter("dim1", "f%r", null, null), (List<String>)ImmutableList.of((Object)"2", (Object)"5"));
    }

    @Test
    public void testUnderscoreMatch() {
        this.assertFilterMatches((DimFilter)new LikeDimFilter("dim1", "f_o", null, null), (List<String>)ImmutableList.of((Object)"1"));
    }

    @Test
    public void testSuffixMatchWithExtractionFn() {
        this.assertFilterMatches((DimFilter)new LikeDimFilter("dim1", "%ar", null, (ExtractionFn)new SubstringDimExtractionFn(3, Integer.valueOf(3))), (List<String>)ImmutableList.of((Object)"2", (Object)"4"));
    }
}

