/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.filter;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.druid.data.input.InputRow;
import io.druid.data.input.impl.DimensionsSpec;
import io.druid.data.input.impl.InputRowParser;
import io.druid.data.input.impl.MapInputRowParser;
import io.druid.data.input.impl.ParseSpec;
import io.druid.data.input.impl.TimeAndDimsParseSpec;
import io.druid.data.input.impl.TimestampSpec;
import io.druid.java.util.common.DateTimes;
import io.druid.java.util.common.Pair;
import io.druid.js.JavaScriptConfig;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.extraction.JavaScriptExtractionFn;
import io.druid.query.filter.AndDimFilter;
import io.druid.query.filter.BitmapIndexSelector;
import io.druid.query.filter.DimFilter;
import io.druid.query.filter.DruidDoublePredicate;
import io.druid.query.filter.DruidFloatPredicate;
import io.druid.query.filter.DruidLongPredicate;
import io.druid.query.filter.DruidPredicateFactory;
import io.druid.query.filter.Filter;
import io.druid.query.filter.OrDimFilter;
import io.druid.query.filter.SelectorDimFilter;
import io.druid.segment.IndexBuilder;
import io.druid.segment.StorageAdapter;
import io.druid.segment.filter.AndFilter;
import io.druid.segment.filter.BaseFilterTest;
import io.druid.segment.filter.DimensionPredicateFilter;
import io.druid.segment.filter.Filters;
import io.druid.segment.filter.SelectorFilter;
import java.io.Closeable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class FilterPartitionTest
extends BaseFilterTest {
    private static String JS_FN = "function(str) { return 'super-' + str; }";
    private static ExtractionFn JS_EXTRACTION_FN = new JavaScriptExtractionFn(JS_FN, false, JavaScriptConfig.getEnabledInstance());
    private static final String TIMESTAMP_COLUMN = "timestamp";
    private static final InputRowParser<Map<String, Object>> PARSER = new MapInputRowParser((ParseSpec)new TimeAndDimsParseSpec(new TimestampSpec("timestamp", "iso", DateTimes.of((String)"2000")), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"dim0", (Object)"dim1", (Object)"dim2", (Object)"dim3")), null, null)));
    private static final List<InputRow> ROWS = ImmutableList.of(PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"0", (Object)"dim1", (Object)"", (Object)"dim2", (Object)ImmutableList.of((Object)"a", (Object)"b"))).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"1", (Object)"dim1", (Object)"10", (Object)"dim2", (Object)ImmutableList.of())).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"2", (Object)"dim1", (Object)"2", (Object)"dim2", (Object)ImmutableList.of((Object)""))).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"3", (Object)"dim1", (Object)"1", (Object)"dim2", (Object)ImmutableList.of((Object)"a"))).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"4", (Object)"dim1", (Object)"def", (Object)"dim2", (Object)ImmutableList.of((Object)"c"))).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"5", (Object)"dim1", (Object)"abc")).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"6", (Object)"dim1", (Object)"B453B411", (Object)"dim2", (Object)ImmutableList.of((Object)"c", (Object)"d", (Object)"e"))).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"7", (Object)"dim1", (Object)"HELLO", (Object)"dim2", (Object)ImmutableList.of((Object)"foo"))).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"8", (Object)"dim1", (Object)"abc", (Object)"dim2", (Object)ImmutableList.of((Object)"bar"))).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"9", (Object)"dim1", (Object)"1", (Object)"dim2", (Object)ImmutableList.of((Object)"foo", (Object)"bar"))).get(0));

    public FilterPartitionTest(String testName, IndexBuilder indexBuilder, Function<IndexBuilder, Pair<StorageAdapter, Closeable>> finisher, boolean cnf, boolean optimize) {
        super(testName, ROWS, indexBuilder, finisher, cnf, optimize);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        BaseFilterTest.tearDown(FilterPartitionTest.class.getName());
    }

    @Test
    public void testSinglePreFilterWithNulls() {
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim1", null, null), (List<String>)ImmutableList.of((Object)"0"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim1", "", null), (List<String>)ImmutableList.of((Object)"0"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim1", "10", null), (List<String>)ImmutableList.of((Object)"1"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim1", "2", null), (List<String>)ImmutableList.of((Object)"2"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim1", "1", null), (List<String>)ImmutableList.of((Object)"3", (Object)"9"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim1", "def", null), (List<String>)ImmutableList.of((Object)"4"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim1", "abc", null), (List<String>)ImmutableList.of((Object)"5", (Object)"8"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim1", "ab", null), (List<String>)ImmutableList.of());
    }

    @Test
    public void testSinglePostFilterWithNulls() {
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim1", null, null), (List<String>)ImmutableList.of((Object)"0"));
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim1", "", null), (List<String>)ImmutableList.of((Object)"0"));
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim1", "10", null), (List<String>)ImmutableList.of((Object)"1"));
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim1", "2", null), (List<String>)ImmutableList.of((Object)"2"));
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim1", "1", null), (List<String>)ImmutableList.of((Object)"3", (Object)"9"));
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim1", "def", null), (List<String>)ImmutableList.of((Object)"4"));
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim1", "abc", null), (List<String>)ImmutableList.of((Object)"5", (Object)"8"));
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim1", "ab", null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim1", "super-null", JS_EXTRACTION_FN), (List<String>)ImmutableList.of((Object)"0"));
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim1", "super-null", JS_EXTRACTION_FN), (List<String>)ImmutableList.of((Object)"0"));
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim1", "super-10", JS_EXTRACTION_FN), (List<String>)ImmutableList.of((Object)"1"));
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim1", "super-2", JS_EXTRACTION_FN), (List<String>)ImmutableList.of((Object)"2"));
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim1", "super-1", JS_EXTRACTION_FN), (List<String>)ImmutableList.of((Object)"3", (Object)"9"));
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim1", "super-def", JS_EXTRACTION_FN), (List<String>)ImmutableList.of((Object)"4"));
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim1", "super-abc", JS_EXTRACTION_FN), (List<String>)ImmutableList.of((Object)"5", (Object)"8"));
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim1", "super-ab", JS_EXTRACTION_FN), (List<String>)ImmutableList.of());
    }

    @Test
    public void testBasicPreAndPostFilterWithNulls() {
        this.assertFilterMatches((DimFilter)new AndDimFilter(Arrays.asList(new DimFilter[]{new SelectorDimFilter("dim2", "a", null), new NoBitmapSelectorDimFilter("dim1", null, null)})), (List<String>)ImmutableList.of((Object)"0"));
        this.assertFilterMatches((DimFilter)new AndDimFilter(Arrays.asList(new DimFilter[]{new SelectorDimFilter("dim1", "10", null), new NoBitmapSelectorDimFilter("dim2", null, null)})), (List<String>)ImmutableList.of((Object)"1"));
        this.assertFilterMatches((DimFilter)new AndDimFilter(Arrays.asList(new DimFilter[]{new SelectorDimFilter("dim1", "1", null), new NoBitmapSelectorDimFilter("dim2", "foo", null)})), (List<String>)ImmutableList.of((Object)"9"));
        this.assertFilterMatches((DimFilter)new AndDimFilter(Arrays.asList(new DimFilter[]{new SelectorDimFilter("dim1", "HELLO", null), new NoBitmapSelectorDimFilter("dim2", "bar", null)})), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new AndDimFilter(Arrays.asList(new DimFilter[]{new NoBitmapSelectorDimFilter("dim2", "bar", null), new SelectorDimFilter("dim1", "NOT_A_VALUE", null)})), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new AndDimFilter(Arrays.asList(new DimFilter[]{new SelectorDimFilter("dim2", "super-a", JS_EXTRACTION_FN), new NoBitmapSelectorDimFilter("dim1", "super-null", JS_EXTRACTION_FN)})), (List<String>)ImmutableList.of((Object)"0"));
        this.assertFilterMatches((DimFilter)new AndDimFilter(Arrays.asList(new DimFilter[]{new SelectorDimFilter("dim1", "super-10", JS_EXTRACTION_FN), new NoBitmapSelectorDimFilter("dim2", "super-null", JS_EXTRACTION_FN)})), (List<String>)ImmutableList.of((Object)"1"));
        this.assertFilterMatches((DimFilter)new AndDimFilter(Arrays.asList(new DimFilter[]{new SelectorDimFilter("dim1", "super-2", JS_EXTRACTION_FN), new NoBitmapSelectorDimFilter("dim2", "super-null", JS_EXTRACTION_FN)})), (List<String>)ImmutableList.of((Object)"2"));
        this.assertFilterMatches((DimFilter)new AndDimFilter(Arrays.asList(new DimFilter[]{new SelectorDimFilter("dim1", "super-1", JS_EXTRACTION_FN), new NoBitmapSelectorDimFilter("dim2", "super-foo", JS_EXTRACTION_FN)})), (List<String>)ImmutableList.of((Object)"9"));
        this.assertFilterMatches((DimFilter)new AndDimFilter(Arrays.asList(new DimFilter[]{new SelectorDimFilter("dim1", "super-HELLO", JS_EXTRACTION_FN), new NoBitmapSelectorDimFilter("dim2", "super-bar", JS_EXTRACTION_FN)})), (List<String>)ImmutableList.of());
    }

    @Test
    public void testOrPostFilterWithNulls() {
        this.assertFilterMatches((DimFilter)new OrDimFilter(Arrays.asList(new DimFilter[]{new SelectorDimFilter("dim2", "a", null), new NoBitmapSelectorDimFilter("dim1", null, null)})), (List<String>)ImmutableList.of((Object)"0", (Object)"3"));
        this.assertFilterMatches((DimFilter)new OrDimFilter(Arrays.asList(new DimFilter[]{new SelectorDimFilter("dim1", "abc", null), new NoBitmapSelectorDimFilter("dim2", null, null)})), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"5", (Object)"8"));
        this.assertFilterMatches((DimFilter)new OrDimFilter(Arrays.asList(new DimFilter[]{new SelectorDimFilter("dim1", "2", null), new NoBitmapSelectorDimFilter("dim2", null, null)})), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"5"));
        this.assertFilterMatches((DimFilter)new OrDimFilter(Arrays.asList(new DimFilter[]{new SelectorDimFilter("dim1", "INVALID_VALUE", null), new NoBitmapSelectorDimFilter("dim2", "foo", null)})), (List<String>)ImmutableList.of((Object)"7", (Object)"9"));
        this.assertFilterMatches((DimFilter)new OrDimFilter(Arrays.asList(new DimFilter[]{new SelectorDimFilter("dim1", "HELLO", null), new NoBitmapSelectorDimFilter("dim2", "bar", null)})), (List<String>)ImmutableList.of((Object)"7", (Object)"8", (Object)"9"));
        this.assertFilterMatches((DimFilter)new OrDimFilter(Arrays.asList(new DimFilter[]{new NoBitmapSelectorDimFilter("dim1", "HELLO", null), new SelectorDimFilter("dim2", "NOT_A_VALUE", null)})), (List<String>)ImmutableList.of((Object)"7"));
        this.assertFilterMatches((DimFilter)new OrDimFilter(Arrays.asList(new DimFilter[]{new NoBitmapSelectorDimFilter("dim1", "INVALID", null), new SelectorDimFilter("dim2", "NOT_A_VALUE", null)})), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new OrDimFilter(Arrays.asList(new DimFilter[]{new SelectorDimFilter("dim2", "super-a", JS_EXTRACTION_FN), new NoBitmapSelectorDimFilter("dim1", "super-null", JS_EXTRACTION_FN)})), (List<String>)ImmutableList.of((Object)"0", (Object)"3"));
        this.assertFilterMatches((DimFilter)new OrDimFilter(Arrays.asList(new DimFilter[]{new SelectorDimFilter("dim1", "super-abc", JS_EXTRACTION_FN), new NoBitmapSelectorDimFilter("dim2", "super-null", JS_EXTRACTION_FN)})), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"5", (Object)"8"));
        this.assertFilterMatches((DimFilter)new OrDimFilter(Arrays.asList(new DimFilter[]{new SelectorDimFilter("dim1", "super-2", JS_EXTRACTION_FN), new NoBitmapSelectorDimFilter("dim2", "super-null", JS_EXTRACTION_FN)})), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"5"));
        this.assertFilterMatches((DimFilter)new OrDimFilter(Arrays.asList(new DimFilter[]{new SelectorDimFilter("dim1", "INVALID_VALUE", JS_EXTRACTION_FN), new NoBitmapSelectorDimFilter("dim2", "super-foo", JS_EXTRACTION_FN)})), (List<String>)ImmutableList.of((Object)"7", (Object)"9"));
        this.assertFilterMatches((DimFilter)new OrDimFilter(Arrays.asList(new DimFilter[]{new SelectorDimFilter("dim1", "super-HELLO", JS_EXTRACTION_FN), new NoBitmapSelectorDimFilter("dim2", "super-bar", JS_EXTRACTION_FN)})), (List<String>)ImmutableList.of((Object)"7", (Object)"8", (Object)"9"));
        this.assertFilterMatches((DimFilter)new OrDimFilter(Arrays.asList(new DimFilter[]{new NoBitmapSelectorDimFilter("dim1", "super-HELLO", JS_EXTRACTION_FN), new SelectorDimFilter("dim2", "NOT_A_VALUE", null)})), (List<String>)ImmutableList.of((Object)"7"));
        this.assertFilterMatches((DimFilter)new OrDimFilter(Arrays.asList(new DimFilter[]{new NoBitmapSelectorDimFilter("dim1", "INVALID", JS_EXTRACTION_FN), new SelectorDimFilter("dim2", "NOT_A_VALUE", JS_EXTRACTION_FN)})), (List<String>)ImmutableList.of());
    }

    @Test
    public void testMissingColumnSpecifiedInDimensionList() {
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim3", null, null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim3", "", null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim3", "a", null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim3", "b", null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim3", "c", null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new OrDimFilter(Arrays.asList(new DimFilter[]{new NoBitmapSelectorDimFilter("dim1", "abc", null), new SelectorDimFilter("dim3", "NOTHERE", null)})), (List<String>)ImmutableList.of((Object)"5", (Object)"8"));
        this.assertFilterMatches((DimFilter)new OrDimFilter(Arrays.asList(new DimFilter[]{new NoBitmapSelectorDimFilter("dim1", "abc", null), new SelectorDimFilter("dim3", null, null)})), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim3", "super-null", JS_EXTRACTION_FN), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim3", "super-null", JS_EXTRACTION_FN), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim3", "a", JS_EXTRACTION_FN), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim3", "b", JS_EXTRACTION_FN), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim3", "c", JS_EXTRACTION_FN), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new OrDimFilter(Arrays.asList(new DimFilter[]{new NoBitmapSelectorDimFilter("dim1", "super-abc", JS_EXTRACTION_FN), new SelectorDimFilter("dim3", "NOTHERE", JS_EXTRACTION_FN)})), (List<String>)ImmutableList.of((Object)"5", (Object)"8"));
        this.assertFilterMatches((DimFilter)new OrDimFilter(Arrays.asList(new DimFilter[]{new NoBitmapSelectorDimFilter("dim1", "abc", JS_EXTRACTION_FN), new SelectorDimFilter("dim3", "super-null", JS_EXTRACTION_FN)})), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
    }

    @Test
    public void testMissingColumnNotSpecifiedInDimensionList() {
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim4", null, null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim4", "", null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim4", "a", null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim4", "b", null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim4", "c", null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new OrDimFilter(Arrays.asList(new DimFilter[]{new NoBitmapSelectorDimFilter("dim1", "abc", null), new SelectorDimFilter("dim4", null, null)})), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
        this.assertFilterMatches((DimFilter)new OrDimFilter(Arrays.asList(new DimFilter[]{new NoBitmapSelectorDimFilter("dim4", null, null), new SelectorDimFilter("dim1", "abc", null)})), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim4", "super-null", JS_EXTRACTION_FN), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim4", "super-null", JS_EXTRACTION_FN), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim4", "a", JS_EXTRACTION_FN), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim4", "b", JS_EXTRACTION_FN), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim4", "c", JS_EXTRACTION_FN), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new OrDimFilter(Arrays.asList(new DimFilter[]{new NoBitmapSelectorDimFilter("dim1", "super-abc", JS_EXTRACTION_FN), new SelectorDimFilter("dim4", "super-null", JS_EXTRACTION_FN)})), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
        this.assertFilterMatches((DimFilter)new OrDimFilter(Arrays.asList(new DimFilter[]{new NoBitmapSelectorDimFilter("dim4", "super-null", JS_EXTRACTION_FN), new SelectorDimFilter("dim1", "super-abc", JS_EXTRACTION_FN)})), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
    }

    @Test
    public void testDistributeOrCNF() {
        OrDimFilter dimFilter1 = new OrDimFilter(Arrays.asList(new SelectorDimFilter("dim0", "6", null), new AndDimFilter(Arrays.asList(new DimFilter[]{new NoBitmapSelectorDimFilter("dim1", "def", null), new SelectorDimFilter("dim2", "c", null)}))));
        Filter filter1 = dimFilter1.toFilter();
        Filter filter1CNF = Filters.convertToCNF((Filter)filter1);
        Assert.assertEquals(AndFilter.class, filter1CNF.getClass());
        Assert.assertEquals((long)2L, (long)((AndFilter)filter1CNF).getFilters().size());
        this.assertFilterMatches((DimFilter)dimFilter1, (List<String>)ImmutableList.of((Object)"4", (Object)"6"));
        OrDimFilter dimFilter2 = new OrDimFilter(Arrays.asList(new SelectorDimFilter("dim0", "2", null), new SelectorDimFilter("dim0", "3", null), new AndDimFilter(Arrays.asList(new DimFilter[]{new NoBitmapSelectorDimFilter("dim1", "HELLO", null), new SelectorDimFilter("dim2", "foo", null)}))));
        this.assertFilterMatches((DimFilter)dimFilter2, (List<String>)ImmutableList.of((Object)"2", (Object)"3", (Object)"7"));
        OrDimFilter dimFilter3 = new OrDimFilter(Arrays.asList(dimFilter1, dimFilter2, new AndDimFilter(Arrays.asList(new DimFilter[]{new NoBitmapSelectorDimFilter("dim1", "1", null), new SelectorDimFilter("dim2", "foo", null)}))));
        this.assertFilterMatches((DimFilter)dimFilter3, (List<String>)ImmutableList.of((Object)"2", (Object)"3", (Object)"4", (Object)"6", (Object)"7", (Object)"9"));
    }

    @Test
    public void testDistributeOrCNFExtractionFn() {
        OrDimFilter dimFilter1 = new OrDimFilter(Arrays.asList(new SelectorDimFilter("dim0", "super-6", JS_EXTRACTION_FN), new AndDimFilter(Arrays.asList(new DimFilter[]{new NoBitmapSelectorDimFilter("dim1", "super-def", JS_EXTRACTION_FN), new SelectorDimFilter("dim2", "super-c", JS_EXTRACTION_FN)}))));
        Filter filter1 = dimFilter1.toFilter();
        Filter filter1CNF = Filters.convertToCNF((Filter)filter1);
        Assert.assertEquals(AndFilter.class, filter1CNF.getClass());
        Assert.assertEquals((long)2L, (long)((AndFilter)filter1CNF).getFilters().size());
        this.assertFilterMatches((DimFilter)dimFilter1, (List<String>)ImmutableList.of((Object)"4", (Object)"6"));
        OrDimFilter dimFilter2 = new OrDimFilter(Arrays.asList(new SelectorDimFilter("dim0", "super-2", JS_EXTRACTION_FN), new SelectorDimFilter("dim0", "super-3", JS_EXTRACTION_FN), new AndDimFilter(Arrays.asList(new DimFilter[]{new NoBitmapSelectorDimFilter("dim1", "super-HELLO", JS_EXTRACTION_FN), new SelectorDimFilter("dim2", "super-foo", JS_EXTRACTION_FN)}))));
        this.assertFilterMatches((DimFilter)dimFilter2, (List<String>)ImmutableList.of((Object)"2", (Object)"3", (Object)"7"));
        OrDimFilter dimFilter3 = new OrDimFilter(new DimFilter[]{dimFilter1, dimFilter2, new AndDimFilter(new DimFilter[]{new NoBitmapSelectorDimFilter("dim1", "super-1", JS_EXTRACTION_FN), new SelectorDimFilter("dim2", "super-foo", JS_EXTRACTION_FN)})});
        this.assertFilterMatches((DimFilter)dimFilter3, (List<String>)ImmutableList.of((Object)"2", (Object)"3", (Object)"4", (Object)"6", (Object)"7", (Object)"9"));
    }

    private static class NoBitmapSelectorDimFilter
    extends SelectorDimFilter {
        public NoBitmapSelectorDimFilter(String dimension, String value, ExtractionFn extractionFn) {
            super(dimension, value, extractionFn);
        }

        public Filter toFilter() {
            ExtractionFn extractionFn = this.getExtractionFn();
            String dimension = this.getDimension();
            String value = this.getValue();
            if (extractionFn == null) {
                return new NoBitmapSelectorFilter(dimension, value);
            }
            final String valueOrNull = Strings.emptyToNull((String)value);
            DruidPredicateFactory predicateFactory = new DruidPredicateFactory(){

                public Predicate<String> makeStringPredicate() {
                    return input -> Objects.equals(valueOrNull, input);
                }

                public DruidLongPredicate makeLongPredicate() {
                    return input -> Objects.equals(valueOrNull, String.valueOf(input));
                }

                public DruidFloatPredicate makeFloatPredicate() {
                    return input -> Objects.equals(valueOrNull, String.valueOf(input));
                }

                public DruidDoublePredicate makeDoublePredicate() {
                    return input -> Objects.equals(valueOrNull, String.valueOf(input));
                }
            };
            return new NoBitmapDimensionPredicateFilter(dimension, predicateFactory, extractionFn);
        }
    }

    private static class NoBitmapDimensionPredicateFilter
    extends DimensionPredicateFilter {
        public NoBitmapDimensionPredicateFilter(String dimension, DruidPredicateFactory predicateFactory, ExtractionFn extractionFn) {
            super(dimension, predicateFactory, extractionFn);
        }

        public boolean supportsBitmapIndex(BitmapIndexSelector selector) {
            return false;
        }
    }

    private static class NoBitmapSelectorFilter
    extends SelectorFilter {
        public NoBitmapSelectorFilter(String dimension, String value) {
            super(dimension, value);
        }

        public boolean supportsBitmapIndex(BitmapIndexSelector selector) {
            return false;
        }
    }
}

