/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.filter;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.druid.data.input.InputRow;
import io.druid.data.input.impl.DimensionsSpec;
import io.druid.data.input.impl.FloatDimensionSchema;
import io.druid.data.input.impl.InputRowParser;
import io.druid.data.input.impl.LongDimensionSchema;
import io.druid.data.input.impl.MapInputRowParser;
import io.druid.data.input.impl.ParseSpec;
import io.druid.data.input.impl.StringDimensionSchema;
import io.druid.data.input.impl.TimeAndDimsParseSpec;
import io.druid.data.input.impl.TimestampSpec;
import io.druid.java.util.common.DateTimes;
import io.druid.java.util.common.Pair;
import io.druid.query.expression.TestExprMacroTable;
import io.druid.query.filter.DimFilter;
import io.druid.query.filter.ExpressionDimFilter;
import io.druid.segment.IndexBuilder;
import io.druid.segment.StorageAdapter;
import io.druid.segment.filter.BaseFilterTest;
import io.druid.segment.filter.ColumnComparisonFilterTest;
import io.druid.segment.incremental.IncrementalIndexSchema;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.junit.AfterClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ExpressionFilterTest
extends BaseFilterTest {
    private static final String TIMESTAMP_COLUMN = "timestamp";
    private static final InputRowParser<Map<String, Object>> PARSER = new MapInputRowParser((ParseSpec)new TimeAndDimsParseSpec(new TimestampSpec("timestamp", "iso", DateTimes.of((String)"2000")), new DimensionsSpec((List)ImmutableList.of((Object)new StringDimensionSchema("dim0"), (Object)new LongDimensionSchema("dim1"), (Object)new FloatDimensionSchema("dim2"), (Object)new StringDimensionSchema("dim3"), (Object)new StringDimensionSchema("dim4")), null, null)));
    private static final List<InputRow> ROWS = ImmutableList.of((Object)ImmutableMap.of((Object)"dim0", (Object)"0", (Object)"dim1", (Object)0L, (Object)"dim2", (Object)Float.valueOf(0.0f), (Object)"dim3", (Object)"", (Object)"dim4", (Object)ImmutableList.of((Object)"1", (Object)"2")), (Object)ImmutableMap.of((Object)"dim0", (Object)"1", (Object)"dim1", (Object)1L, (Object)"dim2", (Object)Float.valueOf(1.0f), (Object)"dim3", (Object)"10", (Object)"dim4", (Object)ImmutableList.of()), (Object)ImmutableMap.of((Object)"dim0", (Object)"2", (Object)"dim1", (Object)2L, (Object)"dim2", (Object)Float.valueOf(2.0f), (Object)"dim3", (Object)"2", (Object)"dim4", (Object)ImmutableList.of((Object)"")), (Object)ImmutableMap.of((Object)"dim0", (Object)"3", (Object)"dim1", (Object)3L, (Object)"dim2", (Object)Float.valueOf(3.0f), (Object)"dim3", (Object)"1", (Object)"dim4", (Object)ImmutableList.of((Object)"3")), (Object)ImmutableMap.of((Object)"dim0", (Object)"4", (Object)"dim1", (Object)4L, (Object)"dim2", (Object)Float.valueOf(4.0f), (Object)"dim3", (Object)"1", (Object)"dim4", (Object)ImmutableList.of((Object)"4", (Object)"5")), (Object)ImmutableMap.of((Object)"dim0", (Object)"5", (Object)"dim1", (Object)5L, (Object)"dim2", (Object)Float.valueOf(5.0f), (Object)"dim3", (Object)"5", (Object)"dim4", (Object)ImmutableList.of((Object)"4", (Object)"5")), (Object)ImmutableMap.of((Object)"dim0", (Object)"6", (Object)"dim1", (Object)6L, (Object)"dim2", (Object)Float.valueOf(6.0f), (Object)"dim3", (Object)"1"), (Object)ImmutableMap.of((Object)"dim0", (Object)"7", (Object)"dim1", (Object)7L, (Object)"dim2", (Object)Float.valueOf(7.0f), (Object)"dim3", (Object)"a"), (Object)ImmutableMap.of((Object)"dim0", (Object)"8", (Object)"dim1", (Object)8L, (Object)"dim2", (Object)Float.valueOf(8.0f), (Object)"dim3", (Object)8L), (Object)ImmutableMap.of((Object)"dim0", (Object)"9", (Object)"dim1", (Object)9L, (Object)"dim2", (Object)Float.valueOf(9.0f), (Object)"dim3", (Object)Float.valueOf(1.234f), (Object)"dim4", (Object)Float.valueOf(1.234f))).stream().map(e -> (InputRow)PARSER.parseBatch(e).get(0)).collect(Collectors.toList());

    public ExpressionFilterTest(String testName, IndexBuilder indexBuilder, Function<IndexBuilder, Pair<StorageAdapter, Closeable>> finisher, boolean cnf, boolean optimize) {
        super(testName, ROWS, indexBuilder.schema(new IncrementalIndexSchema.Builder().withDimensionsSpec(PARSER.getParseSpec().getDimensionsSpec()).build()), finisher, cnf, optimize);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        BaseFilterTest.tearDown(ColumnComparisonFilterTest.class.getName());
    }

    @Test
    public void testOneSingleValuedStringColumn() {
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.EDF("dim3 == ''"), (List<String>)ImmutableList.of((Object)"0"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.EDF("dim3 == '1'"), (List<String>)ImmutableList.of((Object)"3", (Object)"4", (Object)"6"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.EDF("dim3 == 'a'"), (List<String>)ImmutableList.of((Object)"7"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.EDF("dim3 == 1"), (List<String>)ImmutableList.of((Object)"3", (Object)"4", (Object)"6"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.EDF("dim3 == 1.0"), (List<String>)ImmutableList.of((Object)"3", (Object)"4", (Object)"6"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.EDF("dim3 == 1.234"), (List<String>)ImmutableList.of((Object)"9"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.EDF("dim3 < '2'"), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"3", (Object)"4", (Object)"6", (Object)"9"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.EDF("dim3 < 2"), (List<String>)ImmutableList.of((Object)"0", (Object)"3", (Object)"4", (Object)"6", (Object)"7", (Object)"9"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.EDF("dim3 < 2.0"), (List<String>)ImmutableList.of((Object)"0", (Object)"3", (Object)"4", (Object)"6", (Object)"7", (Object)"9"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.EDF("like(dim3, '1%')"), (List<String>)ImmutableList.of((Object)"1", (Object)"3", (Object)"4", (Object)"6", (Object)"9"));
    }

    @Test
    public void testOneMultiValuedStringColumn() {
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.EDF("dim4 == ''"), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.EDF("dim4 == '1'"), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.EDF("dim4 == '3'"), (List<String>)ImmutableList.of((Object)"3"));
    }

    @Test
    public void testOneLongColumn() {
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.EDF("dim1 == ''"), (List<String>)ImmutableList.of((Object)"0"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.EDF("dim1 == '1'"), (List<String>)ImmutableList.of((Object)"1"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.EDF("dim1 == 2"), (List<String>)ImmutableList.of((Object)"2"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.EDF("dim1 < '2'"), (List<String>)ImmutableList.of((Object)"0", (Object)"1"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.EDF("dim1 < 2"), (List<String>)ImmutableList.of((Object)"0", (Object)"1"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.EDF("dim1 < 2.0"), (List<String>)ImmutableList.of((Object)"0", (Object)"1"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.EDF("like(dim1, '1%')"), (List<String>)ImmutableList.of((Object)"1"));
    }

    @Test
    public void testOneFloatColumn() {
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.EDF("dim2 == ''"), (List<String>)ImmutableList.of((Object)"0"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.EDF("dim2 == '1'"), (List<String>)ImmutableList.of((Object)"1"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.EDF("dim2 == 2"), (List<String>)ImmutableList.of((Object)"2"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.EDF("dim2 < '2'"), (List<String>)ImmutableList.of((Object)"0", (Object)"1"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.EDF("dim2 < 2"), (List<String>)ImmutableList.of((Object)"0", (Object)"1"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.EDF("dim2 < 2.0"), (List<String>)ImmutableList.of((Object)"0", (Object)"1"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.EDF("like(dim2, '1%')"), (List<String>)ImmutableList.of((Object)"1"));
    }

    @Test
    public void testConstantExpression() {
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.EDF("1 + 1"), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.EDF("0 + 0"), (List<String>)ImmutableList.of());
    }

    @Test
    public void testCompareColumns() {
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.EDF("dim0 == dim3"), (List<String>)ImmutableList.of((Object)"2", (Object)"5", (Object)"8"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.EDF("dim1 == dim3"), (List<String>)ImmutableList.of((Object)"0", (Object)"2", (Object)"5", (Object)"8"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.EDF("dim2 == dim3"), (List<String>)ImmutableList.of((Object)"0", (Object)"2", (Object)"5", (Object)"8"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.EDF("dim0 == dim4"), (List<String>)ImmutableList.of((Object)"3"));
    }

    @Test
    public void testMissingColumn() {
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.EDF("missing == ''"), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.EDF("missing == '1'"), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.EDF("missing == 2"), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.EDF("missing < '2'"), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.EDF("missing < 2"), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.EDF("missing < 2.0"), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.EDF("missing > '2'"), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.EDF("missing > 2"), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.EDF("missing > 2.0"), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.EDF("like(missing, '1%')"), (List<String>)ImmutableList.of());
    }

    private static ExpressionDimFilter EDF(String expression) {
        return new ExpressionDimFilter(expression, TestExprMacroTable.INSTANCE);
    }
}

