/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import io.druid.segment.data.ArrayBasedIndexedInts;
import io.druid.segment.data.IndexedInts;
import io.druid.segment.data.VSizeColumnarInts;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IndexedIntsTest {
    private static final int[] array = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
    private final IndexedInts indexed;

    @Parameterized.Parameters
    public static Collection<?> constructorFeeder() throws IOException {
        return Arrays.asList({VSizeColumnarInts.fromArray((int[])array)}, {ArrayBasedIndexedInts.of((int[])array)});
    }

    public IndexedIntsTest(IndexedInts indexed) {
        this.indexed = indexed;
    }

    @Test
    public void testSanity() throws Exception {
        Assert.assertEquals((long)array.length, (long)this.indexed.size());
        for (int i = 0; i < array.length; ++i) {
            Assert.assertEquals((long)array[i], (long)this.indexed.get(i));
        }
    }
}

